/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlock;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlockEntity;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class RemoteControllerBlock
extends ElevatorInputBlock {
    public RemoteControllerBlock(BlockProperties properties) {
        super(properties, (BiFunction<BlockPos, BlockState, ? extends ElevatorInputBlockEntity>)((BiFunction<BlockPos, BlockState, ElevatorInputBlockEntity>)RemoteControllerBlockEntity::new));
    }

    @Override
    protected boolean onRightClick(BlockState state, Level level, CamoBlockEntity blockEntity, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        if (super.onRightClick(state, level, blockEntity, pos, player, hand, hitSide, hitLocation)) {
            return true;
        }
        if (blockEntity instanceof RemoteControllerBlockEntity) {
            if (level.f_46443_) {
                BlockPos controllerPos = ((RemoteControllerBlockEntity)blockEntity).getControllerPos();
                MutableComponent x = TextComponents.number((int)controllerPos.m_123341_()).color(ChatFormatting.GOLD).get();
                MutableComponent y = TextComponents.number((int)controllerPos.m_123342_()).color(ChatFormatting.GOLD).get();
                MutableComponent z = TextComponents.number((int)controllerPos.m_123343_()).color(ChatFormatting.GOLD).get();
                player.m_5661_((Component)TextComponents.translation((String)"movingelevators.remote_controller.controller_location", (Object[])new Object[]{x, y, z}).get(), true);
            }
            return true;
        }
        return false;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof RemoteControllerBlockEntity) {
            CompoundTag compound = stack.m_41783_();
            if (compound == null || !compound.m_128441_("controllerDim")) {
                return;
            }
            ((RemoteControllerBlockEntity)entity).setValues(placer.m_6350_().m_122424_(), new BlockPos(compound.m_128451_("controllerX"), compound.m_128451_("controllerY"), compound.m_128451_("controllerZ")), compound.m_128425_("controllerFacing", 3) ? Direction.m_122407_((int)compound.m_128451_("controllerFacing")) : null);
        }
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("controllerDim")) {
            info.accept((Component)TextComponents.translation((String)"movingelevators.remote_controller.tooltip").color(ChatFormatting.AQUA).get());
        } else {
            MutableComponent x = TextComponents.number((int)tag.m_128451_("controllerX")).color(ChatFormatting.GOLD).get();
            MutableComponent y = TextComponents.number((int)tag.m_128451_("controllerY")).color(ChatFormatting.GOLD).get();
            MutableComponent z = TextComponents.number((int)tag.m_128451_("controllerZ")).color(ChatFormatting.GOLD).get();
            MutableComponent dimension = TextComponents.dimension((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("controllerDim")))).color(ChatFormatting.GOLD).get();
            info.accept((Component)TextComponents.translation((String)"movingelevators.remote_controller.tooltip.bound", (Object[])new Object[]{x, y, z, dimension}).get());
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        Object entity = level.m_7702_(pos);
        if (entity instanceof RemoteControllerBlockEntity && (entity = ((RemoteControllerBlockEntity)((Object)entity)).getController()) != null && ((ControllerBlockEntity)((Object)entity)).hasGroup() && ((ControllerBlockEntity)((Object)entity)).getGroup().isCageAvailableAt((ControllerBlockEntity)((Object)entity))) {
            return 15;
        }
        return 0;
    }
}

