/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.core.render.RenderWorldEvent;
import com.supermartijn642.movingelevators.elevator.ClientElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ElevatorGroupRenderer {
    public static boolean isIrisRenderingShadows = false;

    private static boolean isWithinRenderDistance(ElevatorGroup group) {
        GameRenderer renderer = ClientUtils.getMinecraft().f_91063_;
        if (renderer == null) {
            return false;
        }
        float renderDistance = renderer.m_109152_() + 8.0f + (float)group.getCageSizeX() / 2.0f + (float)group.getCageSizeZ() / 2.0f;
        BlockPos playerPos = ClientUtils.getPlayer().m_20183_();
        float distance = (group.x - playerPos.m_123341_()) * (group.x - playerPos.m_123341_()) + (group.z - playerPos.m_123343_()) * (group.z - playerPos.m_123343_());
        return distance < renderDistance * renderDistance;
    }

    @SubscribeEvent
    public static void onRender(RenderWorldEvent e) {
        if (!ClientUtils.getMinecraft().m_91290_().m_114377_()) {
            return;
        }
        ElevatorGroupCapability groups = ElevatorGroupCapability.get(ClientUtils.getWorld());
        e.getPoseStack().m_85836_();
        Vec3 camera = RenderUtils.getCameraPosition();
        e.getPoseStack().m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
        for (ElevatorGroup group : groups.getGroups()) {
            if (!ElevatorGroupRenderer.isWithinRenderDistance(group)) continue;
            ElevatorGroupRenderer.renderGroupCageOutlines(e.getPoseStack(), group);
        }
        e.getPoseStack().m_85849_();
    }

    public static void renderBlocks(PoseStack poseStack, RenderType renderType, MultiBufferSource bufferSource) {
        ElevatorGroupCapability groups = ElevatorGroupCapability.get(ClientUtils.getWorld());
        poseStack.m_85836_();
        Vec3 camera = RenderUtils.getCameraPosition();
        poseStack.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
        VertexConsumer buffer = null;
        for (ElevatorGroup group : groups.getGroups()) {
            if (!group.isMoving() || !ElevatorGroupRenderer.isWithinRenderDistance(group)) continue;
            if (buffer == null) {
                buffer = bufferSource.m_6299_(renderType);
            }
            ElevatorGroupRenderer.renderGroupBlocks(poseStack, group, renderType, buffer, ClientUtils.getPartialTicks());
        }
        poseStack.m_85849_();
    }

    public static void renderBlockEntities(PoseStack poseStack, float partialTicks, MultiBufferSource bufferSource) {
        ElevatorGroupCapability groups = ElevatorGroupCapability.get(ClientUtils.getWorld());
        poseStack.m_85836_();
        Vec3 camera = RenderUtils.getCameraPosition();
        poseStack.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
        for (ElevatorGroup group : groups.getGroups()) {
            if (!group.isMoving() || !ElevatorGroupRenderer.isWithinRenderDistance(group)) continue;
            ElevatorGroupRenderer.renderGroupBlockEntities(poseStack, group, bufferSource, partialTicks);
        }
        poseStack.m_85849_();
    }

    public static void renderGroupBlocks(PoseStack poseStack, ElevatorGroup group, RenderType renderType, VertexConsumer buffer, float partialTicks) {
        ClientElevatorCage cage = (ClientElevatorCage)group.getCage();
        double lastY = group.getLastY();
        double currentY = group.getCurrentY();
        double renderY = lastY + (currentY - lastY) * (double)partialTicks;
        Vec3 startPos = group.getCageAnchorPos(renderY);
        BlockPos anchorPos = new BlockPos((int)startPos.f_82479_, (int)startPos.f_82480_, (int)startPos.f_82481_);
        cage.loadRenderInfo(anchorPos, group);
        Level level = ClientElevatorCage.getFakeLevel();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    if (cage.blockStates[x][y][z] == null) continue;
                    poseStack.m_85836_();
                    poseStack.m_85837_(startPos.f_82479_ + (double)x, startPos.f_82480_ + (double)y, startPos.f_82481_ + (double)z);
                    BlockState state = cage.blockStates[x][y][z];
                    if (state.m_60799_() == RenderShape.MODEL) {
                        BakedModel model = ClientUtils.getBlockRenderer().m_110910_(state);
                        ModelData modelData = cage.blockEntities[x][y][z] == null ? ModelData.EMPTY : cage.blockEntities[x][y][z].getModelData();
                        if (model.getRenderTypes(state, level.f_46441_, modelData = model.getModelData((BlockAndTintGetter)level, (BlockPos)pos, state, modelData)).contains(renderType)) {
                            pos.m_122178_(anchorPos.m_123341_() + x, anchorPos.m_123342_() + y, anchorPos.m_123343_() + z);
                            ClientUtils.getBlockRenderer().renderBatched(state, (BlockPos)pos, (BlockAndTintGetter)level, poseStack, buffer, true, level.f_46441_, modelData, renderType);
                        }
                    }
                    poseStack.m_85849_();
                }
            }
        }
    }

    public static void renderGroupBlockEntities(PoseStack poseStack, ElevatorGroup group, MultiBufferSource buffer, float partialTicks) {
        ClientElevatorCage cage = (ClientElevatorCage)group.getCage();
        double lastY = group.getLastY();
        double currentY = group.getCurrentY();
        double renderY = lastY + (currentY - lastY) * (double)partialTicks;
        Vec3 startPos = group.getCageAnchorPos(renderY);
        BlockPos anchorPos = new BlockPos((int)startPos.f_82479_, (int)startPos.f_82480_, (int)startPos.f_82481_);
        cage.loadRenderInfo(anchorPos, group);
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    if (cage.blockEntities[x][y][z] == null) continue;
                    poseStack.m_85836_();
                    poseStack.m_85837_(startPos.f_82479_ + (double)x, startPos.f_82480_ + (double)y, startPos.f_82481_ + (double)z);
                    BlockEntity entity = cage.blockEntities[x][y][z];
                    ClientUtils.getMinecraft().m_167982_().m_112267_(entity, partialTicks, poseStack, buffer);
                    poseStack.m_85849_();
                }
            }
        }
    }

    public static void renderGroupCageOutlines(PoseStack poseStack, ElevatorGroup group) {
        for (int floor = 0; floor < group.getFloorCount(); ++floor) {
            BlockPos anchorPos = group.getCageAnchorBlockPos(group.getFloorYLevel(floor));
            AABB cageArea = new AABB(anchorPos, anchorPos.m_7918_(group.getCageSizeX(), group.getCageSizeY(), group.getCageSizeZ()));
            cageArea.m_82400_(0.01);
            RenderUtils.renderBox((PoseStack)poseStack, (AABB)cageArea, (float)1.0f, (float)1.0f, (float)1.0f, (boolean)true);
        }
        if (group.isMoving()) {
            ElevatorCage cage = group.getCage();
            double lastY = group.getLastY();
            double currentY = group.getCurrentY();
            double renderY = lastY + (currentY - lastY) * (double)ClientUtils.getPartialTicks();
            Vec3 startPos = group.getCageAnchorPos(renderY);
            RenderUtils.renderBox((PoseStack)poseStack, (AABB)new AABB(startPos, startPos.m_82520_((double)group.getCageSizeX(), (double)group.getCageSizeY(), (double)group.getCageSizeZ())), (float)1.0f, (float)0.0f, (float)0.0f, (boolean)true);
            RenderUtils.renderShape((PoseStack)poseStack, (VoxelShape)cage.shape.m_83216_(startPos.f_82479_, startPos.f_82480_, startPos.f_82481_), (float)0.19215687f, (float)0.8784314f, (float)0.85882354f, (boolean)true);
        }
    }
}

