/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui.preview;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.movingelevators.gui.preview.WorldBlockCapture;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public class ElevatorPreviewRenderer {
    public static void renderPreview(WorldBlockCapture capture, AABB cabinBox, AABB previewBox, double x, double y, double scale, float yaw, float pitch, boolean doShading) {
        AABB bounds = capture.getBounds();
        Vec3 center = bounds.m_82399_();
        double span = Math.sqrt(bounds.m_82362_() * bounds.m_82362_() + bounds.m_82376_() * bounds.m_82376_() + bounds.m_82385_() * bounds.m_82385_());
        scale /= span;
        RenderSystem.getModelViewStack().m_85836_();
        RenderSystem.getModelViewStack().m_85841_(1.0f, -1.0f, 1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack poseStack = new PoseStack();
        poseStack.m_85837_(x, -y, 350.0);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        poseStack.m_252781_(new Quaternionf().setAngleAxis((double)(pitch / 180.0f) * Math.PI, 1.0, 0.0, 0.0));
        poseStack.m_252781_(new Quaternionf().setAngleAxis((double)(yaw / 180.0f) * Math.PI, 0.0, 1.0, 0.0));
        poseStack.m_85837_(-center.f_82479_, -center.f_82480_, -center.f_82481_);
        if (doShading) {
            Lighting.m_84931_();
        }
        MultiBufferSource.BufferSource renderTypeBuffer = RenderUtils.getMainBufferSource();
        for (BlockPos pos : capture.getBlockLocations()) {
            ElevatorPreviewRenderer.renderBlock(capture, pos, poseStack, (MultiBufferSource)renderTypeBuffer);
        }
        renderTypeBuffer.m_109911_();
        RenderSystem.enableDepthTest();
        if (doShading) {
            Lighting.m_84930_();
        }
        RenderUtils.renderBox((PoseStack)poseStack, (AABB)cabinBox, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f, (boolean)true);
        if (previewBox != null) {
            RenderUtils.renderBox((PoseStack)poseStack, (AABB)previewBox, (float)0.0f, (float)0.7f, (float)0.0f, (float)0.8f, (boolean)true);
        }
        RenderSystem.getModelViewStack().m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private static void renderBlock(WorldBlockCapture capture, BlockPos pos, PoseStack poseStack, MultiBufferSource renderTypeBuffer) {
        BlockEntity blockEntity;
        poseStack.m_85836_();
        poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        BlockState state = capture.getBlockState(pos);
        if (state.m_60734_() != Blocks.f_50016_) {
            BakedModel model = ClientUtils.getBlockRenderer().m_110910_(state);
            ModelData modelData = ModelData.EMPTY;
            RandomSource random = RandomSource.m_216335_((long)42L);
            for (RenderType renderType : model.getRenderTypes(state, random, modelData)) {
                ElevatorPreviewRenderer.renderModel(model, capture, state, pos, poseStack, renderTypeBuffer.m_6299_(renderType), modelData, renderType);
                random.m_188584_(42L);
            }
        }
        if ((blockEntity = capture.getBlockEntity(pos)) != null) {
            ClientUtils.getMinecraft().m_167982_().m_112267_(blockEntity, ClientUtils.getPartialTicks(), poseStack, renderTypeBuffer);
        }
        poseStack.m_85849_();
    }

    private static void renderModel(BakedModel model, WorldBlockCapture capture, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer buffer, ModelData modelData, RenderType renderType) {
        RandomSource random = RandomSource.m_216327_();
        for (Direction direction : Direction.values()) {
            random.m_188584_(42L);
            ElevatorPreviewRenderer.renderQuads(capture, state, pos, poseStack, buffer, model.getQuads(state, direction, random, modelData, renderType));
        }
        random.m_188584_(42L);
        ElevatorPreviewRenderer.renderQuads(capture, state, pos, poseStack, buffer, model.getQuads(state, null, random, modelData, renderType));
    }

    private static void renderQuads(WorldBlockCapture capture, BlockState state, BlockPos pos, PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads) {
        PoseStack.Pose matrix = poseStack.m_85850_();
        for (BakedQuad bakedquad : quads) {
            float red = 1.0f;
            float blue = 1.0f;
            float green = 1.0f;
            float alpha = 1.0f;
            if (bakedquad.m_111304_()) {
                int color = ClientUtils.getMinecraft().m_91298_().m_92577_(state, (BlockAndTintGetter)capture.getWorld(), pos, bakedquad.m_111305_());
                red = (float)(color >> 16 & 0xFF) / 255.0f;
                green = (float)(color >> 8 & 0xFF) / 255.0f;
                blue = (float)(color & 0xFF) / 255.0f;
            }
            buffer.putBulkData(matrix, bakedquad, red, green, blue, alpha, 0xF000F0, OverlayTexture.f_118083_, false);
        }
    }
}

