/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.entity;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.CompoundTagBuilder;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.EntityFunction;
import com.sk89q.worldedit.internal.helper.MCDirections;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.entity.EntityTypes;

public class ExtentEntityCopy
implements EntityFunction {
    private final Extent destination;
    private final Vector3 from;
    private final Vector3 to;
    private final Transform transform;
    private boolean removing;

    public ExtentEntityCopy(Vector3 from, Extent destination, Vector3 to, Transform transform) {
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)destination);
        Preconditions.checkNotNull((Object)to);
        Preconditions.checkNotNull((Object)transform);
        this.destination = destination;
        this.from = from;
        this.to = to;
        this.transform = transform;
    }

    public boolean isRemoving() {
        return this.removing;
    }

    public void setRemoving(boolean removing) {
        this.removing = removing;
    }

    @Override
    public boolean apply(Entity entity) throws WorldEditException {
        BaseEntity state = entity.getState();
        if (state != null) {
            boolean success;
            boolean hasTilePosition;
            Location location = entity.getLocation();
            CompoundTag tag = state.getNbtData();
            boolean bl = hasTilePosition = tag != null && tag.containsKey("TileX") && tag.containsKey("TileY") && tag.containsKey("TileZ");
            if (hasTilePosition) {
                location = location.setPosition(Vector3.at(tag.asInt("TileX"), tag.asInt("TileY"), tag.asInt("TileZ")).add(0.5, 0.5, 0.5));
            }
            Vector3 pivot = this.from.round().add(0.5, 0.5, 0.5);
            Vector3 newPosition = this.transform.apply(location.toVector().subtract(pivot));
            if (hasTilePosition) {
                newPosition = newPosition.subtract(0.5, 0.5, 0.5);
            }
            Vector3 newDirection = this.transform.isIdentity() ? entity.getLocation().getDirection() : this.transform.apply(location.getDirection()).subtract(this.transform.apply(Vector3.ZERO)).normalize();
            Location newLocation = new Location(this.destination, newPosition.add(this.to.round().add(0.5, 0.5, 0.5)), newDirection);
            state = this.transformNbtData(state);
            boolean bl2 = success = this.destination.createEntity(newLocation, state) != null;
            if (this.isRemoving() && success) {
                entity.remove();
            }
            return success;
        }
        return false;
    }

    private BaseEntity transformNbtData(BaseEntity state) {
        CompoundTag tag = state.getNbtData();
        if (tag != null) {
            CompoundTag leashCompound;
            Tag leashTag = (Tag)tag.getValue().get("Leash");
            if (leashTag instanceof CompoundTag && (leashCompound = (CompoundTag)leashTag).containsKey("X")) {
                Vector3 tilePosition = Vector3.at(leashCompound.asInt("X"), leashCompound.asInt("Y"), leashCompound.asInt("Z"));
                BlockVector3 newLeash = this.transform.apply(tilePosition.subtract(this.from)).add(this.to).toBlockPoint();
                return new BaseEntity(state.getType(), tag.createBuilder().put("Leash", leashCompound.createBuilder().putInt("X", newLeash.getBlockX()).putInt("Y", newLeash.getBlockY()).putInt("Z", newLeash.getBlockZ()).build()).build());
            }
            boolean hasTilePosition = tag.containsKey("TileX") && tag.containsKey("TileY") && tag.containsKey("TileZ");
            boolean hasFacing = tag.containsKey("Facing");
            if (hasTilePosition) {
                Vector3 tilePosition = Vector3.at(tag.asInt("TileX"), tag.asInt("TileY"), tag.asInt("TileZ"));
                BlockVector3 newTilePosition = this.transform.apply(tilePosition.subtract(this.from)).add(this.to).toBlockPoint();
                CompoundTagBuilder builder = tag.createBuilder().putInt("TileX", newTilePosition.getBlockX()).putInt("TileY", newTilePosition.getBlockY()).putInt("TileZ", newTilePosition.getBlockZ());
                if (hasFacing) {
                    Vector3 vector;
                    Direction newDirection;
                    Direction direction;
                    boolean isPainting = state.getType() == EntityTypes.PAINTING;
                    Direction direction2 = direction = isPainting ? MCDirections.fromHorizontalHanging(tag.asInt("Facing")) : MCDirections.fromHanging(tag.asInt("Facing"));
                    if (direction != null && (newDirection = Direction.findClosest(vector = this.transform.apply(direction.toVector()).subtract(this.transform.apply(Vector3.ZERO)).normalize(), Direction.Flag.CARDINAL)) != null) {
                        builder.putByte("Facing", (byte)(isPainting ? MCDirections.toHorizontalHanging(newDirection) : MCDirections.toHanging(newDirection)));
                    }
                }
                return new BaseEntity(state.getType(), builder.build());
            }
        }
        return state;
    }
}

