/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class FiniteFluidInteraction
implements FaucetTarget.Fluid,
FaucetSource.Fluid {
    @Override
    public Integer fill(Level level, BlockPos pos, FluidState existing, SoftFluidStack fluid, int minAmount) {
        Fluid vanillaF = fluid.getVanillaFluid();
        if (vanillaF instanceof FiniteFluid) {
            FiniteFluid ff = (FiniteFluid)vanillaF;
            int oldLayers = 0;
            if (existing.m_76152_().m_6212_(vanillaF)) {
                oldLayers = existing.m_76186_();
            } else if (!existing.m_76178_()) {
                return null;
            }
            int maxLayers = ff.getLayersPerBlock();
            int missingLayers = maxLayers - oldLayers;
            if (missingLayers <= 0) {
                return 0;
            }
            float offerLayers = this.bottlesToLayers(ff, 1);
            float extraLayers = Math.min((float)missingLayers, offerLayers);
            float consumed = this.layersToBottles(ff, extraLayers);
            level.m_46597_(pos, ff.makeState((int)((float)oldLayers + extraLayers)).m_76188_());
            return Math.min(Mth.m_14143_((float)consumed), fluid.getCount());
        }
        return null;
    }

    @Override
    @Nullable
    public FluidOffer getProvidedFluid(Level level, BlockPos pos, Direction dir, FluidState source) {
        FiniteFluid ff;
        int amount;
        Fluid fluid = source.m_76152_();
        if (fluid instanceof FiniteFluid && (amount = this.layersToBottles(ff = (FiniteFluid)fluid, source.m_76186_())) > 0) {
            return FluidOffer.of(SoftFluidStack.fromFluid((Fluid)ff, (int)amount, null));
        }
        return null;
    }

    @Override
    public void drain(Level level, BlockPos pos, Direction dir, FluidState source, int amount) {
        FiniteFluid ff = (FiniteFluid)source.m_76152_();
        int drainedLayers = this.bottlesToLayers(ff, amount);
        int newLayers = Math.max(0, source.m_76186_() - drainedLayers);
        if (newLayers == 0) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        } else {
            level.m_46597_(pos, ff.makeState(newLayers).m_76188_());
        }
    }

    private int layersToBottles(FiniteFluid ff, float layers) {
        int maxLayers = ff.getLayersPerBlock();
        float bottleToLayers = (float)maxLayers / 4.0f;
        return (int)(layers / bottleToLayers);
    }

    private int bottlesToLayers(FiniteFluid ff, int bottles) {
        int maxLayers = ff.getLayersPerBlock();
        float bottleToLayers = (float)maxLayers / 4.0f;
        return (int)((float)bottles * bottleToLayers);
    }
}

