/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.worldgen.RoadSignFeature;
import net.mehvahdjukaar.supplementaries.common.worldgen.StructureLocator;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockGeneratorBlockTile
extends BlockEntity {
    private static final ExecutorService EXECUTORS = Executors.newCachedThreadPool();
    private CompletableFuture<List<StructureLocator.LocatedStruct>> threadResult;
    private boolean firstTick = true;
    private RoadSignFeature.Config config = null;

    public BlockGeneratorBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.BLOCK_GENERATOR_TILE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockGeneratorBlockTile tile) {
        if (tile.firstTick) {
            tile.firstTick = false;
            tile.threadResult = CompletableFuture.supplyAsync(() -> StructureLocator.findNearestMapFeatures((ServerLevel)level, ModTags.WAY_SIGN_DESTINATIONS, pos, 250, false, 2, 8), EXECUTORS).exceptionally(exception -> {
                Supplementaries.LOGGER.error("Failed to generate road sign at " + String.valueOf(pos) + ": " + String.valueOf(exception));
                return null;
            });
            return;
        }
        if (tile.config == null || tile.threadResult == null || tile.threadResult.isCompletedExceptionally()) {
            level.m_7471_(pos, false);
            return;
        }
        if (tile.threadResult.isDone()) {
            try {
                RoadSignFeature.applyPostProcess(tile.config, (ServerLevel)level, pos, tile.threadResult.get());
            }
            catch (Exception e) {
                level.m_7471_(pos, false);
                Supplementaries.LOGGER.error("Failed to generate road sign at " + String.valueOf(pos) + ": " + String.valueOf(e));
            }
        }
    }

    public void setConfig(RoadSignFeature.Config c) {
        this.config = c;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.config != null) {
            tag.m_128365_("config", (Tag)RoadSignFeature.Config.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.config).getOrThrow(false, s -> {}));
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("config")) {
            this.config = (RoadSignFeature.Config)((Pair)RoadSignFeature.Config.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("config")).getOrThrow(true, s -> {})).getFirst();
        }
    }
}

