/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.inventories;

import net.mehvahdjukaar.moonlight.api.misc.IContainerProvider;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.inventories.DelegatingSlot;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class VariableSizeContainerMenu
extends AbstractContainerMenu
implements IContainerProvider {
    public final Container inventory;
    public final int unlockedSlots;
    private static final int[][] TARGET_RATIOS = new int[][]{{1, 1}, {2, 2}, {3, 2}, {3, 3}, {4, 2}, {5, 2}, {6, 2}, {7, 2}, {5, 3}, {8, 2}, {6, 3}, {7, 3}, {8, 3}, {9, 3}};

    public static <C extends BlockEntity & MenuProvider> void openTileMenu(Player player, C tile) {
        PlatHelper.openCustomMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)tile, p -> {
            p.writeBoolean(true);
            p.m_130064_(tile.m_58899_());
            p.writeInt(((Container)tile).m_6643_());
        });
    }

    public static <C extends Entity & MenuProvider> void openEntityMenu(Player player, C entity) {
        PlatHelper.openCustomMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)entity, p -> {
            p.writeBoolean(false);
            p.m_130130_(entity.m_19879_());
            p.writeInt(((Container)entity).m_6643_());
        });
    }

    public Container getContainer() {
        return this.inventory;
    }

    public VariableSizeContainerMenu(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, VariableSizeContainerMenu.getContainerFromPacket(playerInventory, packetBuffer), packetBuffer.readInt());
    }

    @NotNull
    private static Container getContainerFromPacket(Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        boolean isBlockPos = packetBuffer.readBoolean();
        Level level = playerInventory.f_35978_.m_9236_();
        if (isBlockPos) {
            BlockPos pos = packetBuffer.m_130135_();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof Container) {
                Container c = (Container)blockEntity;
                return c;
            }
        } else {
            Entity e = level.m_6815_(packetBuffer.m_130242_());
            if (e instanceof Container) {
                Container c = (Container)e;
                return c;
            }
            if (e instanceof IContainerProvider) {
                IContainerProvider c = (IContainerProvider)e;
                return c.getContainer();
            }
        }
        throw new UnsupportedOperationException("Cannot find container associated with entity ");
    }

    public VariableSizeContainerMenu(int id, Inventory playerInventory, Container container, int unlockedSlots) {
        super(ModMenuTypes.VARIABLE_SIZE.get(), id);
        int si;
        this.inventory = container;
        this.unlockedSlots = unlockedSlots;
        VariableSizeContainerMenu.m_38869_((Container)container, (int)unlockedSlots);
        container.m_5856_(playerInventory.f_35978_);
        int[] dims = VariableSizeContainerMenu.getRatio(unlockedSlots);
        if (dims[0] > 9) {
            dims[0] = 9;
            dims[1] = (int)Math.ceil((float)unlockedSlots / 9.0f);
        }
        int yp = 44 - 9 * dims[1];
        int dimx = 0;
        for (int h = 0; h < dims[1]; ++h) {
            int dimXPrev = dimx;
            dimx = Math.min(dims[0], unlockedSlots);
            int xp = 89 - dimx * 18 / 2;
            for (int j = 0; j < dimx; ++j) {
                this.m_38897_(new DelegatingSlot(container, j + h * dimXPrev, xp + j * 18, yp + 18 * h, this));
            }
            unlockedSlots -= dims[0];
        }
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.m_38897_(new Slot((Container)playerInventory, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.m_38897_(new Slot((Container)playerInventory, si, 8 + si * 18, 142));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return this.inventory.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack item = slot.m_7993_();
            itemstack = item.m_41777_();
            int activeSlots = CommonConfigs.Functional.SACK_SLOTS.get();
            if (index < activeSlots ? !this.m_38903_(item, activeSlots, this.f_38839_.size(), true) : !this.m_38903_(item, 0, activeSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (item.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.inventory.m_5785_(playerIn);
    }

    public static int[] getRatio(int maxSize) {
        int[] dims = new int[]{Math.min(maxSize, 23), Math.max(maxSize / 23, 1)};
        for (int[] testAgainst : TARGET_RATIOS) {
            if (testAgainst[0] * testAgainst[1] != maxSize) continue;
            dims = testAgainst;
            break;
        }
        return dims;
    }
}

