/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.utils.CoordinatesUtil;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartMetadata;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.AABB;
import gollorum.signpost.utils.math.geometry.Intersectable;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.OptionalSerializer;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WaystoneBlockPart
implements BlockPart<WaystoneBlockPart>,
WithOwner.OfWaystone {
    private Optional<PlayerHandle> owner;
    private static final AABB BOUNDS = new AABB(new Vector3(-3.0f, -8.0f, -3.0f), new Vector3(3.0f, -2.0f, 3.0f)).map(CoordinatesUtil::voxelToLocal);
    public static final BlockPartMetadata<WaystoneBlockPart> METADATA = new BlockPartMetadata<WaystoneBlockPart>("Waystone", WaystoneBlockPart::writeTo, compound -> new WaystoneBlockPart((Optional<PlayerHandle>)((OptionalSerializer)PlayerHandle.Serializer.optional()).read(compound.m_128469_("owner"))), WaystoneBlockPart.class);

    public WaystoneBlockPart(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    public WaystoneBlockPart(PlayerHandle owner) {
        this.owner = Optional.of(owner);
    }

    @Override
    public Intersectable<Ray, Float> getIntersection() {
        return BOUNDS;
    }

    @Override
    public Interactable.InteractionResult interact(InteractionInfo info) {
        WaystoneBlock.onRightClick(info.player.m_9236_(), info.tile.m_58899_(), info.player);
        return Interactable.InteractionResult.Accepted;
    }

    @Override
    public BlockPartMetadata<WaystoneBlockPart> getMeta() {
        return METADATA;
    }

    @Override
    public void writeTo(CompoundTag compound) {
        compound.m_128365_("owner", (Tag)((OptionalSerializer)PlayerHandle.Serializer.optional()).write(this.owner, new CompoundTag()));
    }

    @Override
    public void readMutationUpdate(CompoundTag compound, BlockEntity tile, Player editingPlayer) {
        if (compound.m_128441_("owner")) {
            this.owner = ((OptionalSerializer)PlayerHandle.Serializer.optional()).read(compound.m_128469_("owner"));
        }
    }

    @Override
    public boolean hasThePermissionToEdit(WithOwner tile, @Nullable Player player) {
        return true;
    }

    @Override
    public Collection<ItemStack> getDrops(PostTile tile) {
        return Collections.singleton(new ItemStack((ItemLike)WaystoneBlock.getInstance().m_5456_()));
    }

    @Override
    public void removeFrom(PostTile tile) {
        if (tile.m_58898_() && !tile.m_58904_().m_5776_()) {
            Optional<WorldLocation> location = WorldLocation.from(tile);
            if (location.isPresent()) {
                WaystoneLibrary.getInstance().removeAt(location.get(), PlayerHandle.Invalid);
            } else {
                Signpost.LOGGER.error("Waystone tile at " + tile.m_58899_() + "  was removed but world was null. This means that the waystone has not been cleaned up correctly.");
            }
            this.getWaystoneOwner().ifPresent(o -> BlockRestrictions.getInstance().incrementRemaining(BlockRestrictions.Type.Waystone, (PlayerHandle)o));
        }
    }

    @Override
    public Optional<PlayerHandle> getWaystoneOwner() {
        return this.owner;
    }

    @Override
    public Collection<Texture> getAllTextures() {
        return Collections.singleton(new Texture(TextureResource.waystoneTextureLocation));
    }
}

