/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.BlockPartRenderer;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.Tint;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.modelGeneration.SignModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class SignRenderer<T extends SignBlockPart<T>>
extends BlockPartRenderer<T> {
    private final boolean shouldRenderBaked = true;

    protected abstract BakedModel makeBakedModel(T var1);

    protected abstract BakedModel makeBakedOverlayModel(T var1, Overlay var2);

    protected abstract SignModel makeModel(T var1);

    protected abstract SignModel makeOverlayModel(T var1, Overlay var2);

    @Override
    public void render(T sign, BlockEntity tileEntity, BlockEntityRenderDispatcher renderDispatcher, PoseStack blockToView, PoseStack localToBlock, MultiBufferSource buffer, int combinedLights, int combinedOverlay, RandomSource random, long randomSeed) {
        if (((SignBlockPart)sign).isMarkedForGeneration() && !Config.Server.worldGen.debugMode()) {
            return;
        }
        if (!tileEntity.m_58898_()) {
            throw new RuntimeException("TileEntity without world cannot be rendered.");
        }
        RenderingUtil.wrapInMatrixEntry(localToBlock, () -> {
            Quaternionf rotation = new Quaternionf(new AxisAngle4f(sign.getAngle().get().radians(), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)));
            localToBlock.m_252781_(rotation);
            RenderingUtil.wrapInMatrixEntry(blockToView, () -> {
                blockToView.m_252931_(localToBlock.m_85850_().m_252922_());
                if (!sign.isFlipped()) {
                    blockToView.m_252781_(new Quaternionf(new AxisAngle4d(Math.PI, new Vector3f(0.0f, 1.0f, 0.0f))));
                }
                this.renderText(sign, blockToView, renderDispatcher.f_112253_, buffer, combinedLights);
            });
            int[] tints = new int[]{sign.getMainTexture().tint().map(t -> t.getColorAt((BlockAndTintGetter)tileEntity.m_58904_(), tileEntity.m_58899_())).orElse(0xFFFFFF), sign.getSecondaryTexture().tint().map(t -> t.getColorAt((BlockAndTintGetter)tileEntity.m_58904_(), tileEntity.m_58899_())).orElse(0xFFFFFF)};
            RenderingUtil.render(blockToView, localToBlock.m_85850_().m_252922_(), this.makeBakedModel(sign), tileEntity.m_58904_(), tileEntity.m_58900_(), tileEntity.m_58899_(), buffer.m_6299_(RenderType.m_110451_()), false, random, randomSeed, combinedOverlay, tints);
            sign.getOverlay().ifPresent(o -> RenderingUtil.render(blockToView, localToBlock.m_85850_().m_252922_(), this.makeBakedOverlayModel(sign, (Overlay)o), tileEntity.m_58904_(), tileEntity.m_58900_(), tileEntity.m_58899_(), buffer.m_6299_(RenderType.m_110457_()), false, random, randomSeed, combinedOverlay, new int[]{o.tint.map(t -> t.getColorAt((BlockAndTintGetter)tileEntity.m_58904_(), tileEntity.m_58899_())).orElse(0xFFFFFF)}));
        });
    }

    protected abstract void renderText(T var1, PoseStack var2, Font var3, MultiBufferSource var4, int var5);

    @Override
    public void renderGui(T sign, PoseStack matrixStack, Point center, Angle yaw, Angle pitch, boolean isFlipped, float scale, Vector3 offset) {
        if (((SignBlockPart)sign).isMarkedForGeneration() && !Config.Server.worldGen.debugMode()) {
            return;
        }
        int[] tints = new int[]{((SignBlockPart)sign).getMainTexture().tint().map(t -> t.getColorAt((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91074_.m_20183_())).orElse(0xFFFFFF), ((SignBlockPart)sign).getSecondaryTexture().tint().map(t -> t.getColorAt((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91074_.m_20183_())).orElse(0xFFFFFF)};
        RenderingUtil.renderGui(this.makeBakedModel(sign), matrixStack, tints, center, yaw.add(((SignBlockPart)sign).getAngle().get()), pitch, isFlipped, scale, offset, RenderType.m_110451_(), ms -> RenderingUtil.wrapInMatrixEntry(ms, () -> {
            if (!sign.isFlipped()) {
                ms.m_252781_(new Quaternionf(new AxisAngle4d(Math.PI, new Vector3f(0.0f, 1.0f, 0.0f))));
            }
            this.renderText(sign, (PoseStack)ms, Minecraft.m_91087_().f_91062_, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0xF000F0);
        }));
        ((SignBlockPart)sign).getOverlay().ifPresent(o -> RenderingUtil.renderGui(this.makeBakedOverlayModel(sign, (Overlay)o), matrixStack, new int[]{o.tint.map(t -> t.getColorAt((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91074_.m_20183_())).orElse(0xFFFFFF)}, center, yaw.add(sign.getAngle().get()), pitch, isFlipped, scale, offset, RenderType.m_110463_(), m -> {}));
    }

    @Override
    public void renderGui(T sign, PoseStack matrixStack, Vector3 offset, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (((SignBlockPart)sign).isMarkedForGeneration() && !Config.Server.worldGen.debugMode()) {
            return;
        }
        int[] tints = new int[]{((SignBlockPart)sign).getMainTexture().tint().map(t -> t.getColorAt((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91074_.m_20183_())).orElse(0xFFFFFF), ((SignBlockPart)sign).getSecondaryTexture().tint().map(t -> t.getColorAt((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91074_.m_20183_())).orElse(0xFFFFFF)};
        RenderingUtil.renderGui(this.makeBakedModel(sign), matrixStack, tints, offset, ((SignBlockPart)sign).getAngle().get(), buffer.m_6299_(RenderType.m_110451_()), RenderType.m_110451_(), combinedLight, combinedOverlay, ms -> RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            if (!sign.isFlipped()) {
                matrixStack.m_252781_(new Quaternionf(new AxisAngle4d(Math.PI, new Vector3f(0.0f, 1.0f, 0.0f))));
            }
            this.renderText(sign, (PoseStack)ms, Minecraft.m_91087_().f_91062_, buffer, combinedLight);
        }));
        ((SignBlockPart)sign).getOverlay().ifPresent(o -> RenderingUtil.renderGui(this.makeBakedOverlayModel(sign, (Overlay)o), matrixStack, new int[]{o.tint.map(t -> t.getColorAt((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91074_.m_20183_())).orElse(0xFFFFFF)}, offset, sign.getAngle().get(), buffer.m_6299_(RenderType.m_110463_()), RenderType.m_110451_(), combinedLight, combinedOverlay, m -> {}));
    }

    private static /* synthetic */ Integer lambda$render$4(BlockEntity tileEntity, Tint t) {
        return t.getColorAt((BlockAndTintGetter)tileEntity.m_58904_(), tileEntity.m_58899_());
    }
}

