/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PropertiesUtil;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.RequestSignGui;
import gollorum.signpost.minecraft.utils.Texture;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.security.WithCountRestriction;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.BufferSerializable;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.network.PacketDistributor;

public class PostBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WithCountRestriction {
    public static final DirectionProperty Facing = BlockStateProperties.f_61374_;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final String REGISTRY_NAME = "post";
    public static final Variant STONE = new Variant(PropertiesUtil.STONE, ModelType.Stone, "stone", Variant.RequiredTool.Pickaxe);
    public static final Variant IRON = new Variant(PropertiesUtil.IRON, ModelType.Iron, "iron", Variant.RequiredTool.Pickaxe);
    public static final Variant OAK = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Oak), ModelType.Oak, "oak", Variant.RequiredTool.Axe);
    public static final Variant DARK_OAK = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.DarkOak), ModelType.DarkOak, "dark_oak", Variant.RequiredTool.Axe);
    public static final Variant SPRUCE = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Spruce), ModelType.Spruce, "spruce", Variant.RequiredTool.Axe);
    public static final Variant BIRCH = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Birch), ModelType.Birch, "birch", Variant.RequiredTool.Axe);
    public static final Variant JUNGLE = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Jungle), ModelType.Jungle, "jungle", Variant.RequiredTool.Axe);
    public static final Variant ACACIA = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Acacia), ModelType.Acacia, "acacia", Variant.RequiredTool.Axe);
    public static final Variant MANGROVE = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Mangrove), ModelType.Mangrove, "mangrove", Variant.RequiredTool.Axe);
    public static final Variant BAMBOO = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Bamboo), ModelType.Bamboo, "bamboo", Variant.RequiredTool.Axe);
    public static final Variant CHERRY = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Cherry), ModelType.Cherry, "cherry", Variant.RequiredTool.Axe);
    public static final Variant WARPED = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Warped), ModelType.Warped, "warped", Variant.RequiredTool.Axe);
    public static final Variant CRIMSON = new Variant(PropertiesUtil.wood(PropertiesUtil.WoodType.Crimson), ModelType.Crimson, "crimson", Variant.RequiredTool.Axe);
    public static final Variant SANDSTONE = new Variant(PropertiesUtil.STONE, ModelType.Sandstone, "sandstone", Variant.RequiredTool.Pickaxe);
    public static final Variant BROWN_MUSHROOM = new Variant(PropertiesUtil.mushroom(MapColor.f_283762_), ModelType.BrownMushroom, "brown_mushroom", Variant.RequiredTool.Axe);
    public static final Variant RED_MUSHROOM = new Variant(PropertiesUtil.mushroom(MapColor.f_283913_), ModelType.RedMushroom, "red_mushroom", Variant.RequiredTool.Axe);
    public static final List<Variant> AllVariants = Arrays.asList(OAK, BIRCH, SPRUCE, JUNGLE, DARK_OAK, ACACIA, MANGROVE, BAMBOO, CHERRY, STONE, IRON, WARPED, CRIMSON, SANDSTONE, BROWN_MUSHROOM, RED_MUSHROOM);
    public final ModelType type;

    public static Block[] getAllBlocks() {
        return (Block[])AllVariants.stream().map(Variant::getBlock).toArray(Block[]::new);
    }

    private PostBlock(BlockBehaviour.Properties properties, ModelType type) {
        super(properties.m_60955_());
        this.type = type;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack currentStack) {
        super.m_6402_(world, pos, state, placer, currentStack);
        ItemStack stack = currentStack.m_41777_();
        Delay.forFrames(6, world.m_5776_(), () -> TileEntityUtils.delayUntilTileEntityExists((LevelAccessor)world, pos, PostTile.getBlockEntityType(), tile -> {
            tile.setSignpostOwner(Optional.of(PlayerHandle.from((Entity)placer)));
            boolean shouldAddNewSign = placer instanceof ServerPlayer;
            if (!world.m_5776_()) {
                if (stack.m_41782_() && stack.m_41783_().m_128441_("Parts")) {
                    tile.readParts(stack.m_41783_().m_128469_("Parts"));
                    shouldAddNewSign = false;
                } else {
                    tile.addPart(new BlockPartInstance(new PostBlockPart(this.type.postTexture), Vector3.ZERO), ItemStack.f_41583_, PlayerHandle.from((Entity)placer));
                }
                tile.m_6596_();
                world.m_7260_(pos, state, state, 3);
                if (shouldAddNewSign) {
                    PacketHandler.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)placer), new RequestSignGui.ForNewSign.Package(new WorldLocation(pos, world), tile.modelType, new Vector3(0.0f, 1.0f, 0.0f), ItemStack.f_41583_));
                }
            }
        }, 100, Optional.of(() -> Signpost.LOGGER.error("Could not initialize placed signpost: BlockEntity never appeared."))));
    }

    private void dropPartItems(PostTile tile, Level world, BlockPos pos) {
        NonNullList drops = NonNullList.m_122779_();
        drops.addAll(tile.getDrops());
        Containers.m_19010_((Level)world, (BlockPos)pos, (NonNullList)drops);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity tile, ItemStack item) {
        if (!player.m_7500_() && tile instanceof PostTile && !EnchantmentHelper.m_44831_((ItemStack)item).containsKey(Enchantments.f_44985_)) {
            this.dropPartItems((PostTile)tile, world, pos);
        }
        super.m_6240_(world, player, pos, state, tile, item);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack ret = super.getCloneItemStack(state, target, world, pos, player);
        world.m_141902_(pos, PostTile.getBlockEntityType()).ifPresent(tile -> {
            if (!ret.m_41782_()) {
                ret.m_41751_(new CompoundTag());
            }
            ret.m_41783_().m_128365_("Parts", tile.writeParts(false));
        });
        return ret;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity t = world.m_7702_(pos);
        return t instanceof PostTile ? ((PostTile)t).getBounds() : Shapes.m_83040_();
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PostTile(this.type, new ItemStack((ItemLike)this), pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{Facing}).m_61104_(new Property[]{WATERLOGGED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, worldIn, pos, context);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (!(tileEntity instanceof PostTile)) {
            return InteractionResult.SUCCESS;
        }
        PostTile tile = (PostTile)tileEntity;
        return PostBlock.onActivate(tile, world, player, hand);
    }

    public static InteractionResult onActivate(PostTile tile, Level world, Player player, InteractionHand hand) {
        return switch (tile.trace((Entity)player).map(p -> p.part.blockPart.interact(new InteractionInfo(InteractionInfo.Type.RightClick, player, hand, tile, (PostTile.TraceResult)p, data -> tile.notifyMutation(p.id, (CompoundTag)data, p.part.blockPart.getMeta().identifier), world.m_5776_()))).orElse(Interactable.InteractionResult.Ignored)) {
            default -> throw new IncompatibleClassChangeError();
            case Interactable.InteractionResult.Accepted -> InteractionResult.SUCCESS;
            case Interactable.InteractionResult.Ignored -> InteractionResult.PASS;
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState res = super.m_5573_(context);
        if (res == null) {
            res = this.m_49966_();
        }
        return (BlockState)((BlockState)res.m_61124_((Property)Facing, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (!state.m_61138_((Property)Facing)) {
            return state;
        }
        return (BlockState)state.m_61124_((Property)Facing, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)Facing)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        if (!state.m_61138_((Property)Facing)) {
            return state;
        }
        return (BlockState)state.m_61124_((Property)Facing, (Comparable)((Direction)state.m_61143_((Property)Facing)).m_122424_());
    }

    @Override
    public BlockRestrictions.Type getBlockRestrictionType() {
        return BlockRestrictions.Type.Signpost;
    }

    public static class ModelType {
        private static final Map<String, ModelType> allTypes = new HashMap<String, ModelType>();
        public static final ModelType Acacia = new ModelType("acacia", new ResourceLocation("acacia_log"), new ResourceLocation("stripped_acacia_log"), new ResourceLocation("acacia_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42442_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13186_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42442_})));
        public static final ModelType Birch = new ModelType("birch", new ResourceLocation("birch_log"), new ResourceLocation("stripped_birch_log"), new ResourceLocation("birch_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42440_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13185_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42440_})));
        public static final ModelType Iron = new ModelType("iron", new ResourceLocation("iron_block"), new ResourceLocation("signpost", "iron"), new ResourceLocation("signpost", "iron_dark"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13157_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})));
        public static final ModelType Jungle = new ModelType("jungle", new ResourceLocation("jungle_log"), new ResourceLocation("stripped_jungle_log"), new ResourceLocation("jungle_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42441_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13187_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42441_})));
        public static final ModelType Oak = new ModelType("oak", new ResourceLocation("oak_log"), new ResourceLocation("stripped_oak_log"), new ResourceLocation("oak_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42438_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13184_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42438_})));
        public static final ModelType DarkOak = new ModelType("darkoak", new ResourceLocation("dark_oak_log"), new ResourceLocation("stripped_dark_oak_log"), new ResourceLocation("dark_oak_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42443_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13183_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42443_})));
        public static final ModelType Spruce = new ModelType("spruce", new ResourceLocation("spruce_log"), new ResourceLocation("stripped_spruce_log"), new ResourceLocation("spruce_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42439_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13188_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42439_})));
        public static final ModelType Mangrove = new ModelType("mangrove", new ResourceLocation("mangrove_log"), new ResourceLocation("stripped_mangrove_log"), new ResourceLocation("mangrove_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_220209_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_215869_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_220209_})));
        public static final ModelType Bamboo = new ModelType("bamboo", new ResourceLocation("bamboo_block"), new ResourceLocation("stripped_bamboo_block"), new ResourceLocation("bamboo_block"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_244057_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_256904_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_244057_})));
        public static final ModelType Cherry = new ModelType("cherry", new ResourceLocation("cherry_log"), new ResourceLocation("stripped_cherry_log"), new ResourceLocation("cherry_log"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_271504_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_271202_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_271504_})));
        public static final ModelType Stone = new ModelType("stone", new ResourceLocation("stone"), new ResourceLocation("stone"), new ResourceLocation("signpost", "stone_dark"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13157_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41905_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41905_})));
        public static final ModelType RedMushroom = new ModelType("red_mushroom", new ResourceLocation("red_mushroom_block"), new ResourceLocation("mushroom_stem"), new ResourceLocation("red_mushroom_block"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13157_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42023_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41953_})));
        public static final ModelType BrownMushroom = new ModelType("brown_mushroom", new ResourceLocation("brown_mushroom_block"), new ResourceLocation("mushroom_stem"), new ResourceLocation("brown_mushroom_block"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13157_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42022_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41952_})));
        public static final ModelType Warped = new ModelType("warped", new ResourceLocation("warped_stem"), new ResourceLocation("stripped_warped_stem"), new ResourceLocation("warped_stem"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42445_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13190_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42445_})));
        public static final ModelType Crimson = new ModelType("crimson", new ResourceLocation("crimson_stem"), new ResourceLocation("stripped_crimson_stem"), new ResourceLocation("crimson_stem"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42444_})), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13189_)), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42444_})));
        private static final Lazy<Ingredient> sandstone = Lazy.of(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50062_, Blocks.f_50064_, Blocks.f_50063_, Blocks.f_50471_}));
        public static final ModelType Sandstone = new ModelType("sandstone", new ResourceLocation("sandstone"), new ResourceLocation("stripped_jungle_log"), new ResourceLocation("sandstone_bottom"), (Lazy<Ingredient>)Lazy.of(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13157_)), sandstone, sandstone);
        public final String name;
        public final Texture postTexture;
        public final Texture mainTexture;
        public final Texture secondaryTexture;
        public final Lazy<Ingredient> signIngredient;
        public final Lazy<Ingredient> baseIngredient;
        public final Lazy<Ingredient> addSignIngredient;
        public static BufferSerializable<ModelType> Serializer;

        public static void register(ModelType modelType, String name) {
            allTypes.put(name, modelType);
        }

        public static void register(ModelType modelType) {
            ModelType.register(modelType, modelType.name);
        }

        public static Optional<ModelType> getByName(String name, boolean logErrorIfNotPresent) {
            if (allTypes.containsKey(name)) {
                return Optional.of(allTypes.get(name));
            }
            if (logErrorIfNotPresent) {
                Signpost.LOGGER.error("Tried to get invalid model type " + name);
            }
            return Optional.empty();
        }

        public static Optional<ModelType> from(Item signItem) {
            return allTypes.values().stream().filter(t -> ((Ingredient)t.addSignIngredient.get()).test(new ItemStack((ItemLike)signItem))).findFirst();
        }

        ModelType(String name, ResourceLocation postTexture, ResourceLocation mainTexture, ResourceLocation secondaryTexture, Lazy<Ingredient> signIngredient, Lazy<Ingredient> baseIngredient, Lazy<Ingredient> addSignIngredient) {
            this.name = name;
            this.postTexture = ModelType.expand(postTexture);
            this.mainTexture = ModelType.expand(mainTexture);
            this.secondaryTexture = ModelType.expand(secondaryTexture);
            this.signIngredient = signIngredient;
            this.baseIngredient = baseIngredient;
            this.addSignIngredient = addSignIngredient;
        }

        ModelType(String name, Texture postTexture, Texture mainTexture, Texture secondaryTexture, Lazy<Ingredient> signIngredient, Lazy<Ingredient> baseIngredient, Lazy<Ingredient> addSignIngredient) {
            this.name = name;
            this.postTexture = postTexture;
            this.mainTexture = mainTexture;
            this.secondaryTexture = secondaryTexture;
            this.signIngredient = signIngredient;
            this.baseIngredient = baseIngredient;
            this.addSignIngredient = addSignIngredient;
        }

        private static Texture expand(ResourceLocation loc) {
            return new Texture(new ResourceLocation(loc.m_135827_(), (String)(loc.m_135815_().startsWith("block/") ? loc.m_135815_() : "block/" + loc.m_135815_())), Optional.empty());
        }

        static {
            ModelType.register(Acacia);
            ModelType.register(Birch);
            ModelType.register(Iron);
            ModelType.register(Stone);
            ModelType.register(Jungle);
            ModelType.register(Oak);
            ModelType.register(DarkOak);
            ModelType.register(Spruce);
            ModelType.register(Mangrove);
            ModelType.register(Bamboo);
            ModelType.register(Cherry);
            ModelType.register(Warped);
            ModelType.register(Crimson);
            ModelType.register(Sandstone);
            ModelType.register(BrownMushroom);
            ModelType.register(RedMushroom);
            Serializer = new SerializerImpl();
        }

        public static final class SerializerImpl
        implements BufferSerializable<ModelType> {
            @Override
            public Class<ModelType> getTargetClass() {
                return ModelType.class;
            }

            @Override
            public void write(ModelType modelType, FriendlyByteBuf buffer) {
                StringSerializer.instance.write(modelType.name, buffer);
                Texture.Serializer.write(modelType.postTexture, buffer);
                Texture.Serializer.write(modelType.mainTexture, buffer);
                Texture.Serializer.write(modelType.secondaryTexture, buffer);
                ((Ingredient)modelType.signIngredient.get()).m_43923_(buffer);
                ((Ingredient)modelType.baseIngredient.get()).m_43923_(buffer);
                ((Ingredient)modelType.addSignIngredient.get()).m_43923_(buffer);
            }

            private <T> Lazy<T> constLazy(T t) {
                return Lazy.of(() -> t);
            }

            @Override
            public ModelType read(FriendlyByteBuf buffer) {
                return new ModelType(StringSerializer.instance.read(buffer), Texture.Serializer.read(buffer), Texture.Serializer.read(buffer), Texture.Serializer.read(buffer), this.constLazy(Ingredient.m_43940_((FriendlyByteBuf)buffer)), this.constLazy(Ingredient.m_43940_((FriendlyByteBuf)buffer)), this.constLazy(Ingredient.m_43940_((FriendlyByteBuf)buffer)));
            }
        }
    }

    public static class Variant {
        private PostBlock block = null;
        public final String registryName;
        public final BlockBehaviour.Properties properties;
        public final ModelType type;
        public final RequiredTool tool;

        public Variant(BlockBehaviour.Properties properties, ModelType type, String registryName, RequiredTool tool) {
            this.properties = properties;
            this.type = type;
            this.tool = tool;
            this.registryName = "post_" + registryName;
        }

        public PostBlock createBlock() {
            assert (this.block == null);
            this.block = new PostBlock(this.properties, this.type);
            return this.block;
        }

        public PostBlock getBlock() {
            assert (this.block != null);
            return this.block;
        }

        public static enum RequiredTool {
            Axe,
            Pickaxe;

        }
    }
}

