/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="signpost", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Delay {
    private static final List<Task> serverTasks = new ArrayList<Task>();
    private static final List<Task> clientTasks = new ArrayList<Task>();

    public static void onClientForFrames(int frames, Runnable run) {
        Delay.forFrames(frames, true, run);
    }

    public static void onServerForFrames(int frames, Runnable run) {
        Delay.forFrames(frames, false, run);
    }

    public static void forFrames(int frames, boolean onClient, Runnable run) {
        if (frames == 0) {
            run.run();
        } else {
            AtomicInteger framesLeft = new AtomicInteger(frames);
            (onClient ? clientTasks : serverTasks).add(new Task(() -> framesLeft.decrementAndGet() <= 0, run));
        }
    }

    public static void onServerUntil(Supplier<Boolean> canRun, Runnable run) {
        if (canRun.get().booleanValue()) {
            run.run();
        } else {
            serverTasks.add(new Task(canRun, run));
        }
    }

    public static void onClientUntil(Supplier<Boolean> canRun, Runnable run) {
        if (canRun.get().booleanValue()) {
            run.run();
        } else {
            clientTasks.add(new Task(canRun, run));
        }
    }

    public static void until(Supplier<Boolean> canRun, Runnable run, boolean onClient) {
        if (onClient) {
            Delay.onClientUntil(canRun, run);
        } else {
            Delay.onServerUntil(canRun, run);
        }
    }

    public static void onServerUntil(Supplier<Boolean> canRun, Runnable run, int timeoutFrames, Optional<Runnable> onTimeOut) {
        if (canRun.get().booleanValue()) {
            run.run();
        } else {
            Delay.delayUntil(canRun, run, timeoutFrames, serverTasks, onTimeOut);
        }
    }

    public static void onClientUntil(Supplier<Boolean> canRun, Runnable run, int timeoutFrames, Optional<Runnable> onTimeOut) {
        if (canRun.get().booleanValue()) {
            run.run();
        } else {
            Delay.delayUntil(canRun, run, timeoutFrames, clientTasks, onTimeOut);
        }
    }

    public static <T> void onServerUntilIsPresent(Supplier<Optional<T>> supplier, Consumer<T> run, int timeoutFrames, Optional<Runnable> onTimeOut) {
        AtomicReference result = new AtomicReference(supplier.get());
        if (result.get().isPresent()) {
            run.accept(result.get().get());
        } else {
            Delay.delayUntil(() -> {
                result.set((Optional)supplier.get());
                return ((Optional)result.get()).isPresent();
            }, () -> run.accept(((Optional)result.get()).get()), timeoutFrames, serverTasks, onTimeOut);
        }
    }

    public static <T> void onClientUntilIsPresent(Supplier<Optional<T>> supplier, Consumer<T> run, int timeoutFrames, Optional<Runnable> onTimeOut) {
        AtomicReference result = new AtomicReference(supplier.get());
        if (result.get().isPresent()) {
            run.accept(result.get().get());
        } else {
            Delay.delayUntil(() -> {
                result.set((Optional)supplier.get());
                return ((Optional)result.get()).isPresent();
            }, () -> run.accept(((Optional)result.get()).get()), timeoutFrames, clientTasks, onTimeOut);
        }
    }

    public static void until(Supplier<Boolean> canRun, Runnable run, int timeoutFrames, boolean onClient, Optional<Runnable> onTimeOut) {
        if (onClient) {
            Delay.onClientUntil(canRun, run, timeoutFrames, onTimeOut);
        } else {
            Delay.onServerUntil(canRun, run, timeoutFrames, onTimeOut);
        }
    }

    public static <T> void untilIsPresent(Supplier<Optional<T>> supplier, Consumer<T> run, int timeoutFrames, boolean onClient, Optional<Runnable> onTimeOut) {
        if (onClient) {
            Delay.onClientUntilIsPresent(supplier, run, timeoutFrames, onTimeOut);
        } else {
            Delay.onServerUntilIsPresent(supplier, run, timeoutFrames, onTimeOut);
        }
    }

    private static void delayUntil(Supplier<Boolean> canRun, Runnable run, int timeoutFrames, List<Task> taskList, Optional<Runnable> onTimeOut) {
        AtomicInteger framesLeft = new AtomicInteger(timeoutFrames);
        taskList.add(new Task(() -> {
            framesLeft.set(framesLeft.get() - 1);
            return (Boolean)canRun.get() != false || framesLeft.get() < 0;
        }, () -> {
            if (framesLeft.get() >= 0) {
                run.run();
            } else {
                onTimeOut.ifPresent(Runnable::run);
            }
        }));
    }

    @SubscribeEvent
    static void onServerTick(TickEvent.ServerTickEvent event) {
        Task[] tasks = serverTasks.toArray(new Task[0]);
        serverTasks.clear();
        for (Task task : tasks) {
            if (task.canRun()) {
                task.run();
                continue;
            }
            serverTasks.add(task);
        }
    }

    @SubscribeEvent
    static void onClientTick(TickEvent.ClientTickEvent event) {
        Task[] tasks = clientTasks.toArray(new Task[0]);
        clientTasks.clear();
        for (Task task : tasks) {
            if (task.canRun()) {
                task.run();
                continue;
            }
            clientTasks.add(task);
        }
    }

    private static class Task {
        private final Supplier<Boolean> canRun;
        private final Runnable run;

        public boolean canRun() {
            return this.canRun.get();
        }

        public void run() {
            this.run.run();
        }

        private Task(Supplier<Boolean> canRun, Runnable run) {
            this.canRun = canRun;
            this.run = run;
        }
    }
}

