/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import gollorum.signpost.utils.serialization.BufferSerializable;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public abstract class Either<Left, Right> {
    public static <Left, Right> Either<Left, Right> left(Left left) {
        return new LeftImpl(left);
    }

    public static <Left, Right> Either<Left, Right> right(Right right) {
        return new RightImpl(right);
    }

    public static <Left, Right> Either<Left, Right> leftIfPresent(Optional<Left> left, Supplier<Right> right) {
        return left.map(Either::left).orElseGet(() -> Either.right(right.get()));
    }

    public static <Left, Right> Either<Left, Right> rightIfPresent(Optional<Right> right, Supplier<Left> left) {
        return right.map(Either::right).orElseGet(() -> Either.left(left.get()));
    }

    private Either() {
    }

    public abstract boolean isLeft();

    public boolean isRight() {
        return !this.isLeft();
    }

    public Either<Right, Left> flip() {
        return this.match(Either::right, Either::left);
    }

    public abstract Right rightOr(Function<Left, Right> var1);

    public abstract Left leftOr(Function<Right, Left> var1);

    public abstract <NewRight> Either<Left, NewRight> flatMapRight(Function<Right, Either<Left, NewRight>> var1);

    public abstract <NewLeft> Either<NewLeft, Right> flatMapLeft(Function<Left, Either<NewLeft, Right>> var1);

    public final <NewRight> Either<Left, NewRight> mapRight(Function<Right, NewRight> mapping) {
        return this.flatMapRight(r -> Either.right(mapping.apply(r)));
    }

    public final <NewLeft> Either<NewLeft, Right> mapLeft(Function<Left, NewLeft> mapping) {
        return this.flatMapLeft(l -> Either.left(mapping.apply(l)));
    }

    public abstract <Out> Out match(Function<Left, Out> var1, Function<Right, Out> var2);

    public abstract void consume(Consumer<Left> var1, Consumer<Right> var2);

    public Right rightOrThrow() {
        return (Right)this.rightOr(l -> {
            throw new RuntimeException("Right value was not present.");
        });
    }

    public Left leftOrThrow() {
        return (Left)this.leftOr(l -> {
            throw new RuntimeException("Left value was not present.");
        });
    }

    private static class LeftImpl<Left, Right>
    extends Either<Left, Right> {
        private final Left left;

        private LeftImpl(Left left) {
            this.left = left;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public Right rightOr(Function<Left, Right> func) {
            return func.apply(this.left);
        }

        @Override
        public Left leftOr(Function<Right, Left> func) {
            return this.left;
        }

        @Override
        public <NewRight> Either<Left, NewRight> flatMapRight(Function<Right, Either<Left, NewRight>> mapping) {
            return Either.left(this.left);
        }

        @Override
        public <NewLeft> Either<NewLeft, Right> flatMapLeft(Function<Left, Either<NewLeft, Right>> mapping) {
            return mapping.apply(this.left);
        }

        @Override
        public <Out> Out match(Function<Left, Out> leftMapping, Function<Right, Out> rightMapping) {
            return leftMapping.apply(this.left);
        }

        @Override
        public void consume(Consumer<Left> leftMapping, Consumer<Right> rightMapping) {
            leftMapping.accept(this.left);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LeftImpl left1 = (LeftImpl)o;
            return Objects.equals(this.left, left1.left);
        }

        public int hashCode() {
            return Objects.hash(this.left);
        }

        public String toString() {
            return "Left{" + this.left + "}";
        }
    }

    private static class RightImpl<Left, Right>
    extends Either<Left, Right> {
        private final Right right;

        private RightImpl(Right right) {
            this.right = right;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public Right rightOr(Function<Left, Right> func) {
            return this.right;
        }

        @Override
        public Left leftOr(Function<Right, Left> func) {
            return func.apply(this.right);
        }

        @Override
        public <NewRight> Either<Left, NewRight> flatMapRight(Function<Right, Either<Left, NewRight>> mapping) {
            return mapping.apply(this.right);
        }

        @Override
        public <NewLeft> Either<NewLeft, Right> flatMapLeft(Function<Left, Either<NewLeft, Right>> mapping) {
            return Either.right(this.right);
        }

        @Override
        public <Out> Out match(Function<Left, Out> leftMapping, Function<Right, Out> rightMapping) {
            return rightMapping.apply(this.right);
        }

        @Override
        public void consume(Consumer<Left> leftMapping, Consumer<Right> rightMapping) {
            rightMapping.accept(this.right);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RightImpl right1 = (RightImpl)o;
            return Objects.equals(this.right, right1.right);
        }

        public int hashCode() {
            return Objects.hash(this.right);
        }

        public String toString() {
            return "Right{" + this.right + "}";
        }
    }

    public static final class Serializer<Left, Right>
    extends BufferSerializer<Left, Right>
    implements CompoundSerializable<Either<Left, Right>> {
        private final CompoundSerializable<Left> leftS;
        private final CompoundSerializable<Right> rightS;

        public Serializer(CompoundSerializable<Left> leftS, CompoundSerializable<Right> rightS) {
            super(leftS, rightS);
            this.leftS = leftS;
            this.rightS = rightS;
        }

        public static <L, R> Serializer<L, R> of(CompoundSerializable<L> ls, CompoundSerializable<R> rs) {
            return new Serializer<L, R>(ls, rs);
        }

        @Override
        public CompoundTag write(Either<Left, Right> leftRightEither, CompoundTag compound) {
            compound.m_128379_("IsLeft", leftRightEither.isLeft());
            compound.m_128365_("Data", (Tag)leftRightEither.match(this.leftS::write, this.rightS::write));
            return compound;
        }

        @Override
        public boolean isContainedIn(CompoundTag compound) {
            return compound.m_128441_("IsLeft") && compound.m_128441_("Data") && compound.m_128471_("IsLeft") ? this.leftS.isContainedIn(compound.m_128469_("Data")) : this.rightS.isContainedIn(compound.m_128469_("Data"));
        }

        @Override
        public Either<Left, Right> read(CompoundTag compound) {
            return compound.m_128471_("IsLeft") ? Either.left(this.leftS.read(compound.m_128469_("Data"))) : Either.right(this.rightS.read(compound.m_128469_("Data")));
        }
    }

    public static class BufferSerializer<Left, Right>
    implements BufferSerializable<Either<Left, Right>> {
        private final BufferSerializable<Left> leftS;
        private final BufferSerializable<Right> rightS;

        public BufferSerializer(BufferSerializable<Left> leftS, BufferSerializable<Right> rightS) {
            this.leftS = leftS;
            this.rightS = rightS;
        }

        public static <L, R> BufferSerializer<L, R> of(BufferSerializable<L> ls, BufferSerializable<R> rs) {
            return new BufferSerializer<L, R>(ls, rs);
        }

        @Override
        public Class<Either<Left, Right>> getTargetClass() {
            return Either.left(null).getClass();
        }

        @Override
        public void write(Either<Left, Right> leftRightEither, FriendlyByteBuf buffer) {
            buffer.writeBoolean(leftRightEither.isLeft());
            leftRightEither.consume(l -> this.leftS.write(l, buffer), r -> this.rightS.write(r, buffer));
        }

        @Override
        public Either<Left, Right> read(FriendlyByteBuf buffer) {
            return buffer.readBoolean() ? Either.left(this.leftS.read(buffer)) : Either.right(this.rightS.read(buffer));
        }
    }
}

