/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.serialization.BlockPosSerializer;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.WorldSerializer;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WorldLocation {
    public final BlockPos blockPos;
    public final Either<Level, ResourceLocation> world;
    public static final Serializer SERIALIZER = new Serializer();

    public static Optional<WorldLocation> from(@Nullable BlockEntity tile) {
        return tile != null && tile.m_58898_() ? Optional.of(new WorldLocation(tile.m_58899_(), tile.m_58904_())) : Optional.empty();
    }

    public WorldLocation(BlockPos blockPos, Either<Level, ResourceLocation> world) {
        this.blockPos = blockPos;
        this.world = world.mapRight(loc -> loc.m_135815_().equals("") ? Level.f_46428_.m_135782_() : loc);
    }

    public WorldLocation(BlockPos blockPos, Level world) {
        this(blockPos, Either.left(world));
    }

    public WorldLocation(BlockPos blockPos, ResourceLocation dimensionKeyLocation) {
        this(blockPos, Either.right(dimensionKeyLocation));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldLocation that = (WorldLocation)o;
        return this.blockPos.equals((Object)that.blockPos) && this.world.rightOr(w -> w.m_46472_().m_135782_()).equals((Object)that.world.rightOr(w -> w.m_46472_().m_135782_()));
    }

    public int hashCode() {
        return Objects.hash(this.blockPos, this.world.rightOr(w -> w.m_46472_().m_135782_()));
    }

    public String toString() {
        return String.format("(%d %d %d) in %s", this.blockPos.m_123341_(), this.blockPos.m_123342_(), this.blockPos.m_123343_(), this.world.match(Level::m_46464_, ResourceLocation::toString));
    }

    public static final class Serializer
    implements CompoundSerializable<WorldLocation> {
        @Override
        public CompoundTag write(WorldLocation worldLocation, CompoundTag compound) {
            compound.m_128365_("Pos", (Tag)BlockPosSerializer.INSTANCE.write(worldLocation.blockPos));
            compound.m_128365_("Level", (Tag)WorldSerializer.INSTANCE.write(worldLocation.world));
            return compound;
        }

        @Override
        public boolean isContainedIn(CompoundTag compound) {
            return compound.m_128441_("Pos") && BlockPosSerializer.INSTANCE.isContainedIn(compound.m_128469_("Pos")) && compound.m_128441_("Level") && WorldSerializer.INSTANCE.isContainedIn(compound.m_128469_("Level"));
        }

        @Override
        public WorldLocation read(CompoundTag compound) {
            return new WorldLocation(BlockPosSerializer.INSTANCE.read(compound.m_128469_("Pos")), (Either<Level, ResourceLocation>)WorldSerializer.INSTANCE.read(compound.m_128469_("Level")));
        }

        @Override
        public Class<WorldLocation> getTargetClass() {
            return WorldLocation.class;
        }

        @Override
        public void write(WorldLocation worldLocation, FriendlyByteBuf buffer) {
            BlockPosSerializer.INSTANCE.write(worldLocation.blockPos, buffer);
            WorldSerializer.INSTANCE.write(worldLocation.world, buffer);
        }

        @Override
        public WorldLocation read(FriendlyByteBuf buffer) {
            return new WorldLocation(BlockPosSerializer.INSTANCE.read(buffer), (Either<Level, ResourceLocation>)WorldSerializer.INSTANCE.read(buffer));
        }
    }
}

