/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.modelGeneration;

import com.mojang.blaze3d.vertex.VertexConsumer;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.utils.math.geometry.AABB;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.modelGeneration.Cube;
import gollorum.signpost.utils.modelGeneration.FaceRotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class SignModel {
    private final Map<Material, List<Quad>> quads = new HashMap<Material, List<Quad>>();

    public void addCube(Cube<ResourceLocation> cube) {
        for (Cube.Quad<ResourceLocation> q : cube.getQuads()) {
            Quad quad = new Quad(q.normal().asVec3f(), (Quad.Vertex[])Arrays.stream(q.vertices()).map(v -> new Quad.Vertex(v.pos().div(Float.valueOf(16.0f)).asVec3f(), v.u() / 16.0f, v.v() / 16.0f, q.faceData().rotation())).toArray(Quad.Vertex[]::new), q.faceData().tintIndex());
            this.quads.computeIfAbsent(new Material(InventoryMenu.f_39692_, q.faceData().texture()), k -> new ArrayList()).add(quad);
        }
    }

    public void render(Matrix4f blockToView, Matrix4f localToBlock, MultiBufferSource buffer, RenderType renderType, int packedLight, int packedOverlay, boolean useAmbientOcclusion, @Nullable BlockAndTintGetter level, @Nullable BlockState state, @Nullable BlockPos pos, int[] tints) {
        BitSet bitset = new BitSet(3);
        float[] aoValues = useAmbientOcclusion ? new float[LevelRenderer.f_109434_.length * 2] : null;
        ModelBlockRenderer.AmbientOcclusionFace aoFace = useAmbientOcclusion ? new ModelBlockRenderer.AmbientOcclusionFace() : null;
        Vector4f[] blockVertices = new Vector4f[4];
        float[] colors = new float[3 * tints.length];
        for (int i = 0; i < tints.length; ++i) {
            int tint = tints[i];
            colors[i * 3] = (float)Colors.getRed(tint) / 255.0f;
            colors[i * 3 + 1] = (float)Colors.getGreen(tint) / 255.0f;
            colors[i * 3 + 2] = (float)Colors.getBlue(tint) / 255.0f;
        }
        for (Map.Entry<Material, List<Quad>> entry : this.quads.entrySet()) {
            for (Quad quad : entry.getValue()) {
                Vector4f localNormal = new Vector4f(quad.normal.x(), quad.normal.y(), quad.normal.z(), 0.0f);
                localNormal.mul((Matrix4fc)localToBlock);
                float rFinal = 1.0f;
                float gFinal = 1.0f;
                float bFinal = 1.0f;
                if (quad.tintIndex >= 0) {
                    rFinal = colors[quad.tintIndex * 3];
                    gFinal = colors[quad.tintIndex * 3 + 1];
                    bFinal = colors[quad.tintIndex * 3 + 2];
                }
                VertexConsumer vertexBuilder = entry.getKey().m_119194_(buffer, x -> renderType);
                for (int i = 0; i < quad.vertices.length; ++i) {
                    Quad.Vertex vertex = quad.vertices[i];
                    Vector4f vert = new Vector4f(vertex.pos.x(), vertex.pos.y(), vertex.pos.z(), 1.0f);
                    vert.mul((Matrix4fc)localToBlock);
                    blockVertices[i] = vert;
                }
                if (useAmbientOcclusion) {
                    Direction dir = Direction.m_122372_((float)localNormal.x(), (float)localNormal.y(), (float)localNormal.z());
                    SignModel.calculateShape(level, state, pos, blockVertices, dir, aoValues, bitset);
                    aoFace.m_111167_(level, state, pos, dir, aoValues, bitset, true);
                }
                Vector4f globalNormal = localNormal;
                localNormal = null;
                globalNormal.mul((Matrix4fc)blockToView);
                for (int i = 0; i < quad.vertices.length; ++i) {
                    Quad.Vertex vertex = quad.vertices[i];
                    Vector4f vert = blockVertices[i];
                    vert.mul((Matrix4fc)blockToView);
                    if (useAmbientOcclusion) {
                        vertexBuilder.m_5954_(vert.x(), vert.y(), vert.z(), rFinal * aoFace.f_111149_[0], gFinal * aoFace.f_111149_[1], bFinal * aoFace.f_111149_[2], 1.0f, vertex.u, vertex.v, packedOverlay, packedLight, globalNormal.x(), globalNormal.y(), globalNormal.z());
                        continue;
                    }
                    vertexBuilder.m_5954_(vert.x(), vert.y(), vert.z(), rFinal, gFinal, bFinal, 1.0f, vertex.u, vertex.v, packedOverlay, packedLight, globalNormal.x(), globalNormal.y(), globalNormal.z());
                }
            }
        }
    }

    private static void calculateShape(BlockAndTintGetter level, BlockState state, BlockPos pos, Vector4f[] vertices, Direction dir, @Nullable float[] aoValues, BitSet bitSet) {
        AABB bounds = new AABB(Arrays.stream(vertices).map(Vector3::fromVector4f));
        if (aoValues != null) {
            aoValues[Direction.WEST.m_122411_()] = bounds.min.x;
            aoValues[Direction.EAST.m_122411_()] = bounds.max.x;
            aoValues[Direction.DOWN.m_122411_()] = bounds.min.y;
            aoValues[Direction.UP.m_122411_()] = bounds.max.y;
            aoValues[Direction.NORTH.m_122411_()] = bounds.min.z;
            aoValues[Direction.SOUTH.m_122411_()] = bounds.max.z;
            int j = LevelRenderer.f_109434_.length;
            aoValues[Direction.WEST.m_122411_() + j] = 1.0f - bounds.min.x;
            aoValues[Direction.EAST.m_122411_() + j] = 1.0f - bounds.max.x;
            aoValues[Direction.DOWN.m_122411_() + j] = 1.0f - bounds.min.y;
            aoValues[Direction.UP.m_122411_() + j] = 1.0f - bounds.max.y;
            aoValues[Direction.NORTH.m_122411_() + j] = 1.0f - bounds.min.z;
            aoValues[Direction.SOUTH.m_122411_() + j] = 1.0f - bounds.max.z;
        }
        float minThresh = 1.0E-4f;
        float maxThresh = 0.9999f;
        switch (dir) {
            case DOWN: 
            case UP: {
                bitSet.set(1, bounds.min.x >= minThresh || bounds.min.z >= minThresh || bounds.max.x <= maxThresh || bounds.max.z <= maxThresh);
                bitSet.set(0, bounds.min.y == bounds.max.y && ((dir != Direction.DOWN ? bounds.max.y > maxThresh : bounds.min.y < minThresh) || state.m_60838_((BlockGetter)level, pos)));
                break;
            }
            case NORTH: 
            case SOUTH: {
                bitSet.set(1, bounds.min.x >= minThresh || bounds.min.y >= minThresh || bounds.max.x <= maxThresh || bounds.max.y <= maxThresh);
                bitSet.set(0, bounds.min.z == bounds.max.z && ((dir != Direction.NORTH ? bounds.max.z > maxThresh : bounds.min.z < minThresh) || state.m_60838_((BlockGetter)level, pos)));
                break;
            }
            case WEST: 
            case EAST: {
                bitSet.set(1, bounds.min.y >= minThresh || bounds.min.z >= minThresh || bounds.max.y <= maxThresh || bounds.max.z <= maxThresh);
                bitSet.set(0, bounds.min.x == bounds.max.x && ((dir != Direction.EAST ? bounds.max.x > maxThresh : bounds.min.x < minThresh) || state.m_60838_((BlockGetter)level, pos)));
            }
        }
    }

    private record Quad(Vector3f normal, Vertex[] vertices, int tintIndex) {

        public static class Vertex {
            public final Vector3f pos;
            public final float u;
            public final float v;

            public Vertex(Vector3f pos, float u, float v, FaceRotation rotation) {
                this.pos = pos;
                switch (rotation) {
                    case Clockwise90: {
                        this.u = 1.0f - v;
                        this.v = u;
                        break;
                    }
                    case CounterClockwise90: {
                        this.u = v;
                        this.v = 1.0f - u;
                        break;
                    }
                    case UpsideDown: {
                        this.u = 1.0f - u;
                        this.v = 1.0f - v;
                        break;
                    }
                    default: {
                        this.u = u;
                        this.v = v;
                    }
                }
            }
        }
    }
}

