/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.client.model;

import java.util.List;
import mekanism.additions.common.MekanismAdditions;
import mekanism.additions.common.entity.baby.EntityBabyCreeper;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ModelBabyCreeper
extends AgeableListModel<EntityBabyCreeper> {
    public static final ModelLayerLocation CREEPER_LAYER = new ModelLayerLocation(MekanismAdditions.rl("baby_creeper"), "main");
    public static final ModelLayerLocation ARMOR_LAYER = new ModelLayerLocation(MekanismAdditions.rl("baby_creeper"), "armor");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)-2.0f));
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation);
        partDefinition.m_171599_("right_hind_leg", cubelistbuilder, PartPose.m_171419_((float)-2.0f, (float)18.0f, (float)4.0f));
        partDefinition.m_171599_("left_hind_leg", cubelistbuilder, PartPose.m_171419_((float)2.0f, (float)18.0f, (float)4.0f));
        partDefinition.m_171599_("right_front_leg", cubelistbuilder, PartPose.m_171419_((float)-2.0f, (float)18.0f, (float)-4.0f));
        partDefinition.m_171599_("left_front_leg", cubelistbuilder, PartPose.m_171419_((float)2.0f, (float)18.0f, (float)-4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public ModelBabyCreeper(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.leftHindLeg = root.m_171324_("right_hind_leg");
        this.rightHindLeg = root.m_171324_("left_hind_leg");
        this.leftFrontLeg = root.m_171324_("right_front_leg");
        this.rightFrontLeg = root.m_171324_("left_front_leg");
    }

    @NotNull
    protected Iterable<ModelPart> m_5607_() {
        return List.of(this.head);
    }

    @NotNull
    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.body, this.leftHindLeg, this.rightHindLeg, this.leftFrontLeg, this.rightFrontLeg);
    }

    public void setupAnim(@NotNull EntityBabyCreeper creeper, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }
}

