/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CreateCritParticlePacket {
    private final int id;
    private final int duration;
    private final ParticleType<?> particle;

    public CreateCritParticlePacket(int entityId, int duration, ParticleType<?> particle) {
        this.id = entityId;
        this.duration = duration;
        this.particle = particle;
    }

    public CreateCritParticlePacket(FriendlyByteBuf buf) {
        this.id = buf.readInt();
        this.duration = buf.readInt();
        this.particle = (ParticleType)buf.readRegistryIdUnsafe(ForgeRegistries.PARTICLE_TYPES);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.duration);
        buf.writeRegistryIdUnsafe(ForgeRegistries.PARTICLE_TYPES, this.particle);
    }

    public static class Handler {
        public static void onMessage(CreateCritParticlePacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.id);
                if (entity != null) {
                    Minecraft.m_91087_().f_91061_.m_107332_(entity, (ParticleOptions)message.particle, message.duration);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

