/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.SoundsInit;
import com.mcwwindows.kikoz.objects.WindowBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Blinds
extends WindowBase {
    private static final EnumProperty<GaragePart> PART = EnumProperty.m_61587_((String)"part", GaragePart.class);
    private static final EnumProperty<BlindsState> BLINDSSTATE = EnumProperty.m_61587_((String)"blindsstate", BlindsState.class);
    String infoname;
    boolean hasTextInfo = true;
    protected static final VoxelShape WEST = Shapes.m_83124_((VoxelShape)Blinds.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.9, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape SOUTH = Shapes.m_83124_((VoxelShape)Blinds.m_49796_((double)0.0, (double)0.0, (double)0.1, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape EAST = Shapes.m_83124_((VoxelShape)Blinds.m_49796_((double)0.1, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NORTH = Shapes.m_83124_((VoxelShape)Blinds.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)15.9), (VoxelShape[])new VoxelShape[0]);

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return null;
    }

    public Blinds(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(BLINDSSTATE, (Comparable)((Object)BlindsState.CLOSED))).m_61124_(PART, (Comparable)((Object)GaragePart.BOTTOM)));
    }

    @Override
    protected BlockState WindowState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean below;
        boolean above = level.m_8055_(pos.m_7494_()).m_60734_() == this;
        boolean bl = below = level.m_8055_(pos.m_7495_()).m_60734_() == this;
        if (above && below) {
            return (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.BOTTOM));
        }
        if (!above && below) {
            return (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.TOP));
        }
        if (above && !below) {
            return (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.BOTTOM));
        }
        return (BlockState)state.m_61124_(PART, (Comparable)((Object)GaragePart.TOP));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.WindowState(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_()).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, FACING, BLINDSSTATE});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        if (item != this.m_5456_()) {
            BlindsState currentState = (BlindsState)((Object)state.m_61143_(BLINDSSTATE));
            BlindsState nextState = this.cycleBlindsState(currentState);
            worldIn.m_5594_(null, pos, (SoundEvent)SoundsInit.BLINDS_CLOSE.get(), SoundSource.BLOCKS, 0.5f, worldIn.f_46441_.m_188501_() * 0.1f + 0.8f);
            this.toggleBlinds(worldIn, pos, nextState, (Direction)state.m_61143_((Property)FACING), 1000);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, Level worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.updatePostPlacement(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public int m_7753_(BlockState state, BlockGetter reader, BlockPos pos) {
        BlindsState currentState = (BlindsState)((Object)state.m_61143_(BLINDSSTATE));
        if (currentState == BlindsState.CLOSED) {
            return reader.m_7469_();
        }
        return 0;
    }

    private void toggleBlinds(Level world, BlockPos pos, BlindsState targetState, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() != this) {
            return;
        }
        BlindsState currentState = (BlindsState)((Object)state.m_61143_(BLINDSSTATE));
        if (currentState != targetState) {
            BlockPos[] positions;
            world.m_46597_(pos, (BlockState)state.m_61124_(BLINDSSTATE, (Comparable)((Object)targetState)));
            for (BlockPos newPos : positions = new BlockPos[]{pos.m_122019_(), pos.m_122012_(), pos.m_122029_(), pos.m_122024_(), pos.m_7495_(), pos.m_7494_()}) {
                this.toggleBlinds(world, newPos, targetState, targetDirection, depth - 1);
            }
        }
    }

    private BlindsState cycleBlindsState(BlindsState currentState) {
        switch (currentState) {
            case CLOSED: {
                return BlindsState.OPEN;
            }
            case OPEN: {
                return BlindsState.RAISED;
            }
        }
        return BlindsState.CLOSED;
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        BlindsState raised = (BlindsState)((Object)state.m_61143_(BLINDSSTATE));
        GaragePart part = (GaragePart)((Object)state.m_61143_(PART));
        if (raised == BlindsState.RAISED && part == GaragePart.BOTTOM) {
            return;
        }
        level.m_5898_(player, 2001, pos, Blinds.m_49956_((BlockState)state));
    }

    public static enum BlindsState implements StringRepresentable
    {
        CLOSED("closed"),
        OPEN("open"),
        RAISED("raised");

        private final String name;

        private BlindsState(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum GaragePart implements StringRepresentable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private GaragePart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

