/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractBulletEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.TierSortingRegistry;

@ParametersAreNonnullByDefault
public class BulletEntity
extends AbstractBulletEntity {
    private int hitPerTick;

    public BulletEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public BulletEntity(Level level, LivingEntity livingEntity) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.BULLET.get()), livingEntity, level);
    }

    public void m_8119_() {
        this.hitPerTick = 0;
        super.m_8119_();
        if (!(this.m_20068_() || this.f_36703_ || this.m_36797_())) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.025, 0.0));
        }
    }

    public void m_36799_() {
        this.m_146870_();
    }

    protected void m_6532_(HitResult hitResult) {
        if (++this.hitPerTick > 8) {
            this.m_146870_();
            return;
        }
        super.m_6532_(hitResult);
    }

    @Override
    protected void m_8060_(BlockHitResult blockHitResult) {
        BlockPos pos = blockHitResult.m_82425_();
        BlockState blockState = this.m_9236_().m_8055_(pos);
        if (blockState.m_60734_() instanceof IronBarsBlock && blockState.m_204336_(Tags.Blocks.GLASS_PANES) && TierSortingRegistry.isCorrectTierForDrops((Tier)Tiers.IRON, (BlockState)blockState)) {
            this.m_9236_().m_46953_(pos, true, this.m_19749_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        } else {
            double hardness = Mth.m_14008_((double)((double)blockState.m_60800_((BlockGetter)this.m_9236_(), pos) * 0.15), (double)0.0, (double)1.0) * 0.95;
            if (this.m_20184_().m_82553_() > 0.95 - hardness) {
                this.m_20256_(BulletEntity.ricochet(this.m_20184_(), blockHitResult.m_82434_().m_122434_(), this.f_19796_, hardness));
                HitResult newHitResult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
                if (newHitResult.m_6662_() == HitResult.Type.BLOCK) {
                    this.m_6532_(newHitResult);
                }
            } else {
                super.m_8060_(blockHitResult);
            }
        }
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)BrassArmoryItems.MUSKET_BALL.get();
    }

    @Nonnull
    public static Vec3 ricochet(Vec3 deltaMovement, Direction.Axis axis, RandomSource random, double hardness) {
        double newX = deltaMovement.f_82479_ * (axis.equals((Object)Direction.Axis.X) ? -hardness : hardness);
        double newY = deltaMovement.f_82480_ * (axis.equals((Object)Direction.Axis.Y) ? -hardness : hardness);
        double newZ = deltaMovement.f_82481_ * (axis.equals((Object)Direction.Axis.Z) ? -hardness : hardness);
        return new Vec3(newX, newY, newZ).m_82520_(random.m_188583_() * 0.005, random.m_188583_() * 0.005, random.m_188583_() * 0.005);
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity target = entityHitResult.m_82443_();
        int invulnerableTime = target.f_19802_;
        target.f_19802_ = 0;
        super.m_5790_(entityHitResult);
        target.f_19802_ = invulnerableTime;
        this.m_146870_();
    }
}

