/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.arrow;

import com.milamber_brass.brass_armory.block.RopeBlock;
import com.milamber_brass.brass_armory.client.render.SpecialArrowRenderer;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractSpecialArrowEntity;
import com.milamber_brass.brass_armory.entity.projectile.bomb.BombEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryBlocks;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.SpecialArrowItem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class RopeArrowEntity
extends AbstractSpecialArrowEntity {
    private boolean isPlacingRope = false;
    private BlockPos currentRopePos;
    private int totalRope = 0;
    private Direction hitBlockFaceDirection;
    private int ticksSinceRope;

    public RopeArrowEntity(EntityType<? extends RopeArrowEntity> entityType, Level level) {
        super(entityType, level);
    }

    public RopeArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.ROPE_ARROW.get()), level, shooter);
        this.m_36781_(0.25);
    }

    public RopeArrowEntity(Level level, double x, double y, double z) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.ROPE_ARROW.get()), level, x, y, z);
        this.m_36781_(0.25);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isPlacingRope) {
            ++this.ticksSinceRope;
            if (this.ticksSinceRope > 6) {
                BlockPos newPos = this.currentRopePos.m_5484_(Direction.DOWN, 1);
                int maxRopeLength = 24;
                if (this.m_9236_().m_8055_(newPos).m_60795_() && this.totalRope < maxRopeLength) {
                    this.m_9236_().m_7731_(newPos, (BlockState)((BlockState)((RopeBlock)((Object)BrassArmoryBlocks.EXPLORERS_ROPE_BLOCK.get())).m_49966_().m_61124_((Property)RopeBlock.FACING, (Comparable)this.hitBlockFaceDirection)).m_61124_((Property)RopeBlock.HAS_ARROW, (Comparable)Boolean.valueOf(this.totalRope == 0)), 2);
                    this.currentRopePos = newPos;
                    ++this.totalRope;
                    this.ticksSinceRope = 0;
                } else {
                    this.isPlacingRope = false;
                    this.m_146870_();
                }
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        Direction direction = result.m_82434_();
        if (direction.equals((Object)Direction.DOWN)) {
            this.m_20256_(BombEntity.bounce(this.m_20184_(), direction.m_122434_(), 0.5).m_82490_(0.5));
        } else {
            super.m_8060_(result);
            if (!direction.equals((Object)Direction.UP) && RopeBlock.canAttachTo((BlockGetter)this.m_9236_(), result.m_82425_(), direction)) {
                this.placeRopes(result);
                this.m_6842_(true);
            }
        }
    }

    private void placeRopes(BlockHitResult result) {
        this.hitBlockFaceDirection = result.m_82434_();
        if (!this.hitBlockFaceDirection.equals((Object)Direction.DOWN) && !this.hitBlockFaceDirection.equals((Object)Direction.UP)) {
            BlockPos hitPos = result.m_82425_();
            this.currentRopePos = hitPos.m_121945_(this.hitBlockFaceDirection);
            BlockState hitBlockState = this.m_9236_().m_8055_(hitPos);
            if (hitBlockState.m_60783_((BlockGetter)this.m_9236_(), this.currentRopePos, this.hitBlockFaceDirection) && this.m_9236_().m_8055_(this.currentRopePos).m_60795_()) {
                this.m_9236_().m_7731_(this.currentRopePos, (BlockState)((BlockState)((RopeBlock)((Object)BrassArmoryBlocks.EXPLORERS_ROPE_BLOCK.get())).m_49966_().m_61124_((Property)RopeBlock.FACING, (Comparable)this.hitBlockFaceDirection)).m_61124_((Property)RopeBlock.HAS_ARROW, (Comparable)Boolean.valueOf(this.totalRope == 0)), 2);
                ++this.totalRope;
                this.isPlacingRope = true;
                this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            }
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ((SpecialArrowItem)((Object)BrassArmoryItems.ROPE_ARROW.get())).m_7968_();
    }

    @Override
    protected void spawnArrowParticles(int particleCount) {
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return SpecialArrowRenderer.ROPE_ARROW_TEXTURE;
    }
}

