/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.arrow;

import com.milamber_brass.brass_armory.client.render.SpecialArrowRenderer;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractSpecialArrowEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryAdvancements;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.SpecialArrowItem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class WarpArrowEntity
extends AbstractSpecialArrowEntity {
    public WarpArrowEntity(EntityType<? extends WarpArrowEntity> entityType, Level level) {
        super(entityType, level);
    }

    public WarpArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.WARP_ARROW.get()), level, shooter);
    }

    public WarpArrowEntity(Level level, double x, double y, double z) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.WARP_ARROW.get()), level, x, y, z);
    }

    protected void m_8060_(BlockHitResult result) {
        if (!this.dealtDamage) {
            this.teleportShooter(result.m_82450_(), (HitResult)result);
        }
        super.m_8060_(result);
    }

    private void teleportShooter(Vec3 pos, HitResult result) {
        Entity entity = this.m_19749_();
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            if (entity instanceof ServerPlayer) {
                EntityTeleportEvent.EnderPearl event;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (serverPlayer.f_8906_.f_9742_.m_129536_() && serverPlayer.m_9236_() == this.m_9236_() && !serverPlayer.m_5803_() && !(event = ForgeEventFactory.onEnderPearlLand((ServerPlayer)serverPlayer, (double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (ThrownEnderpearl)((ThrownEnderpearl)EntityType.f_20484_.m_20615_(this.m_9236_())), (float)5.0f, (HitResult)result)).isCanceled()) {
                    Endermite endermite;
                    if (this.f_19796_.m_188501_() < 0.05f && this.m_9236_().m_46469_().m_46207_(GameRules.f_46134_) && (endermite = (Endermite)EntityType.f_20567_.m_20615_(this.m_9236_())) != null) {
                        endermite.m_7678_(serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), serverPlayer.m_146908_(), serverPlayer.m_146909_());
                        this.m_9236_().m_7967_((Entity)endermite);
                    }
                    if ((double)serverPlayer.m_20270_((Entity)this) >= 100.0) {
                        BrassArmoryAdvancements.LONG_DISTANCE_WARP_ARROW_TRIGGER.trigger(serverPlayer);
                    }
                    if (serverPlayer.m_20159_()) {
                        serverPlayer.m_142098_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                    } else {
                        entity.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                    }
                    entity.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                    entity.m_183634_();
                }
            } else if (entity != null) {
                entity.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                entity.m_183634_();
            }
            this.m_146870_();
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ((SpecialArrowItem)((Object)BrassArmoryItems.WARP_ARROW.get())).m_7968_();
    }

    @Override
    protected void spawnArrowParticles(int particleCount) {
        for (int j = 0; j < particleCount; ++j) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123789_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return SpecialArrowRenderer.WARP_ARROW_TEXTURE;
    }
}

