/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.cannon_balls;

import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractBulletEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryCapabilities;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.util.Impact;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class CannonBallEntity
extends AbstractBulletEntity {
    private static final EntityDataAccessor<Integer> DATA_HITS = SynchedEntityData.m_135353_(CannonBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected double peakSpeed = 0.0;

    public CannonBallEntity(EntityType<? extends AbstractBulletEntity> entityType, Level level) {
        super(entityType, level);
    }

    public CannonBallEntity(Level level, LivingEntity livingEntity) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.CANNON_BALL.get()), livingEntity, level);
    }

    public CannonBallEntity(double x, double y, double z, Level level) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.CANNON_BALL.get()), x, y, z, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_HITS, (Object)0);
    }

    public void m_37251_(Entity shooter, float xRot, float yRot, float v, float speed, float accuracy) {
        super.m_37251_(shooter, xRot, yRot, v, speed * 0.5f, accuracy);
    }

    protected void speedCheck(float speed) {
        if (this.peakSpeed < (double)speed) {
            this.peakSpeed = speed;
        }
    }

    public void m_8119_() {
        this.speedCheck((float)this.m_20184_().m_82553_());
        super.m_8119_();
    }

    @Override
    protected void m_8060_(BlockHitResult blockHitResult) {
        int hits;
        double peak;
        double currentSpeed = this.m_20184_().m_82553_();
        if (currentSpeed > (peak = this.peakSpeed * ((double)(hits = ((Integer)this.m_20088_().m_135370_(DATA_HITS)).intValue()) * 0.1 + 0.2))) {
            float radius = (float)(currentSpeed / this.peakSpeed * currentSpeed) * 0.95f;
            Impact impact = new Impact(this.m_9236_(), (Entity)this, blockHitResult.m_82450_(), radius, this.m_6060_(), Explosion.BlockInteraction.DESTROY);
            BlockPos pos = blockHitResult.m_82425_();
            Optional resistance = impact.m_46062_((Entity)this).m_6617_((Explosion)impact, (BlockGetter)this.m_9236_(), pos, this.m_9236_().m_8055_(pos), this.m_9236_().m_6425_(pos));
            this.m_20256_(this.m_20184_().m_82490_((double)Math.max(0.8f - resistance.orElse(Float.valueOf(1.0f)).floatValue() * 0.2f, 0.1f)));
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                impact.m_46061_();
                impact.m_46075_(true);
                this.m_20088_().m_135381_(DATA_HITS, (Object)((Integer)this.m_20088_().m_135370_(DATA_HITS) + 1));
                this.getCapability(BrassArmoryCapabilities.POWDER_CAPABILITY).ifPresent(iPowderCapability -> {
                    for (BlockPos blockpos : impact.f_46020_) {
                        BlockState blockstate = serverLevel.m_8055_(blockpos);
                        if (blockstate.m_60795_()) continue;
                        iPowderCapability.getPowderBehaviour().sendParticles(serverLevel, Vec3.m_82512_((Vec3i)blockpos));
                    }
                });
            }
            if (!this.m_9236_().m_8055_(pos).m_60795_()) {
                super.m_8060_(blockHitResult);
            }
        } else {
            super.m_8060_(blockHitResult);
        }
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        if (this.m_36797_()) {
            return;
        }
        Entity victimEntity = entityHitResult.m_82443_();
        Entity ownerEntity = this.m_19749_();
        float damage = (float)Mth.m_14008_((double)(this.m_20184_().m_82553_() * this.m_36789_()), (double)0.0, (double)2.147483647E9);
        if (this.m_36792_()) {
            damage *= 1.5f;
        }
        if (victimEntity.m_6469_(this.m_269291_().m_269390_((Entity)this, ownerEntity), damage)) {
            if (victimEntity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (this.m_6060_()) {
                victimEntity.m_20254_(40);
            }
            if (victimEntity instanceof LivingEntity) {
                LivingEntity livingVictim = (LivingEntity)victimEntity;
                if (ownerEntity instanceof LivingEntity) {
                    LivingEntity livingOwner = (LivingEntity)ownerEntity;
                    EnchantmentHelper.m_44823_((LivingEntity)livingVictim, (Entity)livingOwner);
                    EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)livingVictim);
                }
                this.m_7761_(livingVictim);
            }
        }
        this.m_20256_(this.m_20184_().m_82490_(0.95));
        this.m_5496_(this.m_7239_(), 1.0f, 1.0f);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128347_("peakSpeed", this.peakSpeed);
        tag.m_128405_("hitCount", ((Integer)this.m_20088_().m_135370_(DATA_HITS)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.peakSpeed = tag.m_128459_("peakSpeed");
        this.m_20088_().m_135381_(DATA_HITS, (Object)tag.m_128451_("hitCount"));
    }

    @Override
    @NotNull
    protected Item getDefaultItem() {
        return (Item)BrassArmoryItems.CANNON_BALL.get();
    }
}

