/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.milamber_brass.brass_armory.entity.projectile.SpearEntity;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractThrownWeaponEntity;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.item.abstracts.AbstractThrownWeaponItem;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class SpearItem
extends AbstractThrownWeaponItem {
    protected final float attackDamage;
    protected final float attackSpeed;
    protected final float attackReachBonus;

    public SpearItem(Tier tier, int attackDamage, float attackSpeed, float attackReachBonus, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, 16.0f, 1.25f, properties);
        this.attackDamage = (float)attackDamage + tier.m_6631_();
        this.attackSpeed = attackSpeed;
        this.attackReachBonus = attackReachBonus;
    }

    @Override
    protected ImmutableMultimap.Builder<Attribute, AttributeModifier> setDefaultModifiers(float attackDamage, float attackSpeed) {
        return null;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (this.defaultModifiers == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon damage modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon speed modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(BASE_ATTACK_RANGE_UUID, "Weapon range modifier", (double)this.attackReachBonus, AttributeModifier.Operation.ADDITION));
            this.defaultModifiers = builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!entity.m_9236_().f_46443_ && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ArmoryUtil.impaleLivingEntity(living, (float)player.m_21133_(Attributes.f_22281_), player.m_9236_().f_46441_);
        }
        return false;
    }

    @Override
    @NotNull
    public SoundEvent throwSound() {
        return (SoundEvent)BrassArmorySounds.SPEAR_THROW.get();
    }

    @Override
    @NotNull
    protected AbstractThrownWeaponEntity getEntity(Level level, LivingEntity living, ItemStack weaponStack) {
        return new SpearEntity(level, living, weaponStack);
    }
}

