/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.util;

import com.google.common.collect.Lists;
import com.milamber_brass.brass_armory.data.BrassArmoryDamageTypes;
import com.milamber_brass.brass_armory.data.BrassArmoryTags;
import com.milamber_brass.brass_armory.effect.BleedEffect;
import com.milamber_brass.brass_armory.item.KatanaItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ArmoryUtil {
    public static void impaleLivingEntity(LivingEntity living, float damage, RandomSource random) {
        float damageAfterAbsorb = CombatRules.m_19272_((float)damage, (float)living.m_21230_(), (float)((float)living.m_21133_(Attributes.f_22285_)));
        float finalDamage = damage - damageAfterAbsorb;
        finalDamage = Math.min(finalDamage, (float)Math.sqrt(finalDamage * 10.0f) / 10.0f);
        living.m_6469_(ArmoryUtil.getDamageSource(living.m_9236_(), BrassArmoryDamageTypes.IMPALE), finalDamage);
        for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            if (random.m_188499_()) break;
            ItemStack slotStack = living.m_6844_(slot);
            if (slotStack.m_41619_()) continue;
            slotStack.m_41622_(random.m_188503_(4), living, livingEntity -> livingEntity.m_21166_(slot));
        }
    }

    public static void bleedLivingEntity(LivingEntity livingTarget, LivingEntity thisLiving) {
        KatanaItem katanaItem;
        Item item;
        ItemStack stack = thisLiving.m_21205_();
        if (stack.m_204117_(BrassArmoryTags.Items.BLEEDING_EDGE)) {
            BleedEffect.bleedHarder(livingTarget, 70, 1);
        }
        if ((item = stack.m_41720_()) instanceof KatanaItem && (katanaItem = (KatanaItem)item).canWither() && KatanaItem.getWither(stack) >= 100) {
            BleedEffect.witherHarder(livingTarget, 70);
        }
    }

    public static void getWitherFromLivingEntity(LivingEntity livingTarget, LivingEntity thisLiving) {
        ItemStack stack = thisLiving.m_21205_();
        Level level = thisLiving.m_9236_();
        if (level instanceof ServerLevel) {
            KatanaItem katanaItem;
            ServerLevel serverLevel = (ServerLevel)level;
            level = stack.m_41720_();
            if (level instanceof KatanaItem && (katanaItem = (KatanaItem)level).canWither() && KatanaItem.getWither(stack) < 100 && livingTarget.m_21224_() && livingTarget.m_6095_().m_204039_(BrassArmoryTags.Entities.WITHER)) {
                KatanaItem.addWither(stack, thisLiving, serverLevel, livingTarget instanceof WitherBoss ? 50 : 2);
            }
        }
    }

    public static void blockHitSetOnFire(BlockHitResult blockHitResult, Level level, @javax.annotation.Nullable Entity owner) {
        BlockPos pos = blockHitResult.m_82425_();
        BlockState state = level.m_8055_(pos);
        if (CampfireBlock.m_51321_((BlockState)state) || CandleBlock.m_152845_((BlockState)state) || CandleCakeBlock.m_152910_((BlockState)state)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
            level.m_142346_(owner, GameEvent.f_157797_, pos);
        } else {
            BlockPos relativePos = pos.m_121945_(blockHitResult.m_82434_());
            if (BaseFireBlock.m_49255_((Level)level, (BlockPos)relativePos, (Direction)blockHitResult.m_82434_()) || level.m_8055_(relativePos).m_247087_()) {
                BlockState relativeState = BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)relativePos);
                level.m_7731_(relativePos, relativeState, 11);
                level.m_142346_(owner, GameEvent.f_157797_, pos);
            }
        }
    }

    @Nonnull
    public static List<ItemStack> loadStackList(CompoundTag compoundtag, String name) {
        ArrayList list = Lists.newArrayList();
        if (compoundtag.m_128425_(name, 9)) {
            ListTag listtag = compoundtag.m_128437_(name, 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag ammoCompoundTag = listtag.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)ammoCompoundTag));
            }
        }
        return list;
    }

    @Nonnull
    public static ItemStack loadStack(CompoundTag compoundtag, String name, ItemStack ifEmpty) {
        List<ItemStack> list = ArmoryUtil.loadStackList(compoundtag, name);
        if (list.isEmpty()) {
            return ifEmpty;
        }
        return list.get(0);
    }

    public static void addStack(CompoundTag compoundTag, ItemStack itemStack, String name) {
        ListTag listtag = compoundTag.m_128425_(name, 9) ? compoundTag.m_128437_(name, 10) : new ListTag();
        CompoundTag ammoCompoundTag = new CompoundTag();
        itemStack.m_41739_(ammoCompoundTag);
        listtag.add((Object)ammoCompoundTag);
        compoundTag.m_128365_(name, (Tag)listtag);
    }

    public static void clearStack(CompoundTag compoundtag, String name) {
        compoundtag.m_128473_(name);
    }

    @NotNull
    public static Explosion explode(Level level, Entity entity, float power, boolean burn, Level.ExplosionInteraction interaction) {
        return ArmoryUtil.explode(level, entity, entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.5f), 0.0), power, burn, interaction);
    }

    @NotNull
    public static Explosion explode(Level level, @javax.annotation.Nullable Entity entity, Vec3 position, float power, boolean burn, Level.ExplosionInteraction interaction) {
        return level.m_255391_(entity, position.f_82479_, position.f_82480_, position.f_82481_, power, burn, interaction);
    }

    public static boolean isFuseLighter(ItemStack stack) {
        return stack.m_204117_(BrassArmoryTags.Items.FUSE_LIGHTER) || stack.m_41793_() && (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack) > 0 || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0);
    }

    public static void addCooldownToList(Player player, List<Item> items, int ticks) {
        if (!player.m_150110_().f_35937_) {
            for (Item item : items) {
                player.m_36335_().m_41524_(item, ticks);
            }
        }
    }

    public static float frameTime(Level level) {
        return !level.f_46443_ ? 1.0f : Minecraft.m_91087_().m_91296_();
    }

    public static DamageSource getDamageSource(Level level, ResourceKey<DamageType> type) {
        return ArmoryUtil.getEntityDamageSource(level, type, null);
    }

    public static DamageSource getEntityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker) {
        return ArmoryUtil.getIndirectEntityDamageSource(level, type, attacker, attacker);
    }

    public static DamageSource getIndirectEntityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, @Nullable Entity indirectAttacker) {
        return new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(type), attacker, indirectAttacker);
    }
}

