/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.EnumInitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.SpecFlag;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValueTypeAdapter;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.ComingSoon;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.CanMegaEvoSpec;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.CanPrimalEvoSpec;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.CanUltraBurstSpec;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.CustomTextureSpec;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.GenerationSpec;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.IVEVSpec;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.IsLegendarySpec;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.SetAllIVsEVsFlag;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.StatusSpec;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.Type1Spec;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.Type2Spec;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.TypeSpec;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.UnbreedableFlag;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Pokerus;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumPokerusType;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PokemonSpec {
    public static final SpecValueTypeAdapter SPEC_VALUE_TYPE_ADAPTER = new SpecValueTypeAdapter();
    public static final Adapter SPEC_ADAPTER = new Adapter();
    public static final List<ISpecType> extraSpecTypes = new ArrayList<ISpecType>();
    public String[] args = new String[0];
    public String name = null;
    public Integer level = null;
    public Byte gender = null;
    public Byte growth = null;
    public Byte nature = null;
    public String ability = null;
    public Byte boss = null;
    public Boolean shiny = null;
    public Boolean formInvert = false;
    public Byte form = null;
    public String formString = null;
    public Byte ball = null;
    public Byte pokerusType = null;
    public Byte pokerusSpread = null;
    public Boolean egg = null;
    public ArrayList<SpecValue<?>> extraSpecs = null;

    public static ISpecType getSpecForKey(String key) {
        for (ISpecType specType : extraSpecTypes) {
            for (String knownKey : specType.getKeys()) {
                if (!knownKey.equalsIgnoreCase(key)) continue;
                return specType;
            }
        }
        return null;
    }

    public PokemonSpec(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PokemonSpec(String arg) {
        this(arg == null ? null : arg.replaceAll(" +", " ").split(" "));
    }

    public PokemonSpec(String ... args) {
        if (args != null && args.length > 0) {
            String value;
            String key;
            this.args = args;
            for (String arg : args) {
                SpecValue<?> spec;
                ISpecType specType;
                String[] colonSplit;
                if (arg == null || arg.isEmpty()) continue;
                String[] stringArray = colonSplit = arg.contains(":") ? arg.split(":") : null;
                if (colonSplit != null && colonSplit.length == 0) {
                    colonSplit = null;
                }
                key = colonSplit == null ? arg : colonSplit[0];
                value = colonSplit == null || colonSplit.length == 1 ? null : colonSplit[1];
                boolean exclamation = key.startsWith("!");
                if (exclamation) {
                    key = key.substring(1);
                    value = "false";
                }
                if ((specType = PokemonSpec.getSpecForKey(key)) == null || (spec = specType.parse(value)) == null) continue;
                if (this.extraSpecs == null) {
                    this.extraSpecs = new ArrayList();
                }
                this.extraSpecs.add(spec);
            }
            block41: for (String arg : args) {
                if (EnumSpecies.hasPokemonAnyCase(arg)) {
                    this.name = EnumSpecies.getFromNameAnyCase((String)arg).name;
                    continue;
                }
                if (arg.toLowerCase().equals("random")) {
                    this.name = EnumSpecies.randomPoke((boolean)PixelmonConfig.allowRandomPokemonToBeLegendary).name;
                    continue;
                }
                String[] splits = arg.split(":");
                try {
                    key = splits[0].toLowerCase();
                    if (key.equals("s") || key.equals("shiny")) {
                        this.shiny = true;
                        continue;
                    }
                    if (key.equals("!s") || key.equals("!shiny") || key.equals("ns") || key.equals("notshiny")) {
                        this.shiny = false;
                        continue;
                    }
                    if (key.equals("cured") || key.equals("c")) {
                        this.pokerusSpread = -1;
                        if (this.pokerusType != null) continue;
                        this.pokerusType = 1;
                        continue;
                    }
                    if (key.equals("egg")) {
                        this.egg = true;
                        continue;
                    }
                    if (key.equals("!egg")) {
                        this.egg = false;
                        continue;
                    }
                    value = splits[1].replaceAll("_", "");
                    switch (key) {
                        case "lvl": 
                        case "level": {
                            this.level = Integer.parseInt(value);
                            if (this.level > PixelmonServerConfig.maxLevel) {
                                this.level = PixelmonServerConfig.maxLevel;
                            }
                            if (this.level >= 1) continue block41;
                            this.level = 1;
                            break;
                        }
                        case "g": 
                        case "ge": 
                        case "gender": {
                            if (Gender.getGender(value) != null) {
                                this.gender = (byte)Gender.getGender(value).ordinal();
                                break;
                            }
                            this.gender = (byte)Gender.getGender(Short.parseShort(value)).ordinal();
                            break;
                        }
                        case "n": 
                        case "nature": {
                            if (EnumNature.hasNature(value)) {
                                this.nature = (byte)EnumNature.natureFromString((String)value).index;
                                break;
                            }
                            this.nature = (byte)EnumNature.getNatureFromIndex((int)Integer.parseInt((String)value)).index;
                            break;
                        }
                        case "gr": 
                        case "growth": {
                            if (EnumGrowth.hasGrowth(value)) {
                                this.growth = (byte)EnumGrowth.growthFromString((String)value).index;
                                break;
                            }
                            this.growth = (byte)EnumGrowth.getGrowthFromIndex((int)Integer.parseInt((String)value)).index;
                            break;
                        }
                        case "ab": 
                        case "ability": {
                            this.ability = AbilityBase.getAbility(value).map(AbilityBase::getName).orElse(null);
                            break;
                        }
                        case "b": 
                        case "boss": {
                            this.boss = EnumBossMode.hasBossMode(value) ? Byte.valueOf((byte)EnumBossMode.getBossMode((String)value).index) : Byte.valueOf((byte)EnumBossMode.getMode((int)Integer.parseInt((String)value)).index);
                            if (this.boss != EnumBossMode.Equal.index) continue block41;
                            this.boss = null;
                            break;
                        }
                        case "f": 
                        case "form": 
                        case "st": 
                        case "specialtexture": {
                            if (value.startsWith("!")) {
                                this.formInvert = true;
                                value = value.substring(1);
                            }
                            try {
                                this.form = (byte)Integer.parseInt(value);
                            }
                            catch (Exception ex) {
                                this.formString = value;
                            }
                            break;
                        }
                        case "ba": 
                        case "ball": {
                            for (EnumPokeballs pokeball : EnumPokeballs.values()) {
                                if (!pokeball.name().toLowerCase().contains(value.toLowerCase())) continue;
                                this.ball = (byte)pokeball.getIndex();
                            }
                            this.ball = (byte)EnumPokeballs.getFromIndex(Integer.parseInt(value)).getIndex();
                            break;
                        }
                        case "pkrs": 
                        case "pokerus": {
                            try {
                                this.pokerusType = (byte)EnumPokerusType.valueOf(value.toUpperCase()).ordinal();
                            }
                            catch (IllegalArgumentException e) {
                                this.pokerusType = Byte.parseByte(value);
                            }
                            if (this.pokerusType <= 0 || this.pokerusType >= EnumPokerusType.values().length) {
                                this.pokerusType = null;
                            }
                            if (this.pokerusSpread != null) continue block41;
                            this.pokerusSpread = 0;
                            break;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException | NullPointerException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
            if (this.formString != null) {
                EnumSpecies.getFromNameAnyCase(this.name).getPossibleForms(true).forEach(ef -> {
                    if (this.formString.replace("_", "").equalsIgnoreCase(((Enum)((Object)ef)).name().replace("_", ""))) {
                        this.form = ef.getForm();
                    }
                });
            }
        }
    }

    public static PokemonSpec from(String ... args) {
        return new PokemonSpec(args);
    }

    public PokemonSpec copy() {
        PokemonSpec copy = new PokemonSpec(new String[0]);
        try {
            for (Field field : this.getClass().getFields()) {
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || field.getName().equals("extraSpecs")) continue;
                field.set(copy, field.get(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.extraSpecs != null && !this.extraSpecs.isEmpty()) {
            copy.extraSpecs = new ArrayList();
            for (SpecValue specValue : this.extraSpecs) {
                copy.extraSpecs.add((SpecValue<?>)specValue.clone());
            }
        }
        return copy;
    }

    public void fromBytes(ByteBuf buf) {
        String string = ByteBufUtils.readUTF8String((ByteBuf)buf);
        string = string.substring(string.indexOf("{") + 1, string.length() - 1);
        NBTTagCompound nbt = null;
        try {
            nbt = JsonToNBT.func_180713_a((String)string);
            this.readFromNBT(nbt);
        }
        catch (NBTException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.toString());
    }

    @Deprecated
    public boolean matches(NBTTagCompound nbt) {
        if (nbt == null) {
            return false;
        }
        if (this.name != null && !nbt.func_74779_i("Name").equals(this.name)) {
            return false;
        }
        if (this.level != null && nbt.func_74762_e("Level") != this.level.intValue()) {
            return false;
        }
        if (this.gender != null && nbt.func_74765_d("Gender") != this.gender.byteValue()) {
            return false;
        }
        if (this.growth != null && nbt.func_74765_d("Growth") != this.growth.byteValue()) {
            return false;
        }
        if (this.nature != null && nbt.func_74765_d("Nature") != this.nature.byteValue()) {
            return false;
        }
        if (this.ability != null && !nbt.func_74779_i("Ability").equals(this.ability)) {
            return false;
        }
        if (this.boss != null && nbt.func_74765_d("BossMode") != this.boss.byteValue()) {
            return false;
        }
        if (this.shiny != null && nbt.func_74767_n("IsShiny") != this.shiny.booleanValue()) {
            return false;
        }
        if (this.form != null && (this.formInvert != null && this.formInvert != false ? nbt.func_74765_d("Variant") == this.form.byteValue() : nbt.func_74765_d("Variant") != this.form.byteValue())) {
            return false;
        }
        if (this.ball != null && nbt.func_74762_e("CaughtBall") != this.ball.byteValue()) {
            return false;
        }
        if (!(this.pokerusType == null || nbt.func_74764_b("Pokerus") && ((NBTTagCompound)nbt.func_74781_a("Pokerus")).func_74765_d("Type") == this.pokerusType.shortValue())) {
            return false;
        }
        if (!(this.pokerusSpread == null || nbt.func_74764_b("Pokerus") && ((NBTTagCompound)nbt.func_74781_a("Pokerus")).func_74762_e("Spread") == this.pokerusSpread.byteValue())) {
            return false;
        }
        if (this.egg != null) {
            if (this.egg.booleanValue() && !nbt.func_150297_b("eggCycles", 3)) {
                return false;
            }
            if (!this.egg.booleanValue() && nbt.func_150297_b("eggCycles", 3)) {
                return false;
            }
        }
        if (this.extraSpecs != null) {
            for (SpecValue<?> spec : this.extraSpecs) {
                if (spec.matches(nbt)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean matches(EntityPixelmon pokemon) {
        if (pokemon == null) {
            return false;
        }
        if (this.name != null && !pokemon.getPokemonName().equals(this.name)) {
            return false;
        }
        if (this.level != null && pokemon.getLvl().getLevel() != this.level.intValue()) {
            return false;
        }
        if (this.gender != null && pokemon.getPokemonData().getGender().ordinal() != this.gender.byteValue()) {
            return false;
        }
        if (this.growth != null && pokemon.getPokemonData().getGrowth().index != this.growth) {
            return false;
        }
        if (this.nature != null && pokemon.getPokemonData().getNature().index != this.nature) {
            return false;
        }
        if (this.ability != null && !pokemon.getPokemonData().getAbilityName().equals(this.ability)) {
            return false;
        }
        if (this.boss != null && pokemon.getBossMode().index != this.boss) {
            return false;
        }
        if (this.shiny != null && pokemon.getPokemonData().isShiny() != this.shiny.booleanValue()) {
            return false;
        }
        if (this.form != null && (this.formInvert != null && this.formInvert != false ? pokemon.getPokemonData().getForm() == this.form.byteValue() : pokemon.getPokemonData().getForm() != this.form.byteValue())) {
            return false;
        }
        if (this.ball != null && pokemon.getPokemonData().getCaughtBall().getIndex() != this.ball.byteValue()) {
            return false;
        }
        Pokerus pkrs = pokemon.getPokerus().orElse(null);
        if (this.pokerusType != null && (pkrs == null || (short)pkrs.type.ordinal() != this.pokerusType)) {
            return false;
        }
        if (this.pokerusSpread != null && (pkrs == null || pkrs.secondsSinceInfection != this.pokerusSpread)) {
            return false;
        }
        if (this.egg != null) {
            if (this.egg.booleanValue() && !pokemon.getPokemonData().isEgg()) {
                return false;
            }
            if (!this.egg.booleanValue() && pokemon.getPokemonData().isEgg()) {
                return false;
            }
        }
        if (this.extraSpecs != null) {
            for (SpecValue<?> spec : this.extraSpecs) {
                if (spec.matches(pokemon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean matches(Pokemon pokemon) {
        if (pokemon == null) {
            return false;
        }
        if (this.name != null && !pokemon.getSpecies().name.equals(this.name)) {
            return false;
        }
        if (this.level != null && pokemon.getLevel() != this.level.intValue()) {
            return false;
        }
        if (this.gender != null && pokemon.getGender().ordinal() != this.gender.byteValue()) {
            return false;
        }
        if (this.growth != null && pokemon.getGrowth().index != this.growth) {
            return false;
        }
        if (this.nature != null && pokemon.getNature().index != this.nature) {
            return false;
        }
        if (this.ability != null && !pokemon.getAbilityName().equals(this.ability)) {
            return false;
        }
        if (this.shiny != null && pokemon.isShiny() != this.shiny.booleanValue()) {
            return false;
        }
        if (this.form != null && (this.formInvert != null && this.formInvert != false ? pokemon.getForm() == this.form.byteValue() : pokemon.getForm() != this.form.byteValue())) {
            return false;
        }
        if (this.ball != null && pokemon.caughtBall.getIndex() != this.ball.byteValue()) {
            return false;
        }
        Pokerus pkrs = pokemon.getPokerus();
        if (this.pokerusType != null && (pkrs == null || (short)pkrs.type.ordinal() != this.pokerusType)) {
            return false;
        }
        if (this.pokerusSpread != null && (pkrs == null || pkrs.secondsSinceInfection != this.pokerusSpread)) {
            return false;
        }
        if (this.egg != null) {
            if (this.egg.booleanValue() && !pokemon.isEgg()) {
                return false;
            }
            if (!this.egg.booleanValue() && pokemon.isEgg()) {
                return false;
            }
        }
        if (this.extraSpecs != null) {
            for (SpecValue<?> spec : this.extraSpecs) {
                if (spec.matches(pokemon)) continue;
                return false;
            }
        }
        return true;
    }

    public EntityPixelmon create(World world) {
        if (this.name == null) {
            return null;
        }
        EnumSpecies species = EnumSpecies.getFromNameAnyCaseNoTranslate(this.name);
        if (species == null) {
            Pixelmon.LOGGER.error("PokemonSpec tried to create a Pok\u00e9mon with a bad name: " + this.name);
            return null;
        }
        EntityPixelmon pixelmon = new EntityPixelmon(world);
        pixelmon.setPokemon(this.create());
        pixelmon.getPokemonData().updateDimensionAndEntityID(world.field_73011_w.getDimension(), pixelmon.func_145782_y());
        if (this.boss != null) {
            pixelmon.setBoss(EnumBossMode.getMode(this.boss.byteValue()));
            pixelmon.resetDataWatchers();
        }
        return pixelmon;
    }

    public Pokemon create() {
        if (this.name == null) {
            Pixelmon.LOGGER.error("PokemonSpec tried to create a Pok\u00e9mon with a null name.");
            return null;
        }
        EnumSpecies species = EnumSpecies.getFromNameAnyCaseNoTranslate(this.name);
        if (species == null) {
            Pixelmon.LOGGER.error("PokemonSpec tried to create a Pok\u00e9mon with a bad name: " + this.name);
            return null;
        }
        Pokemon pokemon = Pixelmon.pokemonFactory.create(UUID.randomUUID());
        if (this.name != null) {
            pokemon.species = species;
        }
        if (this.form != null) {
            pokemon.form = this.form.byteValue();
        }
        if (this.level != null) {
            pokemon.level = this.level;
        }
        if (this.gender != null) {
            pokemon.gender = Gender.getGender(this.gender.byteValue());
            if (EnumSpecies.genderForm.contains(pokemon.species)) {
                pokemon.form = pokemon.gender.getForm();
            }
        }
        if (this.growth != null) {
            pokemon.growth = EnumGrowth.getGrowthFromIndex(this.growth.byteValue());
        }
        if (this.nature != null) {
            pokemon.nature = EnumNature.getNatureFromIndex(this.nature.byteValue());
        }
        if (this.ability != null) {
            pokemon.setAbility(this.ability);
        }
        if (this.shiny != null) {
            pokemon.isShiny = this.shiny;
        }
        if (this.ball != null) {
            pokemon.caughtBall = EnumPokeballs.getFromIndex(this.ball.byteValue());
        }
        if (this.pokerusType != null) {
            Pokerus p = new Pokerus(EnumPokerusType.values()[this.pokerusType]);
            p.secondsSinceInfection = this.pokerusSpread == null ? -1 : (int)this.pokerusSpread.byteValue();
            pokemon.setPokerus(p);
        }
        pokemon.initialize(new EnumInitializeCategory[0]);
        if (this.egg != null && this.egg.booleanValue()) {
            pokemon.makeEgg();
        }
        if (this.extraSpecs != null && !this.extraSpecs.isEmpty()) {
            for (SpecValue<?> specValue : this.extraSpecs) {
                specValue.apply(pokemon);
            }
        }
        return pokemon;
    }

    @Deprecated
    public void apply(NBTTagCompound nbt) {
        BaseStats bs;
        EnumSpecies pokemon;
        String name;
        if (this.level != null) {
            nbt.func_74768_a("Level", this.level.intValue());
        }
        if (this.gender != null) {
            nbt.func_74774_a("Gender", this.gender.byteValue());
        }
        if (this.growth != null) {
            nbt.func_74774_a("Growth", this.growth.byteValue());
        }
        if (this.nature != null) {
            nbt.func_74774_a("Nature", this.nature.byteValue());
        }
        if (this.ability != null) {
            nbt.func_74778_a("Ability", this.ability);
            name = nbt.func_74779_i("Name");
            if (name != null && !name.isEmpty() && (pokemon = (EnumSpecies)EnumSpecies.getFromName(name).orElse(null)) != null && (bs = pokemon.getBaseStats(pokemon.getFormEnum(nbt.func_74762_e("Variant")))) != null) {
                for (int i = 0; i < bs.abilities.length; ++i) {
                    if (bs.abilities[i] == null || !bs.abilities[i].equals(this.ability)) continue;
                    nbt.func_74774_a("AbilitySlot", (byte)i);
                    break;
                }
            }
        }
        if (this.boss != null) {
            nbt.func_74774_a("BossMode", this.boss.byteValue());
        }
        if (this.shiny != null) {
            nbt.func_74757_a("IsShiny", this.shiny.booleanValue());
        }
        if (this.form != null) {
            nbt.func_74774_a("Variant", this.form.byteValue());
        }
        if (this.ball != null) {
            nbt.func_74774_a("CaughtBall", this.ball.byteValue());
        }
        if (this.pokerusType != null) {
            NBTTagCompound pkrs = new NBTTagCompound();
            pkrs.func_74774_a("Type", this.pokerusType.byteValue());
            if (this.pokerusSpread == null) {
                pkrs.func_82580_o("Spread");
            } else {
                pkrs.func_74774_a("Spread", this.pokerusSpread.byteValue());
            }
            nbt.func_74782_a("Pokerus", (NBTBase)pkrs);
        }
        if (this.egg != null && this.egg.booleanValue() && !(name = nbt.func_74779_i("Name")).isEmpty() && (pokemon = (EnumSpecies)EnumSpecies.getFromName(name).orElse(null)) != null && (bs = pokemon.getBaseStats(pokemon.getFormEnum(nbt.func_74762_e("Variant")))) != null) {
            nbt.func_74768_a("eggCycles", bs.eggCycles.intValue());
        }
        if (this.extraSpecs != null) {
            for (SpecValue<?> spec : this.extraSpecs) {
                spec.apply(nbt);
            }
        }
    }

    public void apply(EntityPixelmon pokemon) {
        if (this.level != null) {
            pokemon.getLvl().setLevel(this.level);
        }
        if (this.gender != null) {
            pokemon.getPokemonData().setGender(Gender.getGender(this.gender.shortValue()));
            if (pokemon.getBaseStats().malePercent < 0) {
                pokemon.getPokemonData().setGender(Gender.None);
            } else if (pokemon.getBaseStats().malePercent == 0) {
                pokemon.getPokemonData().setGender(Gender.Female);
            } else if (pokemon.getBaseStats().malePercent == 100) {
                pokemon.getPokemonData().setGender(Gender.Male);
            } else if (pokemon.getBaseStats().malePercent > 0 && pokemon.getPokemonData().getGender() == Gender.None) {
                pokemon.getPokemonData().setGender(RandomHelper.rand.nextInt(100) < pokemon.getBaseStats().malePercent ? Gender.Male : Gender.Female);
            }
        }
        if (this.growth != null) {
            pokemon.getPokemonData().setGrowth(EnumGrowth.getGrowthFromIndex(this.growth.byteValue()));
        }
        if (this.nature != null) {
            pokemon.getPokemonData().setNature(EnumNature.getNatureFromIndex(this.nature.byteValue()));
        }
        if (!(this.form == null || this.formInvert != null && this.formInvert.booleanValue())) {
            pokemon.setForm(this.form.byteValue());
        }
        if (this.ability != null) {
            pokemon.getPokemonData().setAbility(this.ability);
        }
        if (this.shiny != null) {
            pokemon.getPokemonData().setShiny(this.shiny);
        }
        if (this.boss != null) {
            pokemon.setBoss(EnumBossMode.getMode(this.boss.byteValue()));
        }
        if (this.ball != null) {
            pokemon.getPokemonData().setCaughtBall(EnumPokeballs.getFromIndex(this.ball.byteValue()));
        }
        if (this.pokerusType != null) {
            Pokerus p = new Pokerus(EnumPokerusType.values()[this.pokerusType]);
            p.secondsSinceInfection = this.pokerusSpread == null ? -1 : (int)this.pokerusSpread.byteValue();
            pokemon.getPokemonData().setPokerus(p);
        }
        if (this.egg != null && this.egg.booleanValue()) {
            pokemon.getPokemonData().makeEgg();
        }
        if (this.extraSpecs != null) {
            for (SpecValue<?> spec : this.extraSpecs) {
                spec.apply(pokemon);
            }
        }
        pokemon.update(EnumUpdateType.Stats, EnumUpdateType.Texture);
    }

    public void apply(Pokemon pokemon) {
        if (this.name != null) {
            pokemon.setSpecies(EnumSpecies.getFromNameAnyCaseNoTranslate(this.name));
        }
        if (this.level != null) {
            pokemon.getLevelContainer().setLevel(this.level);
        }
        if (this.gender != null) {
            pokemon.setGender(Gender.getGender(this.gender.byteValue()));
        }
        if (this.growth != null) {
            pokemon.setGrowth(EnumGrowth.getGrowthFromIndex(this.growth.byteValue()));
        }
        if (this.nature != null) {
            pokemon.setNature(EnumNature.getNatureFromIndex(this.nature.byteValue()));
        }
        if (this.ability != null) {
            pokemon.setAbility(AbilityBase.getAbility(this.ability).orElse(new ComingSoon(this.ability)));
        }
        if (this.shiny != null) {
            pokemon.setShiny(this.shiny);
        }
        if (!(this.form == null || this.formInvert != null && this.formInvert.booleanValue())) {
            pokemon.setForm(this.form.byteValue());
        }
        if (this.ball != null) {
            pokemon.setCaughtBall(EnumPokeballs.getFromIndex(this.ball.byteValue()));
        }
        if (this.pokerusType != null) {
            Pokerus p = new Pokerus(EnumPokerusType.values()[this.pokerusType]);
            p.secondsSinceInfection = this.pokerusSpread == null ? -1 : (int)this.pokerusSpread.byteValue();
            pokemon.setPokerus(p);
        }
        if (this.egg != null && this.egg.booleanValue()) {
            pokemon.makeEgg();
        }
        if (this.extraSpecs != null && !this.extraSpecs.isEmpty()) {
            for (SpecValue<?> specValue : this.extraSpecs) {
                specValue.apply(pokemon);
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.args != null && this.args.length > 0) {
            nbt.func_74778_a("args", String.join((CharSequence)" ", this.args));
        }
        if (this.name != null) {
            nbt.func_74778_a("name", this.name);
        }
        if (this.level != null) {
            nbt.func_74768_a("level", this.level.intValue());
        }
        if (this.gender != null) {
            nbt.func_74768_a("gender", (int)this.gender.byteValue());
        }
        if (this.growth != null) {
            nbt.func_74768_a("growth", (int)this.growth.byteValue());
        }
        if (this.nature != null) {
            nbt.func_74768_a("nature", (int)this.nature.byteValue());
        }
        if (this.ability != null) {
            nbt.func_74778_a("ability", this.ability);
        }
        if (this.boss != null) {
            nbt.func_74768_a("boss", (int)this.boss.byteValue());
        }
        if (this.shiny != null) {
            nbt.func_74757_a("shiny", this.shiny.booleanValue());
        }
        if (this.formInvert != null && this.formInvert.booleanValue()) {
            nbt.func_74757_a("formInvert", true);
        }
        if (this.form != null) {
            nbt.func_74768_a("form", (int)this.form.byteValue());
        }
        if (this.ball != null) {
            nbt.func_74768_a("ball", (int)this.ball.byteValue());
        }
        if (this.pokerusType != null) {
            nbt.func_74768_a("pokerus", (int)this.pokerusType.byteValue());
            if (this.pokerusSpread != null) {
                nbt.func_74768_a("spread", (int)this.pokerusSpread.byteValue());
            }
        }
        if (this.egg != null) {
            nbt.func_74757_a("egg", this.egg.booleanValue());
        }
        if (this.extraSpecs != null && !this.extraSpecs.isEmpty()) {
            NBTTagCompound extraSpecsNBT = new NBTTagCompound();
            for (SpecValue<?> specValue : this.extraSpecs) {
                ISpecType specType = PokemonSpec.getSpecForKey(specValue.key);
                if (specType == null) continue;
                specType.writeToNBT(extraSpecsNBT, specValue);
            }
            nbt.func_74782_a("extraSpecs", (NBTBase)extraSpecsNBT);
        }
        return nbt;
    }

    public PokemonSpec readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("args")) {
            this.args = nbt.func_74779_i("args").split(" ");
        }
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("level")) {
            this.level = nbt.func_74762_e("level");
        }
        if (nbt.func_74764_b("gender")) {
            this.gender = nbt.func_74771_c("gender");
        }
        if (nbt.func_74764_b("growth")) {
            this.growth = nbt.func_74771_c("growth");
        }
        if (nbt.func_74764_b("nature")) {
            this.nature = nbt.func_74771_c("nature");
        }
        if (nbt.func_74764_b("ability")) {
            this.ability = nbt.func_74779_i("ability");
        }
        if (nbt.func_74764_b("boss")) {
            this.boss = nbt.func_74771_c("boss");
        }
        if (nbt.func_74764_b("shiny")) {
            this.shiny = nbt.func_74767_n("shiny");
        }
        if (nbt.func_74764_b("formInvert")) {
            this.formInvert = nbt.func_74767_n("formInvert");
        }
        if (nbt.func_74764_b("form")) {
            this.form = nbt.func_74771_c("form");
        }
        if (nbt.func_74764_b("ball")) {
            this.ball = nbt.func_74771_c("ball");
        }
        if (nbt.func_74764_b("pokerus")) {
            this.pokerusType = nbt.func_74771_c("pokerus");
            Byte by = this.pokerusSpread = nbt.func_74764_b("spread") ? Byte.valueOf(nbt.func_74771_c("spread")) : null;
        }
        if (nbt.func_150297_b("egg", 1)) {
            this.egg = nbt.func_74767_n("egg");
        }
        if (nbt.func_74764_b("extraSpecs")) {
            if (this.extraSpecs == null) {
                this.extraSpecs = new ArrayList();
            }
            NBTTagCompound extraSpecsNBT = nbt.func_74775_l("extraSpecs");
            for (String key : extraSpecsNBT.func_150296_c()) {
                SpecValue<?> value;
                ISpecType type = PokemonSpec.getSpecForKey(key);
                if (type == null || (value = type.readFromNBT(extraSpecsNBT)) == null) continue;
                this.extraSpecs.add(value);
            }
        }
        return this;
    }

    public String toString() {
        return "PokemonSpec{" + this.writeToNBT(new NBTTagCompound()) + "}";
    }

    public static void registerDefaultExtraSpecs() {
        extraSpecTypes.add(new SpecFlag("untradeable"));
        extraSpecTypes.add(new SpecFlag("unbreedable", "nobreed"));
        UnbreedableFlag.init();
        extraSpecTypes.add(new SetAllIVsEVsFlag(Lists.newArrayList((Object[])new String[]{"minivs", "minimumivs"}), true, 0));
        extraSpecTypes.add(new SetAllIVsEVsFlag(Lists.newArrayList((Object[])new String[]{"maxivs", "maximumivs"}), true, 31));
        extraSpecTypes.add(new IVEVSpec(Lists.newArrayList((Object[])new String[]{"ivhp"}), "IVHP", StatsType.HP, true, 0, null));
        extraSpecTypes.add(new IVEVSpec(Lists.newArrayList((Object[])new String[]{"ivattack", "ivatk"}), "IVAttack", StatsType.Attack, true, 0, null));
        extraSpecTypes.add(new IVEVSpec(Lists.newArrayList((Object[])new String[]{"ivdefence", "ivdefense", "ivdef"}), "IVDefence", StatsType.Defence, true, 0, null));
        extraSpecTypes.add(new IVEVSpec(Lists.newArrayList((Object[])new String[]{"ivspecialattack", "ivspatk"}), "IVSpAtt", StatsType.SpecialAttack, true, 0, null));
        extraSpecTypes.add(new IVEVSpec(Lists.newArrayList((Object[])new String[]{"ivspecialdefence", "ivspecialdefense", "ivspdef"}), "IVSpDef", StatsType.SpecialDefence, true, 0, null));
        extraSpecTypes.add(new IVEVSpec(Lists.newArrayList((Object[])new String[]{"ivspeed", "ivspd"}), "IVSpeed", StatsType.Speed, true, 0, null));
        extraSpecTypes.add(new SetAllIVsEVsFlag(Lists.newArrayList((Object[])new String[]{"minevs", "minimumevs", "resetevs"}), false, 0));
        extraSpecTypes.add(new SetAllIVsEVsFlag(Lists.newArrayList((Object[])new String[]{"maxevs", "maximumevs"}), false, 31));
        extraSpecTypes.add(new IVEVSpec(Lists.newArrayList((Object[])new String[]{"evhp"}), "EVHP", StatsType.HP, false, 0, null));
        extraSpecTypes.add(new IVEVSpec(Lists.newArrayList((Object[])new String[]{"evattack", "evatk"}), "EVAttack", StatsType.Attack, false, 0, null));
        extraSpecTypes.add(new IVEVSpec(Lists.newArrayList((Object[])new String[]{"evdefence", "evdefense", "evdef"}), "EVDefence", StatsType.Defence, false, 0, null));
        extraSpecTypes.add(new IVEVSpec(Lists.newArrayList((Object[])new String[]{"evspecialattack", "evspatk"}), "EVSpecialAttack", StatsType.SpecialAttack, false, 0, null));
        extraSpecTypes.add(new IVEVSpec(Lists.newArrayList((Object[])new String[]{"evspecialdefence", "evspecialdefense", "evspdef"}), "EVSpecialDefence", StatsType.SpecialDefence, false, 0, null));
        extraSpecTypes.add(new IVEVSpec(Lists.newArrayList((Object[])new String[]{"evspeed", "evspd"}), "EVSpeed", StatsType.Speed, false, 0, null));
        extraSpecTypes.add(new StatusSpec(null));
        extraSpecTypes.add(new CanMegaEvoSpec(false));
        extraSpecTypes.add(new CanPrimalEvoSpec(false));
        extraSpecTypes.add(new CanUltraBurstSpec(false));
        extraSpecTypes.add(new GenerationSpec(1));
        extraSpecTypes.add(new IsLegendarySpec(false));
        extraSpecTypes.add(new CustomTextureSpec(Lists.newArrayList((Object[])new String[]{"ct", "CustomTexture", "custom-texture"}), null));
        extraSpecTypes.add(new Type1Spec(Lists.newArrayList((Object[])new String[]{"type1", "t1"}), null));
        extraSpecTypes.add(new Type2Spec(Lists.newArrayList((Object[])new String[]{"type2", "t2"}), null));
        extraSpecTypes.add(new TypeSpec(Lists.newArrayList((Object[])new String[]{"type", "t"}), null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PokemonSpec)) {
            return false;
        }
        PokemonSpec spec = (PokemonSpec)o;
        return Arrays.equals(this.args, spec.args);
    }

    public int hashCode() {
        return Arrays.hashCode(this.args);
    }

    public static class Adapter
    implements JsonDeserializer<PokemonSpec> {
        public static Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(SpecValue.class, (Object)SPEC_VALUE_TYPE_ADAPTER).create();

        public PokemonSpec deserialize(JsonElement element, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            if (element.isJsonObject()) {
                return (PokemonSpec)GSON.fromJson(element, PokemonSpec.class);
            }
            return new PokemonSpec(element.getAsString());
        }
    }
}

