/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.trading;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.trading.NPCTrades;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.util.helpers.RCFileHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Scanner;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class PossibleTradeList {
    private transient ArrayList<TradePair> filteredAllPossibleTrades = new ArrayList();
    private ArrayList<TradePair> allPossibleTrades = new ArrayList();
    private static PossibleTradeList INSTANCE;
    private static final String PATH = "npcs/trades.json";
    private static final Gson GSON;

    public static void registerTrades() {
        block7: {
            try {
                NPCTrades.UNTRADEABLE = new PokemonSpec("untradeable");
                File file = new File("pixelmon/npcs/trades.json");
                if (!PixelmonConfig.useExternalJSONFilesNPCs || !file.exists()) {
                    Path path = RCFileHelper.pathFromResourceLocation(new ResourceLocation("pixelmon", PATH));
                    InputStream iStream = PossibleTradeList.class.getResourceAsStream("/assets/pixelmon/npcs/trades.json");
                    if (iStream == null) {
                        Pixelmon.LOGGER.log(Level.WARN, "Couldn't find the trade list JSON: " + path.toString());
                    }
                    Scanner s = new Scanner(iStream);
                    s.useDelimiter("\\A");
                    String json = s.hasNext() ? s.next() : "";
                    INSTANCE = (PossibleTradeList)GSON.fromJson(json, PossibleTradeList.class);
                    s.close();
                    if (PixelmonConfig.useExternalJSONFilesNPCs) {
                        file.getParentFile().mkdirs();
                        file.createNewFile();
                        PrintWriter pw = new PrintWriter(file);
                        pw.write(json);
                        pw.flush();
                        pw.close();
                    }
                    PossibleTradeList.filterDisabledGenerations();
                } else {
                    file.getParentFile().mkdirs();
                    INSTANCE = (PossibleTradeList)GSON.fromJson((Reader)new FileReader(file), PossibleTradeList.class);
                    PossibleTradeList.INSTANCE.allPossibleTrades = new ArrayList<TradePair>(PossibleTradeList.INSTANCE.allPossibleTrades);
                    PossibleTradeList.filterDisabledGenerations();
                    if (PixelmonConfig.allGenerationsEnabled()) {
                        Pixelmon.LOGGER.info("Registered NPC trades.");
                    }
                }
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
                Pixelmon.LOGGER.error("Unable to register NPC trades.");
                INSTANCE = new PossibleTradeList();
                PossibleTradeList.INSTANCE.allPossibleTrades.add(new TradePair(new PokemonSpec("Magikarp"), new PokemonSpec("Magikarp")));
                if (!PossibleTradeList.INSTANCE.filteredAllPossibleTrades.isEmpty()) break block7;
                PossibleTradeList.INSTANCE.filteredAllPossibleTrades.add(new TradePair(new PokemonSpec("Magikarp"), new PokemonSpec("Magikarp")));
            }
        }
    }

    private static void filterDisabledGenerations() {
        if (PixelmonConfig.allGenerationsEnabled()) {
            PossibleTradeList.INSTANCE.filteredAllPossibleTrades = new ArrayList<TradePair>(PossibleTradeList.INSTANCE.allPossibleTrades);
        } else {
            PossibleTradeList.INSTANCE.filteredAllPossibleTrades = new ArrayList();
            for (TradePair s : new ArrayList<TradePair>(PossibleTradeList.INSTANCE.allPossibleTrades)) {
                try {
                    EnumSpecies offer;
                    EnumSpecies request = EnumSpecies.getFromNameAnyCase(s.exchange.name);
                    if (request == null || (offer = EnumSpecies.getFromNameAnyCase(s.offer.name)) == null || !PixelmonConfig.isGenerationEnabled(request.getGeneration()) || !PixelmonConfig.isGenerationEnabled(offer.getGeneration())) continue;
                    PossibleTradeList.INSTANCE.filteredAllPossibleTrades.add(s);
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.warn("Failed to register trade exchanging " + (s != null ? (s.exchange != null ? s.exchange.name : "null") : "null") + " for " + (s != null ? (s.offer != null ? s.offer.name : "null") : "null") + (s == null ? "" : (s.description == null || s.description.isEmpty() ? "" : " with description \"" + s.description + "\"")), (Throwable)e);
                }
            }
            if (PossibleTradeList.INSTANCE.filteredAllPossibleTrades.isEmpty()) {
                PossibleTradeList.INSTANCE.filteredAllPossibleTrades.add(new TradePair(new PokemonSpec("Magikarp"), new PokemonSpec("Magikarp")));
                String enabledGenerations = "";
                for (int i = 0; i <= 8; ++i) {
                    if (!PixelmonConfig.isGenerationEnabled(i)) continue;
                    if (!enabledGenerations.isEmpty()) {
                        enabledGenerations = enabledGenerations + ",";
                    }
                    enabledGenerations = enabledGenerations + "gen" + i;
                }
                if (enabledGenerations.isEmpty()) {
                    enabledGenerations = "No";
                }
                if (!PixelmonConfig.allGenerationsEnabled()) {
                    Pixelmon.LOGGER.error("No valid trades could be registered with only " + enabledGenerations + " being enabled!");
                }
            } else if (!PixelmonConfig.allGenerationsEnabled()) {
                Pixelmon.LOGGER.info("Registered NPC trades. Filtered " + (PossibleTradeList.INSTANCE.allPossibleTrades.size() - PossibleTradeList.INSTANCE.filteredAllPossibleTrades.size()) + " trades containing disabled generation pokemon!");
            }
        }
    }

    public static void save() {
        try {
            new File("pixelmon/npcs/trades.json").getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(new File("pixelmon/npcs/trades.json"));
            String json = GSON.toJson((Object)INSTANCE);
            pw.write(json);
            pw.flush();
            pw.close();
            Pixelmon.LOGGER.info("Saved NPC trades.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<TradePair> getAllPossibleTrades() {
        if (PixelmonConfig.allGenerationsEnabled()) {
            return PossibleTradeList.INSTANCE.allPossibleTrades;
        }
        return PossibleTradeList.INSTANCE.filteredAllPossibleTrades;
    }

    public static TradePair getRandomTrade() {
        return CollectionHelper.getRandomElement(PossibleTradeList.getAllPossibleTrades());
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(PokemonSpec.class, (Object)PokemonSpec.SPEC_ADAPTER).create();
    }
}

