/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.teamselection;

import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.battles.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.rules.teamselection.TeamSelection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;

public final class TeamSelectionList {
    private static int idCounter;
    private static final Map<Integer, TeamSelection> teamSelectMap;

    private TeamSelectionList() {
    }

    public static void addTeamSelection(BattleRules rules, boolean showRules, PartyStorage ... storages) {
        int newID = idCounter++;
        TeamSelection selection = new TeamSelection(newID, rules, showRules, storages);
        teamSelectMap.put(newID, selection);
        selection.initializeClient();
    }

    public static void removeSelection(EntityPlayerMP player) {
        for (TeamSelection selection : teamSelectMap.values()) {
            if (!selection.hasPlayer(player)) continue;
            teamSelectMap.remove(selection.id);
            return;
        }
    }

    static void removeSelection(int id) {
        teamSelectMap.remove(id);
    }

    public static TeamSelection getTeamSelection(int id) {
        return teamSelectMap.get(id);
    }

    static {
        teamSelectMap = new HashMap<Integer, TeamSelection>();
    }
}

