/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Hail;
import com.pixelmonmod.pixelmon.battles.status.Screen;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;

public class AuroraVeil
extends Screen {
    transient PixelmonWrapper user = null;

    public AuroraVeil() {
        this(null, 5);
    }

    public AuroraVeil(int turns) {
        this(null, turns);
    }

    public AuroraVeil(PixelmonWrapper user, int turns) {
        super(StatusType.AuroraVeil, null, turns, "pixelmon.effect.auroraveil.raised", "pixelmon.effect.auroraveil.already", "pixelmon.status.auroraveil.woreoff");
        this.user = user;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.targetIndex == 0 || user.bc.simulateMode) {
            if (!(user.bc.globalStatusController.getWeather() instanceof Hail)) {
                user.bc.sendToAll("pixelmon.effect.itfailed", new Object[0]);
                user.attack.moveResult.result = AttackResult.failed;
            } else if (user.hasStatus(this.type)) {
                user.bc.sendToAll(this.langFail, user.getNickname());
                user.attack.moveResult.result = AttackResult.failed;
            } else if (!user.hasStatus(StatusType.Reflect)) {
                int turns = user.getUsableHeldItem().getHeldItemType() == EnumHeldItems.lightClay ? 8 : 5;
                user.addTeamStatus(((AuroraVeil)this.getNewInstance(turns)).withUser(user), user);
                user.bc.sendToAll(this.langStart, user.getNickname());
            }
        }
    }

    public AuroraVeil withUser(PixelmonWrapper user) {
        this.user = user;
        return this;
    }

    @Override
    public boolean shouldReduce(Attack a) {
        return true;
    }

    @Override
    public float getDamageMultiplier(PixelmonWrapper target) {
        return target != this.user ? 0.6666667f : 0.5f;
    }

    @Override
    protected Screen getNewInstance(int effectTurns) {
        return new AuroraVeil(null, effectTurns);
    }
}

