/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;

public class MagicCoat
extends StatusBase {
    public MagicCoat() {
        super(StatusType.MagicCoat);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        user.bc.sendToAll("pixelmon.status.applymagiccoat", user.getNickname());
        user.addStatus(new MagicCoat(), user);
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        Attack a = user.attack;
        return MagicCoat.reflectMove(a, pokemon, user, "pixelmon.status.magiccoat");
    }

    public static boolean reflectMove(Attack a, PixelmonWrapper pokemon, PixelmonWrapper user, String message) {
        if (!(a.getAttackCategory() != AttackCategory.STATUS || a.isAttack("Bestow", "Curse", "Guard Swap", "Heart Swap", "Lock-On", "Memento", "Mimic", "Power Swap", "Psych Up", "Psycho Shift", "Role Play", "Skill Swap", "Snatch", "Switcheroo", "Transform", "Trick", "Extreme Evoboost") || a.getMove().getTargetingInfo().hitsAll && a.getMove().getTargetingInfo().hitsSelf)) {
            user.bc.sendToAll(message, pokemon.getNickname());
            pokemon.targetIndex = 0;
            if (!pokemon.getBattleAbility().allowsOutgoingAttack(pokemon, user, a)) {
                return true;
            }
            if (a.hasNoEffect(pokemon, user)) {
                user.bc.sendToAll("pixelmon.battletext.noeffect", user.getNickname());
                return true;
            }
            a.applyAttackEffect(pokemon, user);
            return true;
        }
        return false;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        pw.removeStatus(this);
    }
}

