/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;

public class MagnetRise
extends StatusBase {
    private transient int duration = 5;

    public MagnetRise() {
        super(StatusType.MagnetRise);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.hasStatus(StatusType.MagnetRise, StatusType.Ingrain)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        } else if (user.addStatus(new MagnetRise(), user)) {
            user.bc.sendToAll("pixelmon.effect.magnetrise", user.getNickname());
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        if (--this.duration <= 0) {
            pw.bc.sendToAll("pixelmon.status.magicroomend", new Object[0]);
            pw.removeStatus(this);
        }
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        return user.attack.getType() == EnumType.Ground && !user.attack.isAttack("Sand-attack", "Thousand Arrows") && !pokemon.isGrounded();
    }

    @Override
    public void stopsIncomingAttackMessage(PixelmonWrapper pokemon, PixelmonWrapper user) {
        user.bc.sendToAll("pixelmon.battletext.noeffect", pokemon.getNickname());
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (MoveChoice.hasOffensiveAttackType(MoveChoice.getTargetedChoices(pw, bestOpponentChoices), EnumType.Ground)) {
            userChoice.raiseWeight(30.0f);
        }
    }
}

