/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.spawning;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.PixelmonBlockStartingBattleEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonBlockTriggeredBattleEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Level;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleStartTypes;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockSpawningHandler {
    private static final BlockSpawningHandler instance = new BlockSpawningHandler();
    private static final Random RNG = new Random();

    public static BlockSpawningHandler getInstance() {
        return instance;
    }

    public void performBattleStartCheck(World world, BlockPos pos, Entity entity, EntityPixelmon entityPixelmon, EnumBattleStartTypes startType, IBlockState state) {
        EntityPlayerMP playerMP = (EntityPlayerMP)entity;
        if (BattleRegistry.getBattle((EntityPlayer)playerMP) != null) {
            return;
        }
        PlayerPartyStorage party = Pixelmon.storageManager.getParty(playerMP);
        if (party.guiOpened) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PixelmonBlockTriggeredBattleEvent(this, world, pos, playerMP, entityPixelmon, startType))) {
            return;
        }
        if (startType == EnumBattleStartTypes.HEADBUTT) {
            if (RNG.nextInt(100) <= 25) {
                playerMP.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.moveskill.headbutt.nothing", new Object[0]));
                return;
            }
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state);
        } else if (startType == EnumBattleStartTypes.ROCKSMASH) {
            if (RNG.nextInt(100) <= 40) {
                return;
            }
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state);
        } else if (startType == EnumBattleStartTypes.FORAGE) {
            if (!RandomHelper.getRandomChance(PixelmonConfig.forageChance)) {
                playerMP.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.moveskill.forage.nothing", new Object[]{entityPixelmon.getNickname()}));
                return;
            }
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state);
        } else {
            this.grabSpawns(world, pos, playerMP, startType, entityPixelmon, state);
        }
    }

    private void grabSpawns(World worldIn, BlockPos pos, EntityPlayerMP player, EnumBattleStartTypes startType, EntityPixelmon fightingPokemon, IBlockState state) {
        int lvl;
        Level level;
        Entity entity;
        SpawnLocation spawnLocation;
        SpatialData data;
        Entity3HasStats pixelmon = null;
        PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
        Pokemon firstAble = party.findOne(pokemon -> !pokemon.isEgg() && pokemon.getHealth() > 0);
        if (firstAble == null) {
            return;
        }
        if (startType == EnumBattleStartTypes.PUGRASSSINGLE) {
            if (PixelmonSpawning.grassSpawner != null && PixelmonSpawning.coordinator != null) {
                data = PixelmonSpawning.grassSpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.GRASS}), worldIn.func_180495_p(pos).func_177230_c(), data.uniqueSurroundingBlocks, worldIn.func_180494_b(pos), worldIn.func_175678_i(pos), 6, worldIn.func_175699_k(pos.func_177984_a()));
                entity = PixelmonSpawning.grassSpawner.trigger(spawnLocation);
                if (entity instanceof EntityPixelmon) {
                    pixelmon = (EntityPixelmon)entity;
                }
            }
            if (PixelmonConfig.scaleGrassBattles) {
                int minLvl;
                int maxLvl = Math.min(party.getHighestLevel(), PixelmonServerConfig.maxLevel);
                if (maxLvl - (minLvl = party.getLowestLevel()) > 5) {
                    minLvl = maxLvl - minLvl;
                }
                level = pixelmon.getLvl();
                if (minLvl < maxLvl) {
                    lvl = RNG.nextInt(maxLvl - minLvl) + minLvl;
                    level.setLevel(lvl);
                } else {
                    level.setLevel(maxLvl);
                }
                pixelmon.getPokemonData().getMoveset().clear();
                pixelmon.getPokemonData().getMoveset().addAll(pixelmon.getBaseStats().loadMoveset(level.getLevel()));
            }
            EntityPixelmon startingPixelmon = firstAble.getOrSpawnPixelmon((Entity)player);
            if (pixelmon != null) {
                this.setupBattle(worldIn, pos, player, startType, startingPixelmon, (EntityPixelmon)pixelmon);
            }
        }
        if (startType == EnumBattleStartTypes.PUGRASSDOUBLE) {
            if (PixelmonSpawning.tallGrassSpawner != null && PixelmonSpawning.coordinator != null) {
                data = PixelmonSpawning.tallGrassSpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.DOUBLE_GRASS}), worldIn.func_180495_p(pos).func_177230_c(), data.uniqueSurroundingBlocks, worldIn.func_180494_b(pos), worldIn.func_175678_i(pos), 6, worldIn.func_175699_k(pos.func_177984_a()));
                entity = PixelmonSpawning.tallGrassSpawner.trigger(spawnLocation);
                if (entity instanceof EntityPixelmon) {
                    pixelmon = (EntityPixelmon)entity;
                }
            } else if (PixelmonConfig.scaleGrassBattles) {
                int minLvl;
                int maxLvl = Math.min(party.getHighestLevel(), PixelmonServerConfig.maxLevel);
                if (maxLvl - (minLvl = party.getLowestLevel()) > 5) {
                    minLvl = maxLvl - minLvl;
                }
                level = pixelmon.getLvl();
                if (minLvl < maxLvl) {
                    lvl = RNG.nextInt(maxLvl - minLvl) + minLvl;
                    level.setLevel(lvl);
                } else {
                    level.setLevel(maxLvl);
                }
                pixelmon.getPokemonData().getMoveset().clear();
                pixelmon.getPokemonData().getMoveset().addAll(pixelmon.getBaseStats().loadMoveset(level.getLevel()));
            }
            EntityPixelmon startingPixelmon = firstAble.getOrSpawnPixelmon((Entity)player);
            if (pixelmon != null) {
                this.setupBattle(worldIn, pos, player, startType, startingPixelmon, (EntityPixelmon)pixelmon);
            }
        } else if (startType == EnumBattleStartTypes.CAVEROCK) {
            if (PixelmonSpawning.caveRockSpawner != null && PixelmonSpawning.coordinator != null) {
                data = PixelmonSpawning.caveRockSpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos.func_177984_a()), Sets.newHashSet((Object[])new LocationType[]{LocationType.CAVE_ROCK}), worldIn.func_180495_p(pos).func_177230_c(), data.uniqueSurroundingBlocks, worldIn.func_180494_b(pos), worldIn.func_175678_i(pos), 6, worldIn.func_175699_k(pos.func_177984_a()));
                entity = PixelmonSpawning.caveRockSpawner.trigger(spawnLocation);
                if (entity instanceof EntityPixelmon) {
                    pixelmon = (EntityPixelmon)entity;
                }
            }
            if (PixelmonConfig.scaleGrassBattles) {
                int minLvl;
                int maxLvl = Math.min(party.getHighestLevel(), PixelmonServerConfig.maxLevel);
                if (maxLvl - (minLvl = party.getLowestLevel()) > 5) {
                    minLvl = maxLvl - minLvl;
                }
                level = pixelmon.getLvl();
                if (minLvl < maxLvl) {
                    lvl = RNG.nextInt(maxLvl - minLvl) + minLvl;
                    level.setLevel(lvl);
                } else {
                    level.setLevel(maxLvl);
                }
                pixelmon.getPokemonData().getMoveset().clear();
                pixelmon.getPokemonData().getMoveset().addAll(pixelmon.getBaseStats().loadMoveset(level.getLevel()));
            }
            EntityPixelmon startingPixelmon = firstAble.getOrSpawnPixelmon((Entity)player);
            if (pixelmon != null) {
                this.setupBattle(worldIn, pos.func_177984_a(), player, startType, startingPixelmon, (EntityPixelmon)pixelmon);
            }
        } else if (startType == EnumBattleStartTypes.HEADBUTT) {
            if (PixelmonSpawning.headbuttSpawner != null && PixelmonSpawning.coordinator != null) {
                data = PixelmonSpawning.headbuttSpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                data.baseBlock = worldIn.func_180495_p(pos).func_177230_c();
                spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.HEADBUTT}), worldIn.func_180495_p(pos).func_177230_c(), data.uniqueSurroundingBlocks, worldIn.func_180494_b(pos), worldIn.func_175678_i(pos), 6, worldIn.func_175699_k(pos.func_177984_a()));
                entity = PixelmonSpawning.headbuttSpawner.trigger(spawnLocation);
                if (entity instanceof EntityPixelmon) {
                    pixelmon = (EntityPixelmon)entity;
                }
            }
            if (pixelmon != null) {
                this.setupBattle(worldIn, pos, player, startType, fightingPokemon, (EntityPixelmon)pixelmon);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.moveskill.headbutt.battle", new Object[]{pixelmon.getLocalizedName()}));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.moveskill.headbutt.nothing", new Object[0]));
            }
        } else if (startType == EnumBattleStartTypes.ROCKSMASH) {
            if (PixelmonSpawning.rocksmashSpawner != null && PixelmonSpawning.coordinator != null) {
                data = PixelmonSpawning.rocksmashSpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                data.baseBlock = state.func_177230_c();
                spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.ROCK_SMASH}), data.baseBlock, data.uniqueSurroundingBlocks, worldIn.func_180494_b(pos), worldIn.func_175678_i(pos), 10, worldIn.func_175699_k(pos.func_177984_a()));
                entity = PixelmonSpawning.rocksmashSpawner.trigger(spawnLocation);
                if (entity instanceof EntityPixelmon) {
                    pixelmon = (EntityPixelmon)entity;
                }
            }
            if (pixelmon != null) {
                this.setupBattle(worldIn, pos, player, startType, fightingPokemon, (EntityPixelmon)pixelmon);
            }
        } else if (startType == EnumBattleStartTypes.SWEETSCENT) {
            if (PixelmonSpawning.sweetscentSpawner != null && PixelmonSpawning.coordinator != null) {
                data = PixelmonSpawning.sweetscentSpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
                spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.SWEET_SCENT}), worldIn.func_180495_p(pos).func_177230_c(), data.uniqueSurroundingBlocks, worldIn.func_180494_b(pos), worldIn.func_175678_i(pos), 6, worldIn.func_175699_k(pos.func_177984_a()));
                entity = PixelmonSpawning.sweetscentSpawner.trigger(spawnLocation);
                if (entity instanceof EntityPixelmon) {
                    pixelmon = (EntityPixelmon)entity;
                }
                if (pixelmon != null) {
                    this.setupBattle(worldIn, pos, player, startType, fightingPokemon, (EntityPixelmon)pixelmon);
                }
            }
        } else if (startType == EnumBattleStartTypes.FORAGE && PixelmonSpawning.forageSpawner != null && PixelmonSpawning.coordinator != null) {
            data = PixelmonSpawning.forageSpawner.calculateSpatialData(worldIn, pos.func_177984_a(), 10, true, block -> true);
            data.baseBlock = worldIn.func_180495_p(pos).func_177230_c();
            spawnLocation = new SpawnLocation((Entity)player, new MutableLocation(worldIn, pos), Sets.newHashSet((Object[])new LocationType[]{LocationType.FORAGE}), worldIn.func_180495_p(pos).func_177230_c(), data.uniqueSurroundingBlocks, worldIn.func_180494_b(pos), worldIn.func_175678_i(pos), 6, worldIn.func_175699_k(pos.func_177984_a()));
            entity = PixelmonSpawning.forageSpawner.trigger(spawnLocation);
            if (entity instanceof EntityPixelmon) {
                pixelmon = (EntityPixelmon)entity;
            }
            if (pixelmon != null) {
                this.setupBattle(worldIn, pos, player, startType, fightingPokemon, (EntityPixelmon)pixelmon);
            }
        }
    }

    private void setupBattle(World worldIn, BlockPos pos, EntityPlayerMP player, EnumBattleStartTypes startType, EntityPixelmon fightingPokemon, EntityPixelmon pixelmon) {
        PlayerParticipant playerParticipant = new PlayerParticipant(player, fightingPokemon);
        WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(true, pixelmon);
        if (pixelmon == null || Pixelmon.EVENT_BUS.post((Event)new PixelmonBlockStartingBattleEvent(worldIn, pos, player, startType, fightingPokemon, pixelmon, null))) {
            return;
        }
        wildPixelmonParticipant.startedBattle = true;
        BattleRegistry.startBattle(playerParticipant, wildPixelmonParticipant);
    }
}

