/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileEntities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.legendary.TimespaceEvent;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.blocks.BlockRotation;
import com.pixelmonmod.pixelmon.blocks.machines.BlockTimespaceAltar;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.RotateEntity;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.items.heldItems.ItemTimespaceOrb;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTimespaceAltar
extends TileEntity
implements ITickable {
    public Orb orbIn = Orb.NONE;
    public boolean chainIn = false;
    public boolean flutePlayed = false;
    private boolean spawning = false;
    public int timeSpent = 0;
    public boolean summoningShiny = false;
    public EntityPlayer summoningPlayer = null;
    public IBlockState summoningState = null;

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("OrbIn", this.orbIn.ordinal());
        nbt.func_74757_a("ChainIn", this.chainIn);
        nbt.func_74757_a("FlutePlayed", this.flutePlayed);
        nbt.func_74768_a("TimeSpent", this.timeSpent);
        nbt.func_74757_a("IsShiny", this.summoningShiny);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.orbIn = Orb.values()[nbt.func_74762_e("OrbIn")];
        this.chainIn = nbt.func_74767_n("ChainIn");
        this.flutePlayed = nbt.func_74767_n("FlutePlayed");
        this.timeSpent = nbt.func_74762_e("TimeSpent");
        this.summoningShiny = nbt.func_74767_n("IsShiny");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public void func_70296_d() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        super.func_70296_d();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void activate(EntityPlayer player, BlockTimespaceAltar block, IBlockState state, ItemStack item) {
        if (!(this.orbIn == Orb.NONE && !this.chainIn || !player.func_70093_af() || this.orbIn != Orb.NONE && this.chainIn)) {
            if (this.orbIn != Orb.NONE) {
                if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.TakeOrb(player, this, item))) return;
                switch (this.orbIn) {
                    case PALKIA: {
                        player.func_191521_c(new ItemStack(PixelmonItemsHeld.lustrous_orb));
                        break;
                    }
                    case DIALGA: {
                        player.func_191521_c(new ItemStack(PixelmonItemsHeld.adamant_orb));
                        break;
                    }
                    case GIRATINA: {
                        player.func_191521_c(new ItemStack(PixelmonItemsHeld.griseous_orb));
                        break;
                    }
                }
                this.orbIn = Orb.NONE;
                this.func_70296_d();
                return;
            } else {
                if (!this.chainIn || Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.TakeChain(player, this, item))) return;
                player.func_191521_c(new ItemStack(PixelmonItems.redchain));
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187713_n, SoundCategory.BLOCKS, 1.0f, 50.0f);
                this.chainIn = false;
                this.func_70296_d();
            }
            return;
        }
        if (item == null || item == ItemStack.field_190927_a) return;
        if (item.func_77973_b() instanceof ItemTimespaceOrb || item.func_77973_b() == PixelmonItems.redchain) {
            if (player.field_70170_p.field_72995_K) return;
            if (this.timeSpent == 0) {
                if (item.func_77973_b() instanceof ItemTimespaceOrb) {
                    ItemStack stack = ItemStack.field_190927_a;
                    if (this.orbIn == Orb.PALKIA) {
                        stack = new ItemStack(PixelmonItemsHeld.lustrous_orb, 1);
                    } else if (this.orbIn == Orb.DIALGA) {
                        stack = new ItemStack(PixelmonItemsHeld.adamant_orb, 1);
                    } else if (this.orbIn == Orb.GIRATINA) {
                        stack = new ItemStack(PixelmonItemsHeld.griseous_orb, 1);
                    }
                    if (stack != ItemStack.field_190927_a) {
                        if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.TakeOrb(player, this, stack))) return;
                        player.func_191521_c(stack);
                    }
                }
                if (item.func_77973_b() instanceof ItemTimespaceOrb) {
                    if (!this.chainIn) {
                        ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timespace.needchain", new Object[0]);
                        return;
                    }
                    if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.PlaceOrb(player, this, item))) return;
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187766_dk, SoundCategory.BLOCKS, 1.0f, 5.0f);
                    if (item.func_77973_b() == PixelmonItemsHeld.lustrous_orb) {
                        this.orbIn = Orb.PALKIA;
                    } else if (item.func_77973_b() == PixelmonItemsHeld.adamant_orb) {
                        this.orbIn = Orb.DIALGA;
                    } else if (item.func_77973_b() == PixelmonItemsHeld.griseous_orb) {
                        this.orbIn = Orb.GIRATINA;
                    }
                    this.func_70296_d();
                    if (!player.func_184812_l_()) {
                        item.func_190918_g(1);
                    }
                } else if (item.func_77973_b() == PixelmonItems.redchain) {
                    if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.PlaceChain(player, this, item))) return;
                    this.chainIn = true;
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187713_n, SoundCategory.BLOCKS, 1.0f, 50.0f);
                    this.func_70296_d();
                    if (!player.func_184812_l_()) {
                        item.func_190918_g(1);
                    }
                }
            }
            if (this.orbIn == Orb.NONE || !this.chainIn || this.spawning || this.flutePlayed) return;
            this.summoningPlayer = player;
            this.summoningState = state;
            this.spawning = true;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187810_eg, SoundCategory.NEUTRAL, 1.0f, 0.1f);
            this.summoningShiny = PixelmonConfig.getShinyRate(this.field_145850_b.field_73011_w.getDimension()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfig.getShinyRate(this.field_145850_b.field_73011_w.getDimension()));
            Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.Summon.Pre(player, this));
            this.func_70296_d();
            return;
        } else if (this.chainIn && !this.spawning && !this.flutePlayed) {
            ItemStack chain = new ItemStack(PixelmonItems.redchain);
            if (Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.TakeChain(player, this, chain))) return;
            this.chainIn = false;
            player.func_191521_c(chain);
            this.func_70296_d();
            return;
        } else {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.timespace.notorb", new Object[0]);
        }
    }

    public void func_73660_a() {
        block13: {
            block14: {
                float spawnRot;
                double zOffset;
                double xOffset;
                EntityPixelmon pixelmonEntity;
                block16: {
                    block15: {
                        if (!this.spawning && !this.flutePlayed || this.field_145850_b.field_72995_K) break block13;
                        ++this.timeSpent;
                        if (this.summoningPlayer == null) {
                            this.reset();
                            this.func_70296_d();
                            return;
                        }
                        if (this.timeSpent <= 200) break block14;
                        if (!this.spawning) break block15;
                        switch (this.orbIn) {
                            case PALKIA: {
                                pixelmonEntity = (EntityPixelmon)PixelmonEntityList.createEntityByName(EnumSpecies.Palkia.name, this.field_145850_b);
                                pixelmonEntity.getPokemonData().setHeldItem(new ItemStack(PixelmonItemsHeld.lustrous_orb));
                                break block16;
                            }
                            case DIALGA: {
                                pixelmonEntity = (EntityPixelmon)PixelmonEntityList.createEntityByName(EnumSpecies.Dialga.name, this.field_145850_b);
                                pixelmonEntity.getPokemonData().setHeldItem(new ItemStack(PixelmonItemsHeld.adamant_orb));
                                break block16;
                            }
                            case GIRATINA: {
                                pixelmonEntity = (EntityPixelmon)PixelmonEntityList.createEntityByName(EnumSpecies.Giratina.name, this.field_145850_b);
                                pixelmonEntity.getPokemonData().setHeldItem(new ItemStack(PixelmonItemsHeld.griseous_orb));
                                break block16;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    pixelmonEntity = (EntityPixelmon)PixelmonEntityList.createEntityByName("Arceus", this.field_145850_b);
                    pixelmonEntity.getLvl().setLevel(80);
                }
                pixelmonEntity.getPokemonData().setGrowth(EnumGrowth.Ordinary);
                pixelmonEntity.getPokemonData().setShiny(this.summoningShiny);
                PlayerPartyStorage party = Pixelmon.storageManager.getParty((EntityPlayerMP)this.summoningPlayer);
                BlockRotation rot = BlockRotation.getRotationFromMetadata(this.func_145832_p());
                if (rot == BlockRotation.Normal) {
                    xOffset = 0.5;
                    zOffset = 5.5;
                    spawnRot = 0.0f;
                } else if (rot == BlockRotation.Rotate180) {
                    xOffset = 0.5;
                    zOffset = -4.5;
                    spawnRot = 180.0f;
                } else if (rot == BlockRotation.CW) {
                    xOffset = -4.5;
                    zOffset = 0.5;
                    spawnRot = 90.0f;
                } else {
                    xOffset = 5.5;
                    zOffset = 0.5;
                    spawnRot = 270.0f;
                }
                EntityPixelmon startingPixelmon = party.getAndSendOutFirstAblePokemon((Entity)this.summoningPlayer);
                if (startingPixelmon == null || BattleRegistry.getBattle(this.summoningPlayer) != null) {
                    this.spawnEntity(pixelmonEntity, (double)this.field_174879_c.func_177958_n() + xOffset, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + zOffset, spawnRot);
                    Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.Summon.Post(this.summoningPlayer, this, pixelmonEntity));
                    this.reset();
                    this.func_70296_d();
                    return;
                }
                this.spawnEntity(pixelmonEntity, (double)this.field_174879_c.func_177958_n() + xOffset, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + zOffset, spawnRot);
                Pixelmon.EVENT_BUS.post((Event)new TimespaceEvent.Summon.Post(this.summoningPlayer, this, pixelmonEntity));
                PlayerParticipant playerParticipant = new PlayerParticipant((EntityPlayerMP)this.summoningPlayer, startingPixelmon);
                WildPixelmonParticipant wildPixelmonParticipant = new WildPixelmonParticipant(false, pixelmonEntity);
                wildPixelmonParticipant.startedBattle = true;
                BattleRegistry.startBattle(playerParticipant, wildPixelmonParticipant);
                this.reset();
            }
            this.func_70296_d();
        }
    }

    public void reset() {
        this.orbIn = Orb.NONE;
        this.chainIn = false;
        this.spawning = false;
        this.flutePlayed = false;
        this.timeSpent = 0;
        this.summoningState = null;
        this.summoningPlayer = null;
        this.summoningShiny = false;
    }

    public void spawnEntity(EntityPixelmon pixelmonEntity, double x, double y, double z, float rotation) {
        pixelmonEntity.func_70080_a(x, y, z, rotation, pixelmonEntity.field_70125_A);
        this.func_145831_w().func_72838_d((Entity)pixelmonEntity);
        Pixelmon.network.sendToDimension((IMessage)new RotateEntity(pixelmonEntity.func_145782_y(), rotation, pixelmonEntity.field_70125_A), pixelmonEntity.field_71093_bK);
        pixelmonEntity.func_70091_d(null, 0.1, 0.1, 0.1);
        pixelmonEntity.field_70126_B = rotation;
        pixelmonEntity.field_70177_z = rotation;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public static enum Orb {
        NONE,
        PALKIA,
        DIALGA,
        GIRATINA;

    }
}

