/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.pokemonOverlays;

import com.pixelmonmod.pixelmon.battles.attacks.BattleMessageBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.client.storage.ClientPokedex;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;

public abstract class OverlayBase
extends GuiScreen {
    GuiBattle parent;
    ClientBattleManager bm;

    public OverlayBase(GuiBattle parent) {
        this.parent = parent;
        this.field_146297_k = Minecraft.func_71410_x();
        this.bm = ClientProxy.battleManager;
    }

    public abstract void draw(int var1, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void displayMessage() {
        ArrayList<BattleMessageBase> arrayList = this.bm.battleMessages;
        synchronized (arrayList) {
            if (!this.bm.battleMessages.isEmpty()) {
                try {
                    ArrayList<BattleMessageBase> ibms = new ArrayList<BattleMessageBase>();
                    ibms.add(this.bm.battleMessages.get(0));
                    for (int i = 1; i < this.bm.battleMessages.size(); ++i) {
                        BattleMessageBase ibm = this.bm.battleMessages.get(i);
                        boolean conflicts = false;
                        for (BattleMessageBase ibmMatch : ibms) {
                            if (ibm.messageType == ibmMatch.messageType && !ibm.pokemonUUID.equals(ibmMatch.pokemonUUID)) continue;
                            conflicts = true;
                            break;
                        }
                        if (conflicts) break;
                        ibms.add(ibm);
                    }
                    for (BattleMessageBase ibm : ibms) {
                        if (ibm == null || ibm.viewed) continue;
                        ibm.viewed = true;
                        ibm.process();
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    protected void drawExpBar(int x, int y, int width, int height, PixelmonInGui p) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        int barWidth = p.level < PixelmonServerConfig.maxLevel ? (int)(p.expFraction * ((float)width - 6.0f)) : 0;
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldRenderer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        worldRenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181666_a(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        worldRenderer.func_181662_b((double)(x + width), (double)y, 0.0).func_181666_a(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        worldRenderer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        worldRenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        worldRenderer.func_181662_b((double)(x + barWidth), (double)(y + height), 0.0).func_181666_a(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        worldRenderer.func_181662_b((double)(x + barWidth), (double)y, 0.0).func_181666_a(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179101_C();
        GlStateManager.func_179119_h();
    }

    protected boolean hasCaught(PixelmonInGui targetPokemon) {
        ClientPokedex pokedex = ClientStorageManager.pokedex;
        if (pokedex == null) {
            return false;
        }
        try {
            return pokedex.hasCaught(targetPokemon.getDexNumber());
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    protected void drawOpponentPokemon(PixelmonInGui targetPokemon, int position, int width, int height, int guiWidth, int guiHeight) {
        String targetName = targetPokemon.getDisplayName();
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokemonInfoP2);
        int yPos = position * 37;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        targetPokemon.xPos = Math.min(0, targetPokemon.xPos);
        GuiHelper.drawImageQuad(targetPokemon.xPos, yPos, 119.0, 34.0f, 0.0, 0.0, 0.9296875, 0.53125, this.field_73735_i);
        this.func_73731_b(this.field_146297_k.field_71466_p, targetName, targetPokemon.xPos + 8, yPos + 8, 0xFFFFFF);
        if (targetPokemon.status != -1 && StatusType.getEffect(targetPokemon.status) != null) {
            float[] texturePair2 = StatusType.getTexturePos(StatusType.getEffect(targetPokemon.status));
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.status);
            GuiHelper.drawImageQuad(targetPokemon.xPos + 71, yPos + 17, 10.5, 10.5f, texturePair2[0] / 768.0f, texturePair2[1] / 512.0f, (texturePair2[0] + 240.0f) / 768.0f, (texturePair2[1] + 240.0f) / 512.0f, this.field_73735_i);
        }
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokemonInfoP2);
        GuiBattle.drawHealthBar(targetPokemon.xPos + 18, yPos + 19, 56, 6, targetPokemon.health, targetPokemon.maxHealth);
        GuiHelper.drawImageQuad(targetPokemon.xPos + 8, yPos + 18, 62.0, 9.0f, 0.0078125, 0.671875, 0.4921875, 0.828125, this.field_73735_i);
        boolean caught = this.hasCaught(targetPokemon);
        if (targetPokemon.gender == Gender.Male.ordinal()) {
            GuiHelper.drawImageQuad(targetPokemon.xPos + 8 + this.field_146297_k.field_71466_p.func_78256_a(targetName), yPos + 6, 7.0, 10.0f, 0.5625, 0.65625, 0.6171875, 0.8125, this.field_73735_i);
        } else if (targetPokemon.gender == Gender.Female.ordinal()) {
            GuiHelper.drawImageQuad(targetPokemon.xPos + 8 + this.field_146297_k.field_71466_p.func_78256_a(targetName), yPos + 6, 7.0, 10.0f, 0.5, 0.65625, 0.5546875, 0.8125, this.field_73735_i);
        }
        int iconSize = 13;
        int iconX = 106 - iconSize;
        if (targetPokemon.shiny) {
            int iconY = yPos + 18;
            int yOffset = 0;
            if (caught) {
                yOffset = -3;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.caught);
                GuiHelper.drawImageQuad(targetPokemon.xPos + iconX, iconY - yOffset, 10.0, 10.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            }
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokemonInfoP2);
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.overlay1v1.lv", (Object[])new Object[0]) + targetPokemon.level, targetPokemon.xPos + 111 - this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"gui.overlay1v1.lv", (Object[])new Object[0]) + targetPokemon.level), yPos + 8, 0xFFFFFF);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.shiny);
            GuiHelper.drawImageQuad(targetPokemon.xPos + iconX, iconY + yOffset, 10.0, 10.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        } else {
            if (caught) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.caught);
                GuiHelper.drawImageQuad(targetPokemon.xPos + iconX, yPos + 18, 10.0, 10.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            }
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokemonInfoP2);
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.overlay1v1.lv", (Object[])new Object[0]) + targetPokemon.level, targetPokemon.xPos + 111 - this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"gui.overlay1v1.lv", (Object[])new Object[0]) + targetPokemon.level), yPos + 8, 0xFFFFFF);
        }
        GuiHelper.bindPokemonSprite(targetPokemon, this.field_146297_k);
        GuiHelper.drawImageQuad(targetPokemon.xPos + 112 - iconSize, yPos + 16, iconSize, iconSize, 1.0, 0.0, 0.0, 1.0, this.field_73735_i);
    }

    protected void drawOwnedPokemon(PixelmonInGui userPokemon, int position, int width, int height, int guiWidth, int guiHeight) {
        userPokemon.xPos = Math.min(120, userPokemon.xPos);
        int xPos = width - userPokemon.xPos;
        int yPos = height - (guiHeight + 37) + (position - 1) * 47;
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokemonInfoP1);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawImageQuad(xPos, yPos - 8, 120.0, 45.0f, 0.0, 0.0, 0.9375, 0.703125, this.field_73735_i);
        String name = userPokemon.getDisplayName();
        this.func_73731_b(this.field_146297_k.field_71466_p, name, xPos + 7, yPos, 0xFFFFFF);
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokemonInfoP1);
        this.drawExpBar(xPos + 6, yPos + 29, 105, 4, userPokemon);
        GuiHelper.drawImageQuad(xPos + 5, yPos + 26, 109.0, 7.0f, 0.0078125, 0.875, 0.859375, 0.96875, this.field_73735_i);
        GuiBattle.drawHealthBar(xPos + 19, yPos + 11, 97, 6, userPokemon.health, userPokemon.maxHealth);
        GuiHelper.drawImageQuad(xPos + 9, yPos + 9, 103.0, 9.0f, 0.0078125, 0.703125, 0.8125, 0.859375, this.field_73735_i);
        if (!this.bm.isSpectating) {
            this.func_73731_b(this.field_146297_k.field_71466_p, "" + Math.round(userPokemon.health) + "/" + userPokemon.maxHealth, xPos + 110 - this.field_146297_k.field_71466_p.func_78256_a("" + Math.round(userPokemon.health) + "/" + userPokemon.maxHealth), yPos + 19, 0xFFFFFF);
        }
        if (userPokemon.status != -1) {
            float[] texturePair = StatusType.getTexturePos(StatusType.getEffect(userPokemon.status));
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.status);
            GuiHelper.drawImageQuad(width - userPokemon.xPos + 18, yPos + 18, 8.75, 8.75f, texturePair[0] / 768.0f, texturePair[1] / 512.0f, (texturePair[0] + 240.0f) / 768.0f, (texturePair[1] + 240.0f) / 512.0f, this.field_73735_i);
        }
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokemonInfoP1);
        if (userPokemon.gender == Gender.Male.ordinal()) {
            GuiHelper.drawImageQuad(xPos + 7 + this.field_146297_k.field_71466_p.func_78256_a(name), yPos - 2, 7.0, 10.0f, 0.9296875, 0.8125, 0.984375, 0.96875, this.field_73735_i);
        } else if (userPokemon.gender == Gender.Female.ordinal()) {
            GuiHelper.drawImageQuad(xPos + 7 + this.field_146297_k.field_71466_p.func_78256_a(name), yPos - 2, 7.0, 10.0f, 0.8671875, 0.8125, 0.921875, 0.96875, this.field_73735_i);
        }
        if (userPokemon.shiny) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.shiny);
            GuiHelper.drawImageQuad(xPos + 13, yPos + 17, 10.0, 10.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        }
        int levelXPos = xPos + 110 - this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"gui.overlay1v1.lv", (Object[])new Object[0]) + userPokemon.level);
        this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.overlay1v1.lv", (Object[])new Object[0]) + userPokemon.level, levelXPos, yPos, 0xFFFFFF);
        if (this.bm.megaEvolution != null && this.bm.megaEvolution.equals(userPokemon.pokemonUUID)) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.keyStoneSprite);
            GuiHelper.drawImageQuad(levelXPos - 13, yPos - 1, 10.5, 10.5f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        } else if (this.bm.dynamax != null && this.bm.dynamax.equals(userPokemon.pokemonUUID)) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.dynamaxSprite);
            GuiHelper.drawImageQuad(levelXPos - 13, yPos - 1, 10.5, 10.5f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        }
        GuiHelper.bindPokemonSprite(userPokemon, this.field_146297_k);
        int iconSize = 10;
        GuiHelper.drawImageQuad(xPos + 6, yPos + 17, iconSize, iconSize, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
    }

    public abstract int mouseOverEnemyPokemon(int var1, int var2, int var3, int var4);

    public abstract int mouseOverUserPokemon(int var1, int var2, int var3, int var4, int var5, int var6);
}

