/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.timerTasks;

import com.pixelmonmod.pixelmon.battles.attacks.BattleMessageBase;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.client.gui.battles.timerTasks.BattleTask;
import java.util.Objects;
import java.util.UUID;

public abstract class HPTask
extends BattleTask {
    float healthDifference;
    float originalHealth;
    float currentHealth;
    float interval;
    UUID uuid;
    PixelmonInGui pokemon;

    public HPTask(BattleMessageBase message, float healthDifference, UUID uuid) {
        super(message);
        this.healthDifference = healthDifference;
        this.uuid = uuid;
        this.pokemon = ClientProxy.battleManager.getPokemon(uuid);
        if (this.pokemon != null) {
            this.currentHealth = this.originalHealth = this.pokemon.health;
            this.boundsCheck();
        }
        this.interval = this.healthDifference / 100.0f;
    }

    protected abstract void boundsCheck();

    @Override
    public void run() {
        if (this.pokemon == null) {
            this.cancel();
            return;
        }
        this.currentHealth += this.interval;
        if (this.isDone()) {
            this.pokemon.health = Math.max(0.0f, this.originalHealth + this.healthDifference);
            ClientProxy.battleManager.fullOurPokemon.stream().filter(pig -> Objects.equals(pig.pokemonUUID, this.pokemon.pokemonUUID)).forEach(pig -> {
                pig.health = this.pokemon.health;
            });
            this.cancel();
            return;
        }
        this.pokemon.health = this.currentHealth;
    }

    protected abstract boolean isDone();
}

