/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.fishingLog;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.GuiBubbleObject;
import com.pixelmonmod.pixelmon.client.gui.fishingLog.GuiFishingLog;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.RenderPixelmon;
import com.pixelmonmod.pixelmon.config.FormLogRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class GuiFishingLogInformation
extends GuiScreen {
    private Pokemon pokemon;
    private int[] encountered;
    private int category;
    private double scalar = 10900.0;
    private EntityPixelmon displayedPokemon;
    private int centerX;
    private int centerY;
    private float guiHeight;
    private float guiWidth;
    private GuiButton okButton;
    private List<GuiBubbleObject> bubbles = Lists.newArrayList();

    public GuiFishingLogInformation(int dex, int category, int form, int ... data) {
        this.category = category;
        EnumSpecies species = EnumSpecies.getFromDex(dex);
        PokemonSpec spec = FormLogRegistry.getFormFromId(species, form);
        this.pokemon = Pixelmon.pokemonFactory.create(species);
        spec.apply(this.pokemon);
        this.encountered = Arrays.copyOfRange(data, 3, data.length);
    }

    public GuiFishingLogInformation(int dex, int category, PokemonSpec form, int[] data) {
        this.category = category;
        EnumSpecies species = EnumSpecies.getFromDex(dex);
        this.pokemon = Pixelmon.pokemonFactory.create(species);
        form.apply(this.pokemon);
        this.encountered = data;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.centerX = this.field_146294_l / 2;
        this.centerY = this.field_146295_m / 2;
        this.guiHeight = 220.0f;
        this.guiWidth = this.guiHeight * 0.698571f;
        int height = 20;
        int width = (int)((double)height * 5.338235294117647);
        this.okButton = this.func_189646_b(new GuiButton(0, this.centerX - width / 2, this.centerY + 70, width, height, ""));
        this.bubbles = Lists.newArrayList();
        this.setupDisplayedPokemon();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GuiHelper.bindFontRenderer("pixelmon:textures/gui/pokemonfont.png", true);
        if (this.bubbles.size() < 8 && RandomHelper.getRandomChance(0.05)) {
            int size = RandomHelper.getRandomNumberBetween(5, 10);
            this.bubbles.add(new GuiBubbleObject(this.centerX + RandomHelper.getRandomNumberBetween(-65, 65 - size), this.centerY, size));
        }
        this.drawScreenBackground();
        this.drawScreenForeground(mouseX, mouseY, partialTicks);
        GuiHelper.resetFontRenderer();
    }

    public void drawScreenBackground() {
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.fishingLogWater);
        float borderWidth = 1.0f;
        float width = this.guiWidth - borderWidth * 2.0f;
        GuiHelper.drawImageQuad((float)this.centerX - this.guiWidth / 2.0f + borderWidth, (float)this.centerY - this.guiHeight / 2.0f + borderWidth, width, width * 0.73f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        GL11.glPushMatrix();
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        float x1 = ((float)this.centerX - this.guiWidth / 2.0f) * (float)sr.func_78325_e();
        float x2 = ((float)this.centerX + this.guiWidth / 2.0f) * (float)sr.func_78325_e();
        float y1 = ((float)this.centerY - this.guiHeight / 2.0f + 1.0f) * (float)sr.func_78325_e();
        float y2 = this.centerY * sr.func_78325_e();
        GL11.glScissor((int)((int)x1), (int)((int)((float)Display.getHeight() - y2)), (int)((int)(x2 - x1)), (int)((int)(y2 - y1)));
        GL11.glEnable((int)3089);
        for (int i = 0; i < this.bubbles.size(); ++i) {
            GuiBubbleObject bubble = this.bubbles.get(i);
            bubble.render();
            if (!(bubble.getY() < (float)this.centerY - this.guiHeight / 2.0f - 20.0f)) continue;
            this.bubbles.remove(i--);
        }
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.fishingLogInformationBackground);
        GuiHelper.drawImageQuad((float)this.centerX - this.guiWidth / 2.0f, (float)this.centerY - this.guiHeight / 2.0f, this.guiWidth, this.guiHeight, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
    }

    public void drawScreenForeground(int mouseX, int mouseY, float partialTicks) {
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.fishingLogConfirmButton);
        GuiHelper.drawImageQuad(this.okButton.field_146128_h, this.okButton.field_146129_i, this.okButton.field_146120_f, this.okButton.field_146121_g, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        GuiHelper.drawCenteredString("Ok", this.centerX, this.okButton.field_146129_i + 6, this.okButton.func_146116_c(this.field_146297_k, mouseX, mouseY) ? -12687348 : -1);
        GuiHelper.drawScaledCenteredString(this.pokemon.getFormEnum().getLocalizedName(), this.centerX, this.centerY + 1, -7781367, 14.0f);
        GuiHelper.drawScaledCenteredSplitString(I18n.func_74838_a((String)(this.pokemon.getFormEnum().getUnlocalizedName() + ".description")), this.centerX, this.centerY + 30, -9945576, 12.0f, 140, false);
        this.drawEntityToScreen(this.centerX, this.centerY - 30, 70, this.displayedPokemon, mouseX, partialTicks);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiFishingLog(this.pokemon.getSpecies().getNationalPokedexInteger(), this.encountered));
    }

    private void setupDisplayedPokemon() {
        if (this.field_146297_k == null) {
            return;
        }
        this.displayedPokemon = new EntityPixelmon((World)this.field_146297_k.field_71441_e);
        this.displayedPokemon.func_70107_b(this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70163_u, this.field_146297_k.field_71439_g.field_70161_v);
        this.displayedPokemon.setPokemon(this.pokemon);
        this.displayedPokemon.getPokemonData().setGrowth(EnumGrowth.Ordinary);
        this.displayedPokemon.checkAnimation();
        this.displayedPokemon.setAnimation(AnimationType.SWIM);
        this.displayedPokemon.initAnimation();
        double referenceW = 50.0;
        double referenceH = 50.0;
        double dh = (double)this.displayedPokemon.field_70131_O - referenceH;
        double dw = (double)this.displayedPokemon.field_70130_N - referenceW;
        this.scalar = dh > dw ? referenceH / (double)this.displayedPokemon.field_70131_O : referenceW / (double)this.displayedPokemon.field_70130_N;
    }

    public void func_73876_c() {
        if (this.displayedPokemon != null && this.displayedPokemon.getAnimationVariables() != null) {
            this.displayedPokemon.getAnimationVariables().tick();
        }
    }

    private void drawEntityToScreen(int x, int y, int l, EntityPixelmon e, int mouseX, float pt) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179142_g();
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)x, (float)y, (float)100.0f);
        GlStateManager.func_179139_a((double)this.scalar, (double)this.scalar, (double)this.scalar);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)(x - mouseX) / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        try {
            RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            Render entityClassRenderObject = renderManager.func_78715_a(EntityPixelmon.class);
            RenderPixelmon rp = (RenderPixelmon)entityClassRenderObject;
            rp.renderPixelmon(e, 0.0, 0.0, 0.0, pt, true);
            renderManager.field_78735_i = 180.0f;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        GlStateManager.func_179114_b((float)(360.0f - (float)(x - mouseX) / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)(1.0 / this.scalar), (double)(1.0 / this.scalar), (double)(1.0 / this.scalar));
        GlStateManager.func_179121_F();
    }
}

