/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.blockReveal;

import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.client.render.blockReveal.BlockReveal;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class BlockRevealRenderer {
    public static CopyOnWriteArrayList<BlockReveal> revealedBlocks = new CopyOnWriteArrayList();
    private boolean increasing = true;
    private short ticker = 0;
    private long lastTime = -1L;
    private int tickDecrease = 0;

    public void doRender() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            revealedBlocks.clear();
            return;
        }
        if (this.increasing) {
            this.ticker = (short)(this.ticker + 1);
            if (this.ticker >= 100) {
                this.increasing = false;
            }
        } else {
            this.ticker = (short)(this.ticker - 1);
            if (this.ticker <= 0) {
                this.increasing = true;
            }
        }
        if (this.lastTime != -1L) {
            int ticks = (int)(mc.field_71441_e.func_82737_E() - this.lastTime);
            if (ticks != 0) {
                this.tickDecrease = ticks;
                this.lastTime = mc.field_71441_e.func_82737_E();
            }
        } else {
            this.lastTime = mc.field_71441_e.func_82737_E();
        }
        this.preRender();
        if (revealedBlocks.size() > 0) {
            revealedBlocks.removeIf(blockReveal -> !this.render((BlockReveal)blockReveal));
        }
        this.postRender();
    }

    private boolean render(BlockReveal block) {
        Minecraft mc = Minecraft.func_71410_x();
        block.drawDown = true;
        block.drawUp = true;
        block.drawNorth = true;
        block.drawSouth = true;
        block.drawEast = true;
        block.drawWest = true;
        for (BlockReveal reveal : revealedBlocks) {
            if (reveal.getPos().equals((Object)block.getPos().func_177972_a(EnumFacing.DOWN))) {
                block.drawDown = false;
            }
            if (reveal.getPos().equals((Object)block.getPos().func_177972_a(EnumFacing.UP))) {
                block.drawUp = false;
            }
            if (reveal.getPos().equals((Object)block.getPos().func_177972_a(EnumFacing.NORTH))) {
                block.drawNorth = false;
            }
            if (reveal.getPos().equals((Object)block.getPos().func_177972_a(EnumFacing.SOUTH))) {
                block.drawSouth = false;
            }
            if (reveal.getPos().equals((Object)block.getPos().func_177972_a(EnumFacing.EAST))) {
                block.drawEast = false;
            }
            if (!reveal.getPos().equals((Object)block.getPos().func_177972_a(EnumFacing.WEST))) continue;
            block.drawWest = false;
        }
        if (block.getDimension() == mc.field_71441_e.field_73011_w.getDimension()) {
            int pattern = block.getPattern();
            boolean draw = true;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (block.getPattern() == 7) {
                if (WorldTime.getCurrent((World)mc.field_71441_e).contains(WorldTime.DAWN)) {
                    r = 0.54509807f;
                    g = 0.75686276f;
                    b = 0.7882353f;
                    pattern = 12;
                } else if (WorldTime.getCurrent((World)mc.field_71441_e).contains(WorldTime.DUSK)) {
                    r = 0.4627451f;
                    g = 0.44313726f;
                    b = 0.7411765f;
                    pattern = 13;
                } else {
                    draw = false;
                }
            } else {
                r = (float)block.getColor().getRed() / 255.0f;
                g = (float)block.getColor().getGreen() / 255.0f;
                b = (float)block.getColor().getBlue() / 255.0f;
            }
            if (draw) {
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)(0.7f - 0.4f * ((float)this.ticker / 100.0f) - (block.getTicksRemaining() <= 30 ? 0.7f - 0.7f * ((float)block.getTicksRemaining() / 30.0f) : 0.0f)));
                this.patternProvider(block, pattern);
            }
        }
        if (this.lastTime != -1L) {
            int ticks = (int)(mc.field_71441_e.func_82737_E() - this.lastTime);
            if (ticks != 0) {
                block.decreaseTicksRemaining(ticks);
                this.lastTime = mc.field_71441_e.func_82737_E();
            }
        } else {
            this.lastTime = mc.field_71441_e.func_82737_E();
        }
        block.decreaseTicksRemaining(this.tickDecrease);
        return block.getTicksRemaining() >= 0;
    }

    private void patternProvider(BlockReveal block, int pattern) {
        switch (pattern) {
            case 0: {
                this.pattern0(block);
                break;
            }
            case 1: {
                this.pattern1(block);
                break;
            }
            case 2: {
                this.pattern2(block);
                break;
            }
            case 3: {
                this.pattern3(block);
                break;
            }
            case 4: {
                this.pattern4(block);
                break;
            }
            case 5: {
                this.pattern5(block);
                break;
            }
            case 6: {
                this.pattern6(block);
                break;
            }
            case 7: {
                this.pattern7(block);
                break;
            }
            case 8: {
                this.pattern8(block);
                break;
            }
            case 9: {
                this.pattern9(block);
                break;
            }
            case 10: {
                this.pattern10(block);
                break;
            }
            case 11: {
                this.pattern11(block);
                break;
            }
            case 12: {
                this.pattern12(block);
                break;
            }
            case 13: {
                this.pattern13(block);
            }
        }
    }

    private void pattern0(BlockReveal block) {
        this.drawQuad(block, 4, 13, 5, 14);
        this.drawQuad(block, 7, 12, 9, 13);
        this.drawQuad(block, 12, 13, 14, 14);
        this.drawQuad(block, 10, 9, 12, 11);
        this.drawQuad(block, 8, 8, 10, 7);
        this.drawQuad(block, 7, 7, 11, 6);
        this.drawQuad(block, 5, 11, 7, 10);
        this.drawQuad(block, 3, 10, 8, 9);
        this.drawQuad(block, 1, 8, 3, 7);
        this.drawQuad(block, 4, 6, 5, 5);
        this.drawQuad(block, 3, 3, 5, 2);
        this.drawQuad(block, 11, 5, 13, 4);
        this.drawQuad(block, 8, 4, 14, 3);
        this.drawQuad(block, 9, 3, 11, 2);
    }

    private void pattern1(BlockReveal block) {
        this.drawQuad(block, 8, 15, 6, 13);
        this.drawQuad(block, 14, 13, 12, 11);
        this.drawQuad(block, 6, 12, 4, 10);
        this.drawQuad(block, 8, 11, 6, 9);
        this.drawQuad(block, 8, 8, 6, 6);
        this.drawQuad(block, 12, 7, 10, 5);
        this.drawQuad(block, 15, 6, 13, 4);
        this.drawQuad(block, 9, 5, 7, 3);
        this.drawQuad(block, 3, 3, 1, 1);
    }

    private void pattern2(BlockReveal block) {
        this.drawQuad(block, 14, 14, 12, 13);
        this.drawQuad(block, 9, 13, 7, 12);
        this.drawQuad(block, 6, 14, 2, 13);
        this.drawQuad(block, 6, 13, 5, 12);
        this.drawQuad(block, 12, 11, 10, 9);
        this.drawQuad(block, 7, 11, 5, 10);
        this.drawQuad(block, 8, 10, 3, 9);
        this.drawQuad(block, 3, 9, 1, 7);
        this.drawQuad(block, 12, 8, 11, 6);
        this.drawQuad(block, 11, 8, 9, 5);
        this.drawQuad(block, 9, 7, 8, 5);
        this.drawQuad(block, 8, 8, 7, 6);
        this.drawQuad(block, 15, 7, 13, 3);
        this.drawQuad(block, 11, 4, 8, 2);
        this.drawQuad(block, 5, 6, 4, 5);
        this.drawQuad(block, 5, 5, 2, 4);
        this.drawQuad(block, 6, 4, 5, 3);
        this.drawQuad(block, 7, 3, 4, 1);
    }

    private void pattern3(BlockReveal block) {
        this.drawQuad(block, 11, 2, 13, 3);
        this.drawQuad(block, 13, 3, 14, 4);
        this.drawQuad(block, 6, 2, 8, 3);
        this.drawQuad(block, 7, 3, 9, 4);
        this.drawQuad(block, 8, 4, 10, 5);
        this.drawQuad(block, 9, 5, 10, 6);
        this.drawQuad(block, 11, 6, 12, 7);
        this.drawQuad(block, 12, 5, 13, 8);
        this.drawQuad(block, 13, 6, 14, 9);
        this.drawQuad(block, 14, 7, 15, 10);
        this.drawQuad(block, 2, 4, 3, 5);
        this.drawQuad(block, 3, 4, 4, 6);
        this.drawQuad(block, 4, 5, 5, 7);
        this.drawQuad(block, 5, 6, 7, 9);
        this.drawQuad(block, 7, 8, 8, 10);
        this.drawQuad(block, 8, 8, 9, 11);
        this.drawQuad(block, 9, 9, 10, 11);
        this.drawQuad(block, 10, 9, 11, 12);
        this.drawQuad(block, 11, 10, 12, 12);
        this.drawQuad(block, 2, 8, 3, 11);
        this.drawQuad(block, 3, 9, 4, 10);
        this.drawQuad(block, 4, 10, 6, 13);
        this.drawQuad(block, 6, 11, 7, 14);
        this.drawQuad(block, 7, 12, 8, 13);
        this.drawQuad(block, 8, 12, 9, 14);
        this.drawQuad(block, 9, 13, 10, 15);
    }

    private void pattern4(BlockReveal block) {
        this.drawQuad(block, 3, 2, 4, 4);
        this.drawQuad(block, 2, 3, 3, 4);
        this.drawQuad(block, 13, 1, 14, 2);
        this.drawQuad(block, 11, 4, 13, 5);
        this.drawQuad(block, 9, 7, 11, 8);
        this.drawQuad(block, 5, 5, 6, 7);
        this.drawQuad(block, 6, 4, 7, 7);
        this.drawQuad(block, 7, 5, 8, 6);
        this.drawQuad(block, 1, 7, 2, 8);
        this.drawQuad(block, 3, 8, 5, 9);
        this.drawQuad(block, 5, 9, 8, 10);
        this.drawQuad(block, 10, 12, 11, 13);
        this.drawQuad(block, 11, 9, 12, 10);
        this.drawQuad(block, 12, 8, 13, 11);
        this.drawQuad(block, 13, 9, 14, 12);
        this.drawQuad(block, 1, 12, 3, 13);
        this.drawQuad(block, 3, 11, 4, 14);
        this.drawQuad(block, 4, 12, 5, 13);
    }

    private void pattern5(BlockReveal block) {
        this.drawQuad(block, 5, 6, 12, 8);
        this.drawQuad(block, 7, 8, 10, 10);
        this.drawQuad(block, 6, 8, 7, 9);
        this.drawQuad(block, 8, 10, 9, 11);
        this.drawQuad(block, 6, 5, 11, 6);
        this.drawQuad(block, 8, 4, 10, 5);
        this.drawQuad(block, 8, 3, 9, 4);
    }

    private void pattern6(BlockReveal block) {
        this.drawSizedQuad(block, 1, 8, 1, 1);
        this.drawSizedQuad(block, 2, 5, 1, 5);
        this.drawSizedQuad(block, 3, 4, 1, 7);
        this.drawSizedQuad(block, 4, 3, 6, 9);
        this.drawSizedQuad(block, 5, 12, 3, 1);
        this.drawSizedQuad(block, 10, 4, 1, 6);
        this.drawSizedQuad(block, 11, 4, 1, 5);
        this.drawSizedQuad(block, 12, 5, 1, 4);
        this.drawSizedQuad(block, 13, 5, 1, 2);
        this.drawSizedQuad(block, 13, 8, 1, 1);
        this.drawSizedQuad(block, 14, 5, 1, 1);
    }

    private void pattern7(BlockReveal block) {
    }

    private void pattern8(BlockReveal block) {
        this.drawSizedQuad(block, 7, 3, 1, 2);
        this.drawSizedQuad(block, 8, 3, 2, 3);
        this.drawSizedQuad(block, 10, 3, 1, 4);
        this.drawSizedQuad(block, 11, 4, 1, 6);
    }

    private void pattern9(BlockReveal block) {
        this.drawSizedQuad(block, 3, 11, 1, 1);
        this.drawSizedQuad(block, 4, 11, 1, 2);
        this.drawSizedQuad(block, 5, 10, 2, 3);
        this.drawSizedQuad(block, 7, 9, 1, 3);
        this.drawSizedQuad(block, 8, 8, 1, 4);
        this.drawSizedQuad(block, 9, 10, 1, 1);
        this.drawSizedQuad(block, 9, 7, 1, 1);
        this.drawSizedQuad(block, 9, 5, 1, 1);
    }

    private void pattern10(BlockReveal block) {
        this.drawSizedQuad(block, 5, 2, 1, 1);
        this.drawSizedQuad(block, 5, 4, 1, 1);
        this.drawSizedQuad(block, 6, 3, 3, 3);
        this.drawSizedQuad(block, 9, 4, 3, 2);
        this.drawSizedQuad(block, 7, 6, 4, 1);
        this.drawSizedQuad(block, 8, 7, 2, 1);
        this.drawSizedQuad(block, 10, 8, 1, 1);
    }

    private void pattern11(BlockReveal block) {
        this.drawSizedQuad(block, 11, 4, 1, 1);
        this.drawSizedQuad(block, 7, 5, 6, 2);
        this.drawSizedQuad(block, 8, 7, 4, 1);
        this.drawSizedQuad(block, 10, 8, 2, 1);
    }

    private void pattern12(BlockReveal block) {
        this.drawSizedQuad(block, 4, 5, 1, 1);
        this.drawSizedQuad(block, 5, 4, 1, 3);
        this.drawSizedQuad(block, 6, 4, 5, 4);
        this.drawSizedQuad(block, 8, 3, 2, 1);
        this.drawSizedQuad(block, 11, 4, 1, 2);
        this.drawSizedQuad(block, 7, 8, 3, 1);
        this.drawSizedQuad(block, 8, 9, 1, 1);
    }

    private void pattern13(BlockReveal block) {
        this.drawSizedQuad(block, 6, 8, 1, 2);
        this.drawSizedQuad(block, 7, 7, 1, 3);
        this.drawSizedQuad(block, 8, 6, 2, 3);
        this.drawSizedQuad(block, 10, 3, 1, 5);
        this.drawSizedQuad(block, 11, 5, 1, 3);
    }

    private void drawSizedQuad(BlockReveal block, int x, int z, int w, int h) {
        this.drawQuad(block, x, z, x + w, z + h);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawQuad(BlockReveal block, int x1, int z1, int x2, int z2) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        int side = 0;
        while (true) {
            block14: {
                if (side >= 6) {
                    return;
                }
                double yaw = 0.0;
                double pitch = 0.0;
                boolean inverse = false;
                switch (side) {
                    case 0: {
                        if (!(player.field_70163_u + (double)player.eyeHeight > (double)block.getPos().func_177956_o()) && block.drawDown) break;
                        break block14;
                    }
                    case 1: {
                        if (!(player.field_70163_u + (double)player.eyeHeight < (double)(block.getPos().func_177956_o() + 1)) && block.drawUp) {
                            pitch = Math.PI;
                            break;
                        }
                        break block14;
                    }
                    case 2: {
                        if (!(player.field_70161_v < (double)(block.getPos().func_177952_p() + 1)) && block.drawSouth) {
                            pitch = 1.5707963267948966;
                            break;
                        }
                        break block14;
                    }
                    case 3: {
                        if (!(player.field_70161_v > (double)block.getPos().func_177952_p()) && block.drawNorth) {
                            yaw = Math.PI;
                            pitch = -1.5707963267948966;
                            break;
                        }
                        break block14;
                    }
                    case 4: {
                        if (!(player.field_70165_t > (double)block.getPos().func_177958_n()) && block.drawWest) {
                            inverse = true;
                            yaw = 1.5707963267948966;
                            pitch = 1.5707963267948966;
                            break;
                        }
                        break block14;
                    }
                    case 5: {
                        if (player.field_70165_t < (double)(block.getPos().func_177958_n() + 1) || !block.drawEast) break block14;
                        inverse = true;
                        yaw = -1.5707963267948966;
                        pitch = 1.5707963267948966;
                    }
                }
                GL11.glBegin((int)7);
                this.rotatePointAndDraw((float)block.getPos().func_177958_n() + (float)x1 / 16.0f, block.getPos().func_177956_o(), (float)block.getPos().func_177952_p() + (float)z1 / 16.0f, (float)block.getPos().func_177958_n() + 0.5f, (float)block.getPos().func_177956_o() + 0.5f, (float)block.getPos().func_177952_p() + 0.5f, yaw, pitch, inverse);
                this.rotatePointAndDraw((float)block.getPos().func_177958_n() + (float)x2 / 16.0f, block.getPos().func_177956_o(), (float)block.getPos().func_177952_p() + (float)z1 / 16.0f, (float)block.getPos().func_177958_n() + 0.5f, (float)block.getPos().func_177956_o() + 0.5f, (float)block.getPos().func_177952_p() + 0.5f, yaw, pitch, inverse);
                this.rotatePointAndDraw((float)block.getPos().func_177958_n() + (float)x2 / 16.0f, block.getPos().func_177956_o(), (float)block.getPos().func_177952_p() + (float)z2 / 16.0f, (float)block.getPos().func_177958_n() + 0.5f, (float)block.getPos().func_177956_o() + 0.5f, (float)block.getPos().func_177952_p() + 0.5f, yaw, pitch, inverse);
                this.rotatePointAndDraw((float)block.getPos().func_177958_n() + (float)x1 / 16.0f, block.getPos().func_177956_o(), (float)block.getPos().func_177952_p() + (float)z2 / 16.0f, (float)block.getPos().func_177958_n() + 0.5f, (float)block.getPos().func_177956_o() + 0.5f, (float)block.getPos().func_177952_p() + 0.5f, yaw, pitch, inverse);
                GL11.glEnd();
            }
            ++side;
        }
    }

    private void preRender() {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        EntityPlayerSP viewpoint = mc.func_175606_aa() == null ? mc.field_71439_g : mc.func_175606_aa();
        float tx = (float)(viewpoint.field_70169_q + (viewpoint.field_70165_t - viewpoint.field_70169_q) * (double)mc.func_184121_ak());
        float ty = (float)(viewpoint.field_70167_r + (viewpoint.field_70163_u - viewpoint.field_70167_r) * (double)mc.func_184121_ak());
        float tz = (float)(viewpoint.field_70166_s + (viewpoint.field_70161_v - viewpoint.field_70166_s) * (double)mc.func_184121_ak());
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179129_p();
        GlStateManager.func_179109_b((float)(-tx), (float)(-ty), (float)(-tz));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glHint((int)3155, (int)4354);
    }

    private void postRender() {
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private double[] rotatePoint(double px, double py, double pz, double cx, double cy, double cz, double yaw, double pitch, boolean inverse) {
        if (inverse) {
            double ry = Math.sin(pitch) * (pz - cz) + Math.cos(pitch) * (py - cy) + cy;
            double rz = Math.cos(pitch) * (pz - cz) - Math.sin(pitch) * (py - cy) + cz;
            double rx = Math.cos(yaw) * (px - cx) - Math.sin(yaw) * (rz - cz) + cx;
            rz = Math.sin(yaw) * (px - cx) + Math.cos(yaw) * (rz - cz) + cz;
            return new double[]{rx, ry, rz};
        }
        double rx = Math.cos(yaw) * (px - cx) - Math.sin(yaw) * (pz - cz) + cx;
        double rz = Math.sin(yaw) * (px - cx) + Math.cos(yaw) * (pz - cz) + cz;
        double ry = Math.sin(pitch) * (rz - cz) + Math.cos(pitch) * (py - cy) + cy;
        rz = Math.cos(pitch) * (rz - cz) - Math.sin(pitch) * (py - cy) + cz;
        return new double[]{rx, ry, rz};
    }

    private void rotatePointAndDraw(double px, double py, double pz, double cx, double cy, double cz, double yaw, double pitch, boolean inverse) {
        double[] points = this.rotatePoint(px, py, pz, cx, cy, cz, yaw, pitch, inverse);
        GL11.glVertex3d((double)points[0], (double)points[1], (double)points[2]);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        revealedBlocks.removeIf(block -> block.getPos().equals((Object)event.getPos()));
    }
}

