/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityTradeMachine;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.BlockModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.SharedModels;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class RenderTileEntityTradingMachine
extends TileEntityRenderer<TileEntityTradeMachine> {
    private static final ResourceLocation bracket = new ResourceLocation("pixelmon", "textures/blocks/trademachine/Bracket.png");
    private static final ResourceLocation placeholder = new ResourceLocation("pixelmon", "textures/blocks/placeholder.png");
    private static final BlockModelHolder<GenericSmdModel> model = new BlockModelHolder("blocks/trade_machine/trader.pqc");
    private static final BlockModelHolder<GenericSmdModel> arrows = new BlockModelHolder("blocks/trade_machine/arrows.pqc");
    private static final BlockModelHolder<GenericSmdModel> poke1Poke = new BlockModelHolder("blocks/trade_machine/poke1poke.pqc");
    private static final BlockModelHolder<GenericSmdModel> poke1Bracket = new BlockModelHolder("blocks/trade_machine/poke1bracket.pqc");
    private static final BlockModelHolder<GenericSmdModel> poke1Player = new BlockModelHolder("blocks/trade_machine/poke1player.pqc");
    private static final BlockModelHolder<GenericSmdModel> poke1HeldItem = new BlockModelHolder("blocks/trade_machine/poke1helditem.pqc");
    private static final BlockModelHolder<GenericSmdModel> poke1Ready = new BlockModelHolder("blocks/trade_machine/poke1ready.pqc");
    private static final BlockModelHolder<GenericSmdModel> poke2Poke = new BlockModelHolder("blocks/trade_machine/poke2poke.pqc");
    private static final BlockModelHolder<GenericSmdModel> poke2Bracket = new BlockModelHolder("blocks/trade_machine/poke2bracket.pqc");
    private static final BlockModelHolder<GenericSmdModel> poke2Player = new BlockModelHolder("blocks/trade_machine/poke2player.pqc");
    private static final BlockModelHolder<GenericSmdModel> poke2HeldItem = new BlockModelHolder("blocks/trade_machine/poke2helditem.pqc");
    private static final BlockModelHolder<GenericSmdModel> poke2Ready = new BlockModelHolder("blocks/trade_machine/poke2ready.pqc");

    public RenderTileEntityTradingMachine() {
        this.correctionAngles = 180;
    }

    @Override
    public void renderTileEntity(TileEntityTradeMachine tradeMachine, IBlockState state, double x, double y, double z, float partialTicks, int destroyStage) {
        this.func_147499_a(tradeMachine.getTexture());
        model.render();
        this.func_147499_a(bracket);
        arrows.render();
        poke1Bracket.render();
        poke2Bracket.render();
        SkinManager skinManager = Minecraft.func_71410_x().func_152342_ad();
        if (tradeMachine.user1 != null && !tradeMachine.user1.isEmpty() || tradeMachine.user2 != null && !tradeMachine.user2.isEmpty()) {
            String[] users = new String[]{tradeMachine.user1, tradeMachine.user2};
            for (int i = 0; i < 2; ++i) {
                if (users[i] != null && !users[i].isEmpty()) {
                    String username = users[i];
                    EntityPlayer player = this.func_178459_a().func_72924_a(username);
                    if (player != null) {
                        ResourceLocation resourcelocation;
                        Map map = skinManager.func_152788_a(player.func_146103_bH());
                        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                            resourcelocation = skinManager.func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                        } else {
                            UUID uuid = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
                            resourcelocation = DefaultPlayerSkin.func_177334_a((UUID)uuid);
                        }
                        this.func_147499_a(resourcelocation);
                    } else {
                        this.func_147499_a(placeholder);
                    }
                    (i == 0 ? poke1Player : poke2Player).render();
                } else {
                    this.func_147499_a(placeholder);
                }
                (i == 0 ? poke1Player : poke2Player).render();
            }
            NBTTagCompound[] pokemon = new NBTTagCompound[]{tradeMachine.poke1, tradeMachine.poke2};
            for (int i = 0; i < 2; ++i) {
                if (pokemon[i] == null) continue;
                String name = pokemon[i].func_74779_i("Name");
                boolean isEgg = pokemon[i].func_74767_n("isEgg");
                int eggCycles = pokemon[i].func_74762_e("eggCycles");
                int variant = pokemon[i].func_74762_e("Variant");
                boolean isShiny = pokemon[i].func_74767_n("IsShiny");
                int pokeball = pokemon[i].func_74762_e("CaughtBall");
                int number = Pokedex.nameToID(name);
                EnumPokeballs pokeballs = EnumPokeballs.getFromIndex(pokeball);
                this.func_147499_a(pokeballs.getTextureLocation());
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                int rotation = this.getRotation(state);
                if (i == 0) {
                    if (rotation == 270) {
                        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.93), (double)(z + 0.4));
                    } else if (rotation == 180) {
                        GlStateManager.func_179137_b((double)(x + 0.6), (double)(y + 0.93), (double)(z + 0.5));
                    } else if (rotation == 90) {
                        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.93), (double)(z + 0.6));
                    } else {
                        GlStateManager.func_179137_b((double)(x + 0.4), (double)(y + 0.93), (double)(z + 0.5));
                    }
                } else if (rotation == 270) {
                    GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.93), (double)(z + 2.2 + 0.4));
                } else if (rotation == 180) {
                    GlStateManager.func_179137_b((double)(x - 2.2 + 0.6), (double)(y + 0.93), (double)(z + 0.5));
                } else if (rotation == 90) {
                    GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.93), (double)(z - 2.2 + 0.6));
                } else {
                    GlStateManager.func_179137_b((double)(x + 2.2 + 0.4), (double)(y + 0.93), (double)(z + 0.5));
                }
                GlStateManager.func_179114_b((float)this.getRotation(state), (float)0.0f, (float)1.0f, (float)0.0f);
                BlockModelHolder<? extends ModelPokeballs> model = SharedModels.getPokeballModel(pokeballs);
                ((ModelPokeballs)((Object)model.getModel())).theModel.setAnimation(AnimationType.IDLE);
                ((ModelPokeballs)((Object)model.getModel())).theModel.animate();
                model.render(0.0022f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + this.yOffset), (float)((float)z + 0.5f));
                GlStateManager.func_179114_b((float)(this.getRotation(state) + this.correctionAngles), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                if (pokemon[i].func_74764_b("HeldItemStack")) {
                    ItemStack heldItem = new ItemStack(pokemon[i].func_74775_l("HeldItemStack"));
                    if (heldItem.func_190926_b()) {
                        this.func_147499_a(placeholder);
                        (i == 0 ? poke1HeldItem : poke2HeldItem).render();
                    } else {
                        this.func_147499_a(new ResourceLocation("pixelmon", "textures/helditem.png"));
                        (i == 0 ? poke1HeldItem : poke2HeldItem).render();
                    }
                } else {
                    this.func_147499_a(placeholder);
                    (i == 0 ? poke1HeldItem : poke2HeldItem).render();
                }
                this.func_147499_a(new ResourceLocation("pixelmon", this.getSpriteFromID(number, name, isShiny, isEgg, eggCycles, variant)));
                (i == 0 ? poke1Poke : poke2Poke).render();
            }
            if (tradeMachine.ready1) {
                this.func_147499_a(new ResourceLocation("pixelmon", "textures/blocks/trademachine/Ready.png"));
                poke1Ready.render();
            } else {
                this.func_147499_a(placeholder);
                poke1Ready.render();
            }
            if (tradeMachine.ready2) {
                this.func_147499_a(new ResourceLocation("pixelmon", "textures/blocks/trademachine/Ready.png"));
                poke2Ready.render();
            } else {
                this.func_147499_a(placeholder);
                poke2Ready.render();
            }
        }
    }

    private String getSpriteFromID(int nationalPokedexNumber, String pokemonName, boolean isShiny, boolean isEgg, int eggCycles, int variant) {
        String basePath = "textures/sprites/pokemon/";
        if (isShiny) {
            basePath = "textures/sprites/shinypokemon/";
        } else if (isEgg) {
            basePath = "textures/sprites/eggs/";
        }
        if (isEgg) {
            String eggType = "egg";
            if (nationalPokedexNumber == 175) {
                eggType = "togepi";
            } else if (nationalPokedexNumber == 490) {
                eggType = "manaphy";
            }
            if (eggCycles > 10) {
                return basePath + eggType + "1.png";
            }
            if (eggCycles > 5) {
                return basePath + eggType + "2.png";
            }
            return basePath + eggType + "3.png";
        }
        Optional<EnumSpecies> optional = EnumSpecies.getFromName(pokemonName);
        if (optional.isPresent()) {
            EnumSpecies pokemon = optional.get();
            return basePath + pokemon.getNationalPokedexNumber() + pokemon.getFormEnum(variant).getSpriteSuffix(isShiny) + ".png";
        }
        return basePath + String.format("%03d", nationalPokedexNumber) + ".png";
    }
}

