/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ISyncHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LevelUp
implements IMessage {
    public UUID pokemonUUID;
    public int level;
    public PixelmonStatsData statsLevel1;
    public PixelmonStatsData statsLevel2;

    public LevelUp() {
    }

    public LevelUp(UUID pokemonUUID, int level, PixelmonStatsData statsLevel1, PixelmonStatsData statsLevel2) {
        this.pokemonUUID = pokemonUUID;
        this.level = level;
        this.statsLevel1 = statsLevel1;
        this.statsLevel2 = statsLevel2;
    }

    public LevelUp(NBTTagCompound p, int level, PixelmonStatsData statsLevel1, PixelmonStatsData statsLevel2) {
        this.pokemonUUID = p.func_186857_a("UUID");
        this.level = level;
        this.statsLevel1 = statsLevel1;
        this.statsLevel2 = statsLevel2;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.level = buffer.readInt();
        this.statsLevel1 = new PixelmonStatsData();
        this.statsLevel1.readPacketData(buffer);
        this.statsLevel2 = new PixelmonStatsData();
        this.statsLevel2.readPacketData(buffer);
    }

    public void toBytes(ByteBuf buffer) {
        PixelmonMethods.toBytesUUID(buffer, this.pokemonUUID);
        buffer.writeInt(this.level);
        this.statsLevel1.writePacketData(buffer);
        this.statsLevel2.writePacketData(buffer);
    }

    public static class Handler
    implements ISyncHandler<LevelUp> {
        @Override
        public void onSyncMessage(LevelUp message, MessageContext ctx) {
            ClientProxy.battleManager.levelUpList.add(message);
            this.onClient(message);
        }

        @SideOnly(value=Side.CLIENT)
        private void onClient(LevelUp message) {
            if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiBattle)) {
                if (ClientProxy.battleManager.getPokemon(message.pokemonUUID) == null) {
                    Pokemon pokemon = ClientStorageManager.party.find(message.pokemonUUID);
                    if (ClientProxy.battleManager.fullOurPokemon == null) {
                        ClientProxy.battleManager.fullOurPokemon = Lists.newArrayList();
                    }
                    ClientProxy.battleManager.fullOurPokemon.add(new PixelmonInGui(pokemon));
                }
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiBattle());
            }
        }
    }
}

