/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ISyncHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.WrapperLink;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.listener.RotomListener;
import com.pixelmonmod.pixelmon.util.MoveCostList;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ReplaceMove
implements IMessage {
    private UUID pokemonUUID;
    private int attackId;
    private int replaceIndex;
    private boolean checkEvo;

    public ReplaceMove() {
    }

    public ReplaceMove(UUID pokemonUUID, int attackId, int replaceIndex, boolean checkEvo) {
        this.pokemonUUID = pokemonUUID;
        this.attackId = attackId;
        this.replaceIndex = replaceIndex;
        this.checkEvo = checkEvo;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.attackId = buffer.readInt();
        this.replaceIndex = buffer.readInt();
        this.checkEvo = buffer.readBoolean();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeLong(this.pokemonUUID.getMostSignificantBits());
        buffer.writeLong(this.pokemonUUID.getLeastSignificantBits());
        buffer.writeInt(this.attackId);
        buffer.writeInt(this.replaceIndex);
        buffer.writeBoolean(this.checkEvo);
    }

    public static class Handler
    implements ISyncHandler<ReplaceMove> {
        @Override
        public void onSyncMessage(ReplaceMove message, MessageContext ctx) {
            PlayerParticipant participant;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (!MoveCostList.checkEntry(player)) {
                ChatHandler.sendFormattedChat((ICommandSender)player, TextFormatting.RED, "pixelmon.npc.cantpay", new Object[0]);
                return;
            }
            Attack a = new Attack(message.attackId);
            PokemonLink pokemonLink = null;
            BattleControllerBase bc = BattleRegistry.getBattle((EntityPlayer)player);
            PixelmonWrapper pw = null;
            if (bc != null && (participant = bc.getPlayer((EntityPlayer)player)) != null && (pw = participant.getPokemonFromParty(message.pokemonUUID)) != null) {
                pokemonLink = new WrapperLink(pw);
            }
            if (pokemonLink == null) {
                pokemonLink = new DelegateLink(Pixelmon.storageManager.getParty(player).find(message.pokemonUUID));
            }
            if (message.replaceIndex > -1) {
                Moveset moveset = pokemonLink.getMoveset();
                TextComponentTranslation chatMessage = ChatHandler.getMessage("replacemove.replace", pokemonLink.getRealNickname(), moveset.get(message.replaceIndex).getMove().getTranslatedName(), a.getMove().getTranslatedName());
                moveset.set(message.replaceIndex, a);
                if (bc == null || bc.battleEnded) {
                    ChatHandler.sendChat((ICommandSender)player, chatMessage);
                } else {
                    bc.sendToPlayer((EntityPlayer)player, chatMessage);
                }
                if (pw != null && bc.battleEnded) {
                    pw.writeToNBT();
                }
                pokemonLink.update(EnumUpdateType.Moveset);
                if (pokemonLink.getSpecies() == EnumSpecies.Rotom) {
                    RotomListener.replacedMove(pokemonLink, a);
                }
            }
            if (message.checkEvo) {
                if (pw != null) {
                    pw.bc.checkedPokemon.add(pw.pokemon);
                } else {
                    pokemonLink.getPokemon().tryEvolution();
                }
            }
        }
    }
}

