/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ISyncHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class UpdateMoveset
implements IMessage {
    UUID uuid;
    Moveset moveset;

    public UpdateMoveset() {
    }

    public UpdateMoveset(PixelmonWrapper wrapper) {
        this.uuid = wrapper.getPokemonUUID();
        this.moveset = wrapper.getMoveset();
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.moveset = new Moveset();
        this.moveset.fromBytes(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.uuid.getMostSignificantBits()).writeLong(this.uuid.getLeastSignificantBits());
        this.moveset.toBytes(buf);
    }

    public static class Handler
    implements ISyncHandler<UpdateMoveset> {
        @Override
        public void onSyncMessage(UpdateMoveset message, MessageContext ctx) {
            for (PixelmonInGui pig : ClientProxy.battleManager.fullOurPokemon) {
                if (!pig.pokemonUUID.equals(message.uuid)) continue;
                pig.moveset = message.moveset;
            }
            for (PixelmonInGui pig : ClientProxy.battleManager.displayedOurPokemon) {
                if (!pig.pokemonUUID.equals(message.uuid)) continue;
                pig.moveset = message.moveset;
            }
        }
    }
}

