/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles.gui;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.attacks.BattleMessageBase;
import com.pixelmonmod.pixelmon.battles.attacks.MessageType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.client.gui.battles.timerTasks.SwitchTask;
import io.netty.buffer.ByteBuf;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SwitchOutPacket
extends BattleMessageBase
implements IMessage {
    PixelmonInGui newPokemonGUI;

    public SwitchOutPacket() {
    }

    public SwitchOutPacket(UUID pix1UUID, PixelmonWrapper newPokemon) {
        this.pokemonUUID = pix1UUID;
        this.newPokemonGUI = new PixelmonInGui(newPokemon);
    }

    public SwitchOutPacket(UUID pix1UUID) {
        this.pokemonUUID = pix1UUID;
        this.newPokemonGUI = null;
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.pokemonUUID = new UUID(buf.readLong(), buf.readLong());
        }
        if (buf.readBoolean()) {
            this.newPokemonGUI = new PixelmonInGui();
            this.newPokemonGUI.decodeInto(buf);
        }
        this.messageType = MessageType.SWITCHOUT;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.pokemonUUID != null);
        if (this.pokemonUUID != null) {
            PixelmonMethods.toBytesUUID(buf, this.pokemonUUID);
        }
        buf.writeBoolean(this.newPokemonGUI != null);
        if (this.newPokemonGUI != null) {
            this.newPokemonGUI.encodeInto(buf);
        }
    }

    @Override
    public void process() {
        new Timer().scheduleAtFixedRate((TimerTask)new SwitchTask(this, this.pokemonUUID, this.newPokemonGUI), 0L, 5L);
    }

    public static class Handler
    implements IMessageHandler<SwitchOutPacket, IMessage> {
        public IMessage onMessage(SwitchOutPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> ClientProxy.battleManager.addBattleMessage(message));
            return null;
        }
    }
}

