/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityRanchBlock;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityBreeding;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class RanchUnlockCommand
extends PixelmonCommand {
    public RanchUnlockCommand() {
        super("unlock", "/unlock <player>", 2);
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.execute(sender, new String[]{sender.func_70005_c_()});
        } else if (args.length == 1) {
            this.resendWithMultipleTargets(sender, args, 0);
            EntityPlayerMP player = RanchUnlockCommand.requireEntityPlayer(args[0]);
            for (EntityBreeding pixelmon : player.field_70170_p.func_175644_a(EntityBreeding.class, input -> input.func_152114_e((EntityLivingBase)player))) {
                if (!(pixelmon.blockOwner instanceof TileEntityRanchBlock)) continue;
                TileEntityRanchBlock te = (TileEntityRanchBlock)pixelmon.blockOwner;
                te.removePokemon(player, pixelmon);
            }
            PlayerPartyStorage storage = RanchUnlockCommand.getPlayerStorage(player);
            if (storage != null) {
                boolean flag = false;
                for (Pokemon pokemon : storage.getTeam()) {
                    if (!pokemon.isInRanch()) continue;
                    pokemon.setInRanch(false);
                    flag = true;
                }
            }
            PCStorage computerStorage = RanchUnlockCommand.getComputerStorage(player);
            for (Pokemon pokemon : computerStorage.findAll(Pokemon::isInRanch)) {
                pokemon.setInRanch(false);
            }
            RanchUnlockCommand.func_152374_a((ICommandSender)sender, (ICommand)this, (int)0, (String)"pixelmon.command.unlock", (Object[])new Object[]{player.func_70005_c_()});
        } else {
            sender.func_145747_a(RanchUnlockCommand.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]));
            RanchUnlockCommand.endCommand(this.func_71518_a(sender), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return RanchUnlockCommand.tabCompleteUsernames(args);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }
}

