/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChooseMoveset;
import com.pixelmonmod.pixelmon.comm.packetHandlers.chooseMoveset.ChoosingMovesetData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextFormatting;

public class SetPartyCommand
extends PixelmonCommand {
    public SetPartyCommand() {
        super("setparty", "/setparty <lvl>", 2);
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1 || args.length == 2) {
            int level = SetPartyCommand.requireInt(args[0], 1, PixelmonConfig.maxLevel, "commands.generic.num.invalid", new Object[0]);
            EntityPlayerMP player = SetPartyCommand.requireEntityPlayer(sender);
            if (BattleRegistry.getBattle((EntityPlayer)player) != null) {
                SetPartyCommand.endCommand("pixelmon.command.general.inbattle", new Object[0]);
            }
            PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
            List<Pokemon> team = party.getTeam();
            team.forEach(p -> p.setLevel(level));
            if (args.length == 2 && args[1].equals("moves")) {
                ChoosingMovesetData data = new ChoosingMovesetData(player, team);
                data.next();
                if (!data.pokemonList.isEmpty()) {
                    ChooseMoveset.choosingMoveset.add(data);
                }
            }
        } else {
            sender.func_145747_a(SetPartyCommand.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]));
            SetPartyCommand.endCommand(this.func_71518_a(sender), new Object[0]);
        }
    }
}

