/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands.quests;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class SetStageCommand
extends PixelmonCommand {
    static final String OTHER_NODE = "pixelmon.command.admin.setstage.other";

    public SetStageCommand() {
        super("setstage", "/setstage <quest> <stage> [player]", 2);
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 2) {
            this.execute(sender, new String[]{args[0], args[1], sender.func_70005_c_()});
        } else if (args.length == 3) {
            this.resendWithMultipleTargets(sender, args, 2);
            EntityPlayerMP player = SetStageCommand.requireEntityPlayer(args[2]);
            short stage = (short)SetStageCommand.requireInt(args[1], Short.MIN_VALUE, Short.MAX_VALUE, "commands.generic.num.invalid", new Object[0]);
            if (sender != player && !sender.func_70003_b(this.func_82362_a(), OTHER_NODE)) {
                SetStageCommand.endCommand("pixelmon.command.setstage.permissionother", new Object[0]);
            }
            PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
            QuestData data = party.getQuestData();
            QuestProgress progress = SetStageCommand.require(data.getProgressForQuest(args[0], true), "pixelmon.command.invalidquest", new Object[0]);
            if (stage == -1) {
                progress.complete(player);
            } else {
                if (!progress.setStage(stage)) {
                    this.sendMessage(sender, "pixelmon.command.setstage.invalidstage", args[1], args[0].replace("_", " "));
                    return;
                }
                progress.reopen();
            }
            progress.sendTo(player);
            SetStageCommand.func_152374_a((ICommandSender)sender, (ICommand)this, (int)0, (String)"pixelmon.command.setstage.notify", (Object[])new Object[]{sender.func_70005_c_(), player.getDisplayNameString(), args[0].replace("_", " "), args[1]});
            this.sendMessage(sender, "pixelmon.command.setstage.set", player.getDisplayNameString(), args[0].replace("_", " "), args[1]);
        } else {
            this.sendMessage(sender, "pixelmon.command.setstage.invalidargs", new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        switch (args.length) {
            case 1: {
                return SetStageCommand.tabComplete(args, QuestRegistry.getInstance().getQuestFilepaths(true));
            }
            case 3: {
                return SetStageCommand.tabCompleteUsernames(args);
            }
        }
        return SetStageCommand.tabComplete(args, new String[0]);
    }
}

