/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.config.EnumEntityListClassType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.EntityChairMount;
import com.pixelmonmod.pixelmon.entities.EntityWormhole;
import com.pixelmonmod.pixelmon.entities.bikes.EntityBike;
import com.pixelmonmod.pixelmon.entities.custom.EntityPixelmonPainting;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCFisherman;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCQuestGiver;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityBreeding;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityEmptyPokeball;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityOccupiedPokeball;
import com.pixelmonmod.pixelmon.entities.projectiles.EntityHook;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.fixes.EntityId;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class PixelmonEntityList {
    static void registerEntities() {
        int entityID = 0;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_trainer"), NPCTrainer.class, (String)"Trainer", (int)entityID++, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_trader"), NPCTrader.class, (String)"Trader", (int)n, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n2 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "pixelmon"), EntityPixelmon.class, (String)"Pixelmon", (int)n2, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n3 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "statue"), EntityStatue.class, (String)"Statue", (int)n3, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n4 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_chatting"), NPCChatting.class, (String)"ChattingNPC", (int)n4, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n5 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_questgiver"), NPCQuestGiver.class, (String)"QuestGiverNPC", (int)n5, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n6 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_relearner"), NPCRelearner.class, (String)"Relearner", (int)n6, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n7 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_tutor"), NPCTutor.class, (String)"Tutor", (int)n7, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n8 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "empty_pokeball"), EntityEmptyPokeball.class, (String)"Pokeball", (int)n8, (Object)Pixelmon.instance, (int)80, (int)1, (boolean)true);
        int n9 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "hook"), EntityHook.class, (String)"Hook", (int)n9, (Object)Pixelmon.instance, (int)75, (int)1, (boolean)true);
        int n10 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "chair_mount"), EntityChairMount.class, (String)"EntityChairMount", (int)n10, (Object)Pixelmon.instance, (int)80, (int)1, (boolean)true);
        int n11 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_nursejoy"), NPCNurseJoy.class, (String)"NurseJoy", (int)n11, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n12 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_shopkeeper"), NPCShopkeeper.class, (String)"Shopkeeper", (int)n12, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n13 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "painting"), EntityPixelmonPainting.class, (String)"PixelmonPainting", (int)n13, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n14 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "occupied_pokeball"), EntityOccupiedPokeball.class, (String)"OccupiedPokeball", (int)n14, (Object)Pixelmon.instance, (int)80, (int)1, (boolean)true);
        int n15 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "ultra_wormhole"), EntityWormhole.class, (String)"Wormhole", (int)n15, (Object)Pixelmon.instance, (int)128, (int)1, (boolean)false);
        int n16 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "breeding"), EntityBreeding.class, (String)"Breeding", (int)n16, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n17 = ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "bike"), EntityBike.class, (String)"Bike", (int)n17, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        int n18 = ++entityID;
        ++entityID;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pixelmon", "npc_oldfisherman"), NPCFisherman.class, (String)"OldFisherman", (int)n18, (Object)Pixelmon.instance, (int)100, (int)1, (boolean)true);
        PixelmonEntityList.remap();
    }

    public static EntityLiving createEntityByName(String entityName, World world) {
        return PixelmonEntityList.createEntityByName(entityName, world, null);
    }

    public static EntityLiving createEntityByName(String entityName, World world, String biomeID) {
        Object entity = null;
        try {
            EnumEntityListClassType type = null;
            if (EnumSpecies.hasPokemonAnyCase(entityName)) {
                type = EnumEntityListClassType.Pixelmon;
                entityName = EnumSpecies.getFromNameAnyCase((String)entityName).name;
            }
            if (type == EnumEntityListClassType.Pixelmon) {
                entity = new PokemonSpec(entityName).create(world);
            } else if (ServerNPCRegistry.trainers.has(entityName)) {
                BaseTrainer trainer = ServerNPCRegistry.trainers.get(entityName);
                entity = new NPCTrainer(world);
                ((NPCTrainer)((Object)entity)).init(trainer);
            } else {
                try {
                    EnumNPCType npcType = EnumNPCType.valueOf(entityName);
                    if (npcType == EnumNPCType.Trader) {
                        entity = new NPCTrader(world);
                    } else if (npcType == EnumNPCType.Tutor) {
                        entity = new NPCTutor(world);
                    } else if (npcType == EnumNPCType.Shopkeeper) {
                        entity = new NPCShopkeeper(world);
                        ((NPCShopkeeper)((Object)entity)).initWanderingAI();
                        ((NPCShopkeeper)((Object)entity)).initRandom(biomeID);
                    } else {
                        entity = npcType == EnumNPCType.Relearner ? new NPCRelearner(world) : (npcType == EnumNPCType.OldFisherman ? new NPCFisherman(world) : new NPCTrainer(world));
                    }
                    ((EntityNPC)((Object)entity)).init(entityName);
                }
                catch (IllegalArgumentException e) {
                    entity = new NPCTrainer(world);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entity;
    }

    @Deprecated
    public static Entity createEntityFromNBT(NBTTagCompound compound, World world) {
        EntityPixelmon pixelmon = null;
        try {
            pixelmon = new EntityPixelmon(world);
            pixelmon.setPokemon(Pixelmon.pokemonFactory.create(compound));
            pixelmon.getPokemonData().updateDimensionAndEntityID(world.field_73011_w.getDimension(), pixelmon.func_145782_y());
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        if (pixelmon != null) {
            pixelmon.func_70020_e(compound);
        } else if (PixelmonConfig.printErrors) {
            System.out.println("Skipping Entity with id " + compound.func_74779_i("id"));
        }
        return pixelmon;
    }

    private static void remap() {
        Map remap = (Map)ObfuscationReflectionHelper.getPrivateValue(EntityId.class, null, (int)0);
        remap.put("pixelmon.Trainer", "pixelmon:npc_trainer");
        remap.put("pixelmon.Hallwoeen", "pixelmon:halloween");
        remap.put("pixelmon.Trader", "pixelmon:npc_trader");
        remap.put("pixelmon.Pixelmon", "pixelmon:pixelmon");
        remap.put("pixelmon.Statue", "pixelmon:statue");
        remap.put("pixelmon.ChattingNPC", "pixelmon:npc_chatting");
        remap.put("pixelmon.Relearner", "pixelmon:npc_relearner");
        remap.put("pixelmon.Tutor", "pixelmon:npc_tutor");
        remap.put("pixelmon.Pokeball", "pixelmon:empty_pokeball");
        remap.put("pixelmon.Hook", "pixelmon:hook");
        remap.put("pixelmon.EntityChairMount", "pixelmon:chair_mount");
        remap.put("pixelmon.NurseJoy", "pixelmon:npc_nursejoy");
        remap.put("pixelmon.Shopkeeper", "pixelmon:npc_shopkeeper");
        remap.put("pixelmon.PixelmonPainting", "pixelmon:painting");
        remap.put("pixelmon.OccupiedPokeball", "pixelmon:occupied_pokeball");
        remap.put("pixelmon.OldFisherman", "pixelmon:oldfisherman");
    }
}

