/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.InteractNPC;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.LoadTutorData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.items.ItemNPCEditor;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class NPCTutor
extends EntityNPC {
    public static ArrayList<AttackBase> allTutorMoves = new ArrayList();
    public ArrayList<Attack> attackList;
    public ArrayList<ArrayList<ItemStack>> costs;

    public NPCTutor(World world) {
        super(world);
        this.init("Tutor");
    }

    @Override
    public void init(String name) {
        if (name.equals("Tutor")) {
            BaseTrainer trainer = ServerNPCRegistry.trainers.getRandomBase();
            name = trainer.name;
            this.setBaseTrainer(trainer);
            if (trainer.textures.size() > 1) {
                this.field_70180_af.func_187227_b(dwTextureIndex, (Object)this.field_70170_p.field_73012_v.nextInt(trainer.textures.size()));
            }
        }
        super.init(name);
        this.npcLocation = SpawnLocationType.LandNPC;
        if (this.attackList == null || this.costs == null) {
            int i;
            this.attackList = new ArrayList();
            for (i = 0; i < PixelmonConfig.movesPerTutor; ++i) {
                Attack randomAttack;
                while (this.attackList.contains(randomAttack = this.getRandomAttack())) {
                }
                this.attackList.add(randomAttack);
            }
            this.costs = new ArrayList();
            for (i = 0; i < this.attackList.size(); ++i) {
                ArrayList<ItemStack> initialCost = new ArrayList<ItemStack>();
                initialCost.add(this.getRandomCost());
                this.costs.add(initialCost);
            }
        }
        if (this.getAIMode() != EnumTrainerAI.StandStill) {
            this.setAIMode(EnumTrainerAI.Wander);
        }
        this.initAI();
    }

    @Override
    public String getDisplayText() {
        return I18n.func_74838_a((String)"pixelmon.npc.tutorname");
    }

    public void func_70024_g(double par1, double par3, double par5) {
        if (this.func_70104_M()) {
            super.func_70024_g(par1, par3, par5);
        }
    }

    @Override
    public boolean func_70104_M() {
        return this.getAIMode() != EnumTrainerAI.StandStill;
    }

    @Override
    protected boolean func_70692_ba() {
        return this.getAIMode() == EnumTrainerAI.Wander;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.attackList == null) {
            nbt.func_74768_a("numAttacks", 0);
            return;
        }
        nbt.func_74768_a("numAttacks", this.attackList.size());
        for (int i = 0; i < this.attackList.size(); ++i) {
            nbt.func_74778_a("attack" + i, this.attackList.get(i).getMove().getAttackName());
            nbt.func_74768_a("attack" + i + "costNum", this.costs.get(i).size());
            for (int j = 0; j < this.costs.get(i).size(); ++j) {
                ItemStack current = this.costs.get(i).get(j);
                nbt.func_74768_a("attack" + i + "cost" + j, Item.func_150891_b((Item)current.func_77973_b()));
                nbt.func_74768_a("attack" + i + "cost" + j + "Num", current.func_190916_E());
                nbt.func_74768_a("attack" + i + "cost" + j + "Damage", current.func_77952_i());
            }
        }
    }

    @Override
    public void initAI() {
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        switch (this.getAIMode()) {
            case StandStill: {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPixelmon.class, 6.0f));
                break;
            }
            case Wander: {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, SharedMonsterAttributes.field_111263_d.func_111110_b()));
                break;
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        int numAttacks = nbt.func_74762_e("numAttacks");
        if (numAttacks > 0) {
            this.attackList.clear();
            this.costs.clear();
        }
        for (int i = 0; i < numAttacks; ++i) {
            Attack attack = new Attack(nbt.func_74779_i("attack" + i));
            if (attack.getMove() == null) continue;
            this.attackList.add(attack);
            int numCosts = nbt.func_74762_e("attack" + i + "costNum");
            ArrayList<ItemStack> cost = new ArrayList<ItemStack>(numCosts);
            for (int j = 0; j < numCosts; ++j) {
                ItemStack current = new ItemStack(Item.func_150899_d((int)nbt.func_74762_e("attack" + i + "cost" + j)), nbt.func_74762_e("attack" + i + "cost" + j + "Num"));
                current.func_77964_b(nbt.func_74762_e("attack" + i + "cost" + j + "Damage"));
                cost.add(current);
            }
            this.costs.add(cost);
        }
    }

    @Override
    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player instanceof EntityPlayerMP && hand == EnumHand.MAIN_HAND) {
            if (this.attackList == null) {
                this.init("");
            }
            ItemStack itemStack = player.func_184586_b(hand);
            Pixelmon.network.sendTo((IMessage)new LoadTutorData(this), (EntityPlayerMP)player);
            if (player.field_71075_bZ.field_75098_d && itemStack != null && itemStack.func_77973_b() instanceof ItemNPCEditor) {
                this.setAIMode(EnumTrainerAI.StandStill);
                this.initAI();
                OpenScreen.open(player, EnumGuiScreen.TutorEditor, this.getId());
            } else {
                Pixelmon.network.sendTo((IMessage)new InteractNPC(this.getId(), EnumNPCType.Tutor), (EntityPlayerMP)player);
                OpenScreen.open(player, EnumGuiScreen.ChooseTutor, new int[0]);
            }
        } else {
            this.field_70714_bg.field_75782_a.clear();
        }
        return super.func_184645_a(player, hand);
    }

    private Attack getRandomAttack() {
        return new Attack(CollectionHelper.getRandomElement(allTutorMoves));
    }

    private ItemStack getRandomCost() {
        Item[] randomItems = new Item[]{Items.field_151042_j, Items.field_151043_k, Items.field_151045_i, Items.field_151166_bC, PixelmonItems.aluminiumIngot, PixelmonItems.amethyst, PixelmonItems.ruby, PixelmonItems.crystal, PixelmonItems.sapphire, PixelmonItems.siliconItem};
        int randomItem = RandomHelper.getRandomNumberBetween(0, randomItems.length - 1);
        return new ItemStack(randomItems[randomItem], RandomHelper.getRandomNumberBetween(1, 16), 0);
    }

    public static void encode(ByteBuf buf, ArrayList<Attack> attackList, ArrayList<ArrayList<ItemStack>> costs) {
        if (attackList != null) {
            buf.writeInt(attackList.size());
            for (int i = 0; i < attackList.size(); ++i) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)attackList.get(i).getMove().getAttackName());
                buf.writeInt(costs.get(i).size());
                for (int j = 0; j < costs.get(i).size(); ++j) {
                    ItemStack current = costs.get(i).get(j);
                    buf.writeInt(Item.func_150891_b((Item)current.func_77973_b()));
                    buf.writeInt(current.func_190916_E());
                    buf.writeInt(current.func_77952_i());
                }
            }
        } else {
            buf.writeInt(0);
        }
    }

    public static void decode(ByteBuf buf, ArrayList<Attack> attackList, ArrayList<ArrayList<ItemStack>> costs) {
        int numAttacks = buf.readInt();
        for (int i = 0; i < numAttacks; ++i) {
            attackList.add(new Attack(ByteBufUtils.readUTF8String((ByteBuf)buf)));
            int numCosts = buf.readInt();
            ArrayList<ItemStack> cost = new ArrayList<ItemStack>(numCosts);
            for (int j = 0; j < numCosts; ++j) {
                ItemStack current = new ItemStack(Item.func_150899_d((int)buf.readInt()), buf.readInt());
                current.func_77964_b(buf.readInt());
                cost.add(current);
            }
            costs.add(cost);
        }
    }
}

