/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.UpdatePixelmonMovementPacket;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity5Battle;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.FlyMode;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.PixelmonMoveHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.PixelmonMovementBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.PixelmonMovementFlying;
import com.pixelmonmod.pixelmon.entities.pixelmon.movement.PixelmonMovementGround;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.RidingOffsets;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumKeybinds;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.List;
import javax.vecmath.Vector3f;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Entity6Moves
extends Entity5Battle {
    public static boolean printDebugLines = true;
    private static final String NBT_FLY_HEIGHT = "flyheight";
    private static final String NBT_IS_FLYING = "isFly";
    protected static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(Entity6Moves.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final String NBT_CAN_FLY = "canfly";
    protected static final DataParameter<Boolean> HOVERING = EntityDataManager.func_187226_a(Entity6Moves.class, (DataSerializer)DataSerializers.field_187198_h);
    public int baseFlyHeight = 30;
    public int baseSwimDepth = 5;
    private int flyHeight = -1;
    private int swimDepth = -1;
    public float fallRate = 0.04f;
    public float strafeUpDown = 0.0f;
    public float hoverRotationPitch = 20.0f;
    public float moveMultiplier = 0.3f;
    public static float maxMoveMultiplier = 1.4f;
    public static float minMoveMultiplier = 0.3f;
    public float thermalPower = 0.0f;
    public FlyData[] flyData = null;
    public boolean canFly = true;
    public boolean canFlyOverride = true;
    public boolean canSwim = false;
    public float rotationRoll = 0.0f;
    public float prevRotationRoll = 0.0f;
    public PixelmonMovementFlying movementFlying = new PixelmonMovementFlying(this);
    public PixelmonMovementGround movementGround = new PixelmonMovementGround(this);
    public int takeOffTicks = 0;
    public boolean lastFlyingState = false;
    Vec3d targetPosition;
    public float lastSpeed = -1.0f;
    public float lastStrafe = -1.0f;
    public float lastStrafeUp = -1.0f;
    float rotP = 0.0f;
    float rotY = 0.0f;
    float rotR = 0.0f;

    public PixelmonMovementBase getMovement() {
        if (this.getIsFlying()) {
            return this.movementFlying;
        }
        return this.movementGround;
    }

    public Entity6Moves(World worldIn) {
        super(worldIn);
        this.field_70765_h = new PixelmonMoveHelper((EntityLiving)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(HOVERING, (Object)false);
    }

    public void setIsFlying(boolean isFlying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)isFlying);
    }

    public boolean getIsFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public boolean getIsHovering() {
        return (Boolean)this.field_70180_af.func_187225_a(HOVERING);
    }

    @Override
    public boolean func_70648_aU() {
        return this.canSwim;
    }

    public void toggleHover() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        boolean hovering = (Boolean)this.field_70180_af.func_187225_a(HOVERING);
        if (this.getIsFlying() || hovering) {
            this.field_70180_af.func_187227_b(HOVERING, (Object)(!hovering ? 1 : 0));
            this.calcMoveSpeed();
            Pixelmon.network.sendToAllTracking((IMessage)new UpdatePixelmonMovementPacket(this), (Entity)this);
        }
    }

    public void handleMovement(List<EnumKeybinds> movements) {
        this.getMovement().handleMovement(movements);
        if (!this.field_70170_p.field_72995_K) {
            Pixelmon.network.sendToAllTracking((IMessage)new UpdatePixelmonMovementPacket(this), (Entity)this);
        }
    }

    public void doJump() {
        this.func_70664_aZ();
    }

    protected float func_175134_bD() {
        return (float)Math.max(0.42, (double)(super.func_175134_bD() * this.field_70131_O / 2.0f));
    }

    public void takeOff() {
        if (this.getIsHovering()) {
            this.toggleHover();
        }
        this.field_70125_A = 20.0f;
        this.lastSpeed = -1.0f;
        this.lastStrafe = -1.0f;
        this.lastStrafeUp = -1.0f;
        this.strafeUpDown = 0.0f;
        this.takeOffTicks = 20;
        if (!this.field_70170_p.field_72995_K) {
            this.moveMultiplier = 0.2f;
            this.field_70163_u += 0.3;
            Pixelmon.network.sendToAllTracking((IMessage)new UpdatePixelmonMovementPacket(this), (Entity)this);
            this.setIsFlying(true);
        }
    }

    public boolean func_82171_bF() {
        return true;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        double moveForward;
        double speed;
        float[] ret = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return;
        }
        double moveDown = Math.abs(this.field_70181_x) - 0.8;
        double d = speed = moveDown > (moveForward = (double)Math.abs(this.field_191988_bg) - 0.8) ? moveDown : moveForward;
        if (speed > 0.0) {
            this.func_184185_a(this.func_184588_d((int)speed * 6), 1.0f, 1.0f);
            this.func_70097_a(DamageSource.field_76379_h, (float)speed * 6.0f);
            int j = MathHelper.func_76128_c((double)this.field_70165_t);
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int l = MathHelper.func_76128_c((double)this.field_70161_v);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(j, k, l));
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                SoundType soundtype = iblockstate.func_177230_c().getSoundType(iblockstate, this.field_70170_p, new BlockPos(j, k, l), (Entity)this);
                this.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    public void calcMoveSpeed() {
        this.field_191988_bg = !this.getIsHovering() ? (0.2f + (this.getBaseStats().mountedFlying.upperAngleLimit - this.field_70125_A) / (this.getBaseStats().mountedFlying.upperAngleLimit - this.getBaseStats().mountedFlying.lowerAngleLimit) * this.getBaseStats().mountedFlying.maxFlySpeed + 0.1f) * this.moveMultiplier : 0.01f;
    }

    public void setTarget(Vec3d targetPosition) {
        this.targetPosition = targetPosition;
    }

    public Vec3d getTargetPosition() {
        return this.targetPosition;
    }

    @Override
    public void func_70636_d() {
        if (!this.getIsFlying()) {
            this.field_70125_A = 0.0f;
            this.rotationRoll = 0.0f;
        }
        this.getMovement().onLivingUpdate();
        if (!(this.field_70170_p.field_72995_K || !PixelmonConfig.disabledNonPlayerPixelmonMovement || this.pokemon.getStorageAndPosition() != null && this.pokemon.getStorage() != null && this.pokemon.getStorage() instanceof PlayerPartyStorage)) {
            return;
        }
        if (this.func_184179_bs() != null && this.getBaseStats() != null && !this.getIsFlying()) {
            if (this.canSurf() && this.ridingInitialised) {
                this.func_184179_bs().func_70050_g(this.initAir);
            }
            this.field_191988_bg = !this.func_184179_bs().func_70090_H() && this.canSurf() ? 0.0f : (this.field_191988_bg *= 0.4f);
            if ((double)this.field_191988_bg > -0.1 && (double)this.field_191988_bg < 0.1) {
                this.field_191988_bg = 0.0f;
            }
            if (!this.func_70090_H() && this.ridingPlayerVertical > 0) {
                if (this.field_70122_E) {
                    this.func_70664_aZ();
                    this.field_70181_x *= (double)(1.0f + (float)this.pokemon.getStat(StatsType.Speed) / 500.0f);
                } else if (this.canFly()) {
                    double moty = 0.04f + 0.06f * ((float)this.pokemon.getStat(StatsType.Speed) / 500.0f);
                    this.field_70181_x = this.field_70181_x + moty <= 0.4 ? (this.field_70181_x += moty) : (this.field_70181_x += Math.max(0.0, 0.4 - this.field_70181_x));
                    this.isFlying = true;
                }
            } else if (this.func_70090_H()) {
                if (this.ridingPlayerVertical > 0) {
                    this.field_70181_x = this.canSurf() ? (this.field_70181_x += (double)0.03f) : (this.field_70181_x += (double)0.1f);
                } else if (this.ridingPlayerVertical < 0) {
                    this.field_70181_x -= (double)0.03f;
                }
            }
            this.ridingPlayerVertical = 0;
            if (this.field_70122_E && this.isFlying) {
                this.isFlying = false;
            }
        }
        super.func_70636_d();
    }

    public void onLanding() {
    }

    public float getFlyingDirection() {
        return this.func_184179_bs().field_70177_z;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184207_aI() && this.func_184186_bw() && this.getCanFly()) {
            this.rotationRoll = 0.0f;
            EntityLivingBase passenger = (EntityLivingBase)this.func_184179_bs();
            if (passenger != null) {
                this.field_70125_A = passenger.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                strafe = passenger.field_70702_br * 0.5f;
                forward = passenger.field_191988_bg;
                if (forward <= 0.0f) {
                    forward *= 0.25f;
                }
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            super.func_191986_a(strafe, vertical, forward);
        } else {
            this.field_70747_aH = 0.02f;
            this.travelAlt(strafe, vertical, forward);
        }
    }

    public void travelAlt(float strafe, float up, float forward) {
        this.field_70138_W = 0.5f;
        SpawnLocationType location = this.getSpawnLocation();
        if (location == SpawnLocationType.AirPersistent) {
            this.field_70181_x = 0.0;
        }
        if (this.getBaseStats() == null || this.func_184188_bt().size() == 0) {
            if (this.getBaseStats() != null && !this.getBaseStats().canFly.booleanValue() && this.getSpawnLocation() == SpawnLocationType.Water && this.func_70090_H()) {
                float f4 = 0.9f;
                float f5 = 0.02f;
                float f6 = EnchantmentHelper.func_185294_d((EntityLivingBase)this);
                if (f6 > 3.0f) {
                    f6 = 3.0f;
                }
                if (!this.field_70122_E) {
                    f6 *= 0.5f;
                }
                if (f6 > 0.0f) {
                    f4 += (0.54600006f - f4) * f6 / 3.0f;
                    f5 += (this.func_70689_ay() * 1.0f - f5) * f6 / 3.0f;
                }
                this.func_191958_b(strafe, 0.0f, forward, f5);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f4;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)f4;
                this.field_70181_x -= 0.02;
                if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f, this.field_70179_y)) {
                    this.field_70181_x = 0.3f;
                }
            } else {
                super.func_191986_a(strafe, up, forward);
            }
            return;
        }
        if (this.func_184188_bt().size() > 0 && this.func_184179_bs() instanceof EntityLivingBase) {
            EntityLivingBase rider = (EntityLivingBase)this.func_184179_bs();
            if (PixelmonConfig.enablePointToSteer) {
                this.field_70126_B = this.field_70177_z = this.func_184179_bs().field_70177_z;
            }
            strafe = rider.field_70702_br * 0.5f * PixelmonServerConfig.ridingSpeedMultiplier;
            this.field_70177_z -= strafe * 10.0f;
            strafe = 0.0f;
            this.field_70125_A = this.func_184179_bs().field_70125_A * 0.5f;
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            forward = rider.field_191988_bg * PixelmonServerConfig.ridingSpeedMultiplier;
            this.moveMounted(strafe, up, forward);
            if (PixelmonConfig.enablePointToSteer) {
                rider.field_70760_ar = rider.field_70761_aq = this.field_70761_aq;
                rider.field_70126_B = rider.field_70177_z = this.field_70177_z;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double var9 = this.field_70165_t - this.field_70169_q;
            double var12 = this.field_70161_v - this.field_70166_s;
            float var11 = MathHelper.func_76133_a((double)(var9 * var9 + var12 * var12)) * 4.0f;
            if (var11 > 1.0f) {
                var11 = 1.0f;
            }
            this.field_70721_aZ += (var11 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
            if (this.field_70170_p.field_72995_K) {
                boolean bl = this.field_70122_E = !this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76141_d((float)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1)), MathHelper.func_76128_c((double)this.field_70161_v)));
            }
        }
        if (location == SpawnLocationType.AirPersistent) {
            this.field_70181_x = 0.0;
        }
        if (location == SpawnLocationType.Air && this.isFlying) {
            this.field_70181_x -= 0.01;
        }
    }

    protected void moveMounted(float strafe, float up, float forward) {
        if (this.func_184179_bs() != null && this.canSurf() && this.field_70171_ac) {
            double var9 = this.field_70163_u;
            this.func_191958_b(strafe, 0.0f, forward, this.field_70747_aH);
            this.func_70091_d(MoverType.SELF, this.field_70159_w * (double)this.mountBoost, this.field_70181_x, this.field_70179_y * (double)this.mountBoost);
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + var9, this.field_70179_y)) {
                this.field_70181_x = 0.3f;
            }
            this.field_70181_x *= (double)0.98f;
            this.field_70159_w *= (double)0.96f;
            this.field_70179_y *= (double)0.96f;
            return;
        }
        if (this.canFly() && !this.func_70090_H() && !this.func_180799_ab()) {
            float var3 = 0.91f;
            if (this.field_70122_E) {
                var3 = 0.54600006f;
                IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v)));
                if (state.func_185904_a() != Material.field_151579_a) {
                    var3 = state.func_177230_c().field_149765_K * 0.91f;
                }
            }
            float var8 = 0.16277136f / (var3 * var3 * var3);
            float var5 = this.getRideSpeed();
            var5 = this.field_70122_E ? (var5 *= 0.6f * var8) : (var5 *= 0.8f);
            this.func_191958_b(strafe, 0.0f, forward, var5);
            this.func_70091_d(MoverType.SELF, this.field_70159_w * (double)this.mountBoost, this.field_70181_x, this.field_70179_y * (double)this.mountBoost);
            var3 = 0.91f;
            if (this.field_70122_E) {
                var3 = 0.54600006f;
                IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v)));
                if (state.func_185904_a() != Material.field_151579_a) {
                    var3 = state.func_177230_c().field_149765_K * 0.91f;
                }
            }
            this.field_70181_x = !this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(new BlockPos((int)this.field_70165_t, 0, (int)this.field_70161_v)) ? (this.field_70163_u > 0.0 ? (this.field_70181_x -= 0.01) : 0.0) : (this.field_70181_x -= 0.02);
            this.field_70181_x *= (double)0.98f;
            this.field_70159_w *= (double)var3;
            this.field_70179_y *= (double)var3;
            return;
        }
        this.moveEntityRidden(strafe, forward * this.mountBoost);
        super.func_191986_a(strafe, up, forward * this.mountBoost);
    }

    private void moveEntityRidden(float strafe, float forward) {
        if (this.func_70090_H()) {
            double d0 = this.field_70163_u;
            this.func_191958_b(strafe, 0.0f, forward, 0.05f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w * (double)this.mountBoost, this.field_70181_x, this.field_70179_y * (double)this.mountBoost);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
            this.field_70181_x -= 0.019;
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d0, this.field_70179_y)) {
                this.field_70181_x = 0.3f;
            }
        } else if (this.func_180799_ab()) {
            double d0 = this.field_70163_u;
            this.func_191958_b(strafe, 0.0f, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.6;
            this.field_70181_x *= 0.6;
            this.field_70179_y *= 0.6;
            this.field_70181_x -= 0.02;
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d0, this.field_70179_y)) {
                this.field_70181_x = 0.3f;
            }
        } else {
            float sh;
            if (SpawnLocationType.containsOnly(this.getBaseStats().spawnLocations, SpawnLocationType.Water)) {
                return;
            }
            float f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = 0.54600006f;
                IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v)));
                if (state.func_185904_a() != Material.field_151579_a) {
                    f2 = state.func_177230_c().field_149765_K * 0.91f;
                }
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            float f4 = this.getRideSpeed();
            if (this.field_70122_E) {
                f4 *= f3 * 2.8f;
            }
            this.func_191958_b(strafe, 0.0f, forward, f4);
            f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = 0.54600006f;
                IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v)));
                if (state.func_185904_a() != Material.field_151579_a) {
                    f2 = state.func_177230_c().field_149765_K * 0.91f;
                }
            }
            this.field_70138_W = sh = (float)Math.ceil(this.getBaseStats().height.floatValue() * this.getScaleFactor() / 5.0f);
            this.func_70091_d(MoverType.PLAYER, this.field_70159_w * (double)this.mountBoost, this.field_70181_x, this.field_70179_y * (double)this.mountBoost);
            this.field_70181_x = this.field_70170_p.field_72995_K && (!this.field_70170_p.func_175667_e(new BlockPos((int)this.field_70165_t, 0, (int)this.field_70161_v)) || this.field_70170_p instanceof WorldServer && !((WorldServer)this.field_70170_p).func_72863_F().func_73149_a(this.field_70176_ah, this.field_70164_aj)) ? (this.field_70163_u > 0.0 ? -0.1 : 0.0) : (this.field_70181_x -= 0.04);
            this.field_70181_x *= (double)0.98f;
            this.field_70159_w *= (double)f2;
            this.field_70179_y *= (double)f2;
        }
    }

    private float getRideSpeed() {
        return 0.07f + 0.05f * (float)this.pokemon.getStat(StatsType.Speed) / 500.0f;
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        this.func_184651_r();
        this.lastSpeed = -1.0f;
        this.setIsFlying(false);
        this.field_70125_A = 0.0f;
        this.rotationRoll = 0.0f;
    }

    public int getFlyHeight() {
        if (this.flyHeight == -1) {
            int variance = (int)((float)this.baseFlyHeight / 10.0f);
            this.flyHeight = this.baseFlyHeight + this.field_70146_Z.nextInt(variance + 1) - variance / 2;
        }
        return this.flyHeight;
    }

    public int getSwimDepth() {
        if (this.swimDepth == -1) {
            int variance = (int)((float)this.baseSwimDepth / 10.0f);
            this.swimDepth = this.baseSwimDepth + this.field_70146_Z.nextInt(variance + 1) - variance / 2;
        }
        return this.swimDepth;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a(NBT_FLY_HEIGHT, this.getFlyHeight());
        compound.func_74757_a(NBT_CAN_FLY, this.canFly);
        compound.func_74757_a(NBT_IS_FLYING, this.getIsFlying());
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.flyHeight = compound.func_74762_e(NBT_FLY_HEIGHT);
        this.canFly = compound.func_74767_n(NBT_CAN_FLY);
        this.setIsFlying(compound.func_74767_n(NBT_IS_FLYING));
        super.func_70037_a(compound);
    }

    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        if (this.getIsFlying()) {
            double d3 = this.field_70165_t - p_145770_1_;
            double d5 = this.field_70161_v - p_145770_5_;
            double d6 = d3 * d3 + d5 * d5;
            return this.func_70112_a(d6);
        }
        double d3 = this.field_70165_t - p_145770_1_;
        double d4 = this.field_70163_u - p_145770_3_;
        double d5 = this.field_70161_v - p_145770_5_;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.func_70112_a(d6);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 1200.0 * 1.0) * d0;
    }

    public void setCanFly(boolean canFly) {
        this.canFly = canFly;
    }

    public boolean getCanFly() {
        return this.getBaseStats().mountedFlying != null;
    }

    public void func_184232_k(Entity passenger) {
        if (this.getBaseStats() != null) {
            try {
                if (this.getBaseStats().ridingOffsets == null) {
                    this.getBaseStats().ridingOffsets = new RidingOffsets();
                }
                Vector3f offsets = this.getBaseStats().ridingOffsets.standing != null ? this.getBaseStats().ridingOffsets.standing : new Vector3f();
                if (this.getBaseStats().ridingOffsets.moving != null && (this.flyingDelayCounter >= flyingDelayLimit || this.getUsingRidingSpecialConditions())) {
                    offsets = this.getBaseStats().ridingOffsets.moving;
                }
                if (this.func_184196_w(passenger) && this.getIsFlying()) {
                    this.getMovement().updatePassenger(passenger, offsets);
                } else {
                    Vec3d vec = new Vec3d((double)(offsets.x * this.getPixelmonScale() * this.getScaleFactor()), (double)((offsets.y + this.field_70131_O) * this.getPixelmonScale() * this.getScaleFactor()), (double)(offsets.z * this.getPixelmonScale() * this.getScaleFactor()));
                    vec = vec.func_178785_b(-1.0f * this.field_70761_aq * (float)Math.PI / 180.0f);
                    passenger.func_70107_b(this.field_70165_t + vec.field_72450_a, this.field_70163_u + vec.field_72448_b, this.field_70161_v + vec.field_72449_c);
                }
            }
            catch (Exception e) {
                passenger.func_184210_p();
            }
        }
    }

    public abstract SoundEvent getFlyingSound();

    public boolean getStaysHorizontalInRender() {
        if (this.getBaseStats() == null || this.getBaseStats().mountedFlying == null) {
            return false;
        }
        return this.getBaseStats().mountedFlying.staysHorizontalFlying;
    }

    public class FlyData {
        public FlyMode mode;
        public int probability;

        public FlyData(FlyMode mode, int probability) {
            this.mode = mode;
            this.probability = probability;
        }
    }
}

