/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.helpers;

import com.pixelmonmod.pixelmon.AI.AIExecuteAction;
import com.pixelmonmod.pixelmon.AI.AIFlying;
import com.pixelmonmod.pixelmon.AI.AIFlyingPersistent;
import com.pixelmonmod.pixelmon.AI.AIIsInBattle;
import com.pixelmonmod.pixelmon.AI.AIMoveTowardsBlock;
import com.pixelmonmod.pixelmon.AI.AIMoveTowardsTarget;
import com.pixelmonmod.pixelmon.AI.AISwimming;
import com.pixelmonmod.pixelmon.AI.AITargetNearest;
import com.pixelmonmod.pixelmon.AI.AITeleportAway;
import com.pixelmonmod.pixelmon.AI.AITempt;
import com.pixelmonmod.pixelmon.AI.AIWander;
import com.pixelmonmod.pixelmon.blocks.enums.EnumSpawnerAggression;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity4Interactions;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumAggression;
import com.pixelmonmod.pixelmon.enums.EnumType;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigateGround;

public class AIHelper {
    int i = 0;

    public AIHelper(String name, Entity4Interactions entity, EntityAITasks tasks) {
        EntityPixelmon pix = (EntityPixelmon)entity;
        if (!tasks.field_75782_a.isEmpty()) {
            tasks.field_75782_a.clear();
        }
        this.initBaseAI(pix, tasks);
        if (!(pix.getSpawnLocation() != SpawnLocationType.Land || entity.getBaseStats().canFly.booleanValue() || entity.getBaseStats().isRideable.booleanValue() && entity.getBaseStats().getTypeList().contains(EnumType.Water))) {
            this.initGroundAI(name, pix, tasks);
        } else if (entity.getBaseStats().canFly.booleanValue() && entity.getFlyingParameters() != null) {
            if (pix.getSpawnLocation() == SpawnLocationType.AirPersistent) {
                this.initFlyingPersistentAI(name, pix, tasks);
            } else {
                this.initFlyingAI(name, pix, tasks);
            }
        } else if (pix.getSpawnLocation() == SpawnLocationType.Water) {
            this.initSwimmingAI(name, pix, tasks);
        } else {
            this.initGroundAI(name, pix, tasks);
        }
    }

    private void initFlyingPersistentAI(String name, EntityPixelmon entity, EntityAITasks tasks) {
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)entity, 1.0, 10.0f, 4.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AITempt((EntityCreature)entity, false, PixelmonItems.rareCandy, PixelmonItems.mint));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIFlyingPersistent(entity));
    }

    private void initSwimmingAI(String name, EntityPixelmon entity, EntityAITasks tasks) {
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)entity, 1.0, 10.0f, 4.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AITempt((EntityCreature)entity, false, PixelmonItems.rareCandy, PixelmonItems.mint));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AISwimming(entity));
    }

    private void initFlyingAI(String name, EntityPixelmon entity, EntityAITasks tasks) {
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)entity, 1.0, 10.0f, 4.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AITempt((EntityCreature)entity, false, PixelmonItems.rareCandy, PixelmonItems.mint));
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)entity, EntityPixelmon.class, 8.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIFlying(entity));
    }

    private void initBaseAI(EntityPixelmon entity, EntityAITasks tasks) {
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIIsInBattle(entity));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIMoveTowardsTarget((EntityCreature)entity, 15.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIExecuteAction((EntityCreature)entity));
        if (!(entity.getSpawnLocation() == SpawnLocationType.Water || entity.getBaseStats().isRideable.booleanValue() && entity.getBaseStats().getTypeList().contains(EnumType.Water))) {
            if ((PixelmonConfig.isAggressionAllowed || entity.spawner != null && entity.spawner.aggression == EnumSpawnerAggression.Aggressive) && entity.aggression == EnumAggression.aggressive) {
                tasks.func_75776_a(this.i++, (EntityAIBase)new AITargetNearest((EntityCreature)entity, 10.0f, true));
            } else if (entity.aggression == EnumAggression.timid) {
                tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)entity, EntityPlayer.class, 16.0f, (double)0.23f, (double)0.4f));
            }
        }
        if (entity.func_70902_q() != null) {
            tasks.func_75776_a(this.i++, (EntityAIBase)new AIMoveTowardsBlock(entity, 25.0f));
        }
    }

    private void initGroundAI(String Name, EntityPixelmon entity, EntityAITasks tasks) {
        if (entity.getBaseStats().getTypeList().contains(EnumType.Fire)) {
            ((PathNavigateGround)entity.func_70661_as()).func_179693_d(true);
        }
        if (Name.equalsIgnoreCase("Abra")) {
            tasks.func_75776_a(this.i++, (EntityAIBase)new AITeleportAway(entity));
        } else {
            tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
            tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)entity, 1.0, 10.0f, 4.0f));
            tasks.func_75776_a(this.i++, (EntityAIBase)new AITempt((EntityCreature)entity, false, PixelmonItems.rareCandy, PixelmonItems.mint));
            tasks.func_75776_a(this.i++, (EntityAIBase)new AIWander((EntityCreature)entity));
            tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)entity, EntityPixelmon.class, 8.0f));
            tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAILookIdle((EntityLiving)entity));
        }
    }

    public void setWanderGroundAI(EntityPixelmon entity, EntityAITasks tasks) {
        tasks.field_75782_a.clear();
        ((PathNavigateGround)entity.func_70661_as()).func_179693_d(true);
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIWander((EntityCreature)entity));
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)entity, EntityPixelmon.class, 8.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAILookIdle((EntityLiving)entity));
    }
}

