/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.specs;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumPrimal;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class CanPrimalEvoSpec
extends SpecValue<Boolean>
implements ISpecType {
    public CanPrimalEvoSpec(boolean value) {
        super("canprimalevo", value);
    }

    @Override
    public List<String> getKeys() {
        return Lists.newArrayList((Object[])new String[]{"canprimalevo", "canprimal", "canprimalrevert", "canprimalevolve"});
    }

    @Override
    public SpecValue<?> parse(@Nullable String arg) {
        try {
            return new CanPrimalEvoSpec(arg == null || Boolean.parseBoolean(arg));
        }
        catch (Exception e) {
            return new CanPrimalEvoSpec(true);
        }
    }

    @Override
    public SpecValue<?> readFromNBT(NBTTagCompound nbt) {
        return new CanPrimalEvoSpec(nbt.func_74767_n(this.key));
    }

    public void writeToNBT(NBTTagCompound nbt, SpecValue value) {
        nbt.func_74757_a(this.key, ((Boolean)value.value).booleanValue());
    }

    @Override
    public Class<? extends SpecValue<?>> getSpecClass() {
        return CanPrimalEvoSpec.class;
    }

    @Override
    public String toParameterForm(SpecValue<?> value) {
        return this.key + ":" + value.value.toString();
    }

    @Override
    public Class<Boolean> getValueClass() {
        return Boolean.class;
    }

    @Override
    public void apply(EntityPixelmon pixelmon) {
    }

    @Override
    public void apply(Pokemon pokemon) {
    }

    @Override
    public boolean matches(EntityPixelmon pixelmon) {
        return this.matches(pixelmon.getPokemonData());
    }

    @Override
    public boolean matches(Pokemon pokemon) {
        if (pokemon.getSpecies() == EnumSpecies.Groudon) {
            return pokemon.getFormEnum() == EnumPrimal.PRIMAL || pokemon.getHeldItemAsItemHeld() == PixelmonItemsHeld.redOrb;
        }
        if (pokemon.getSpecies() == EnumSpecies.Kyogre) {
            return pokemon.getFormEnum() == EnumPrimal.PRIMAL || pokemon.getHeldItemAsItemHeld() == PixelmonItemsHeld.blueOrb;
        }
        return false;
    }

    @Override
    public SpecValue<Boolean> clone() {
        return new CanPrimalEvoSpec((Boolean)this.value);
    }
}

