/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.EvolveEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvoConditionTypeAdapter;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionTypeAdapter;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.HeldItemCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.InteractEvolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.TickingEvolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.TradeEvolution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class Evolution {
    public static HashMap<String, Class<? extends Evolution>> evolutionTypes = new HashMap();
    public static final Gson EVOLUTION_GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Evolution.class, (Object)new EvolutionTypeAdapter()).registerTypeAdapter(EvoCondition.class, (Object)new EvoConditionTypeAdapter()).registerTypeAdapter(PokemonSpec.class, (Object)PokemonSpec.SPEC_ADAPTER).create();
    public PokemonSpec to;
    public ArrayList<EvoCondition> conditions = new ArrayList();
    public ArrayList<String> moves = new ArrayList();
    public String evoType;

    public Evolution(String evoType) {
        this.evoType = evoType;
    }

    public Evolution(String evoType, PokemonSpec to, EvoCondition ... conditions) {
        this(evoType);
        this.to = to;
        this.conditions.addAll(Arrays.asList(conditions));
    }

    protected boolean canEvolve(EntityPixelmon pokemon) {
        if (pokemon.func_110143_aJ() < 1.0f) {
            return false;
        }
        if (this.conditions != null) {
            for (EvoCondition condition : this.conditions) {
                if (condition.passes(pokemon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean doEvolution(EntityPixelmon pixelmon) {
        if (!Pixelmon.EVENT_BUS.post((Event)new EvolveEvent.PreEvolve((EntityPlayerMP)pixelmon.func_70902_q(), pixelmon, this))) {
            pixelmon.startEvolution(this);
            return true;
        }
        return false;
    }

    public void finishedEvolving(EntityPixelmon pokemon) {
        if (this.consumesHeldItem()) {
            pokemon.getPokemonData().setHeldItem(ItemStack.field_190927_a);
            pokemon.update(EnumUpdateType.HeldItem);
        }
    }

    public boolean consumesHeldItem() {
        if (this.conditions == null) {
            return false;
        }
        for (EvoCondition condition : this.conditions) {
            if (!(condition instanceof HeldItemCondition)) continue;
            return true;
        }
        return false;
    }

    public <T extends EvoCondition> List<T> getConditionsOfType(Class<T> clazz) {
        if (this.conditions == null) {
            return Arrays.asList(new EvoCondition[0]);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (EvoCondition condition : this.conditions) {
            if (!clazz.isInstance(condition)) continue;
            list.add(clazz.cast(condition));
        }
        return list;
    }

    static {
        evolutionTypes.put("leveling", LevelingEvolution.class);
        evolutionTypes.put("trade", TradeEvolution.class);
        evolutionTypes.put("interact", InteractEvolution.class);
        evolutionTypes.put("ticking", TickingEvolution.class);
    }
}

