/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public interface ITechnicalMove {
    public int getId();

    public String getAttackName();

    default public AttackBase getAttack() {
        return AttackBase.getAttackBaseFromEnglishName(this.getAttackName()).orElse(null);
    }

    public static class Adapter
    implements JsonDeserializer<ITechnicalMove>,
    JsonSerializer<ITechnicalMove> {
        public JsonElement serialize(ITechnicalMove src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getId());
        }

        public ITechnicalMove deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (typeOfT == Gen8TechnicalMachines.class) {
                return (ITechnicalMove)Gen8TechnicalMachines.idMap.get(json.getAsInt());
            }
            if (typeOfT == Gen8TechnicalRecords.class) {
                return (ITechnicalMove)Gen8TechnicalRecords.idMap.get(json.getAsInt());
            }
            throw new RuntimeException("Technical record subclass not programed for serialization");
        }
    }

    public static enum Gen8TechnicalMachines implements ITechnicalMove
    {
        MegaPunch(0, "Mega Punch"),
        MegaKick(1, "Mega Kick"),
        PayDay(2, "Pay Day"),
        FirePunch(3, "Fire Punch"),
        IcePunch(4, "Ice Punch"),
        ThunderPunch(5, "Thunder Punch"),
        Fly(6, "Fly"),
        PinMissile(7, "Pin Missile"),
        HyperBeam(8, "Hyper Beam"),
        GigaImpact(9, "Giga Impact"),
        MagicalLeaf(10, "Magical Leaf"),
        SolarBeam(11, "Solar Beam"),
        SolarBlade(12, "Solar Blade"),
        FireSpin(13, "Fire Spin"),
        ThunderWave(14, "Thunder Wave"),
        Dig(15, "Dig"),
        Screech(16, "Screech"),
        LightScreen(17, "Light Screen"),
        Reflect(18, "Reflect"),
        Safeguard(19, "Safeguard"),
        Self_Destruct(20, "Self-Destruct"),
        Rest(21, "Rest"),
        RockSlide(22, "Rock Slide"),
        Thief(23, "Thief"),
        Snore(24, "Snore"),
        Protect(25, "Protect"),
        ScaryFace(26, "Scary Face"),
        IcyWind(27, "Icy Wind"),
        GigaDrain(28, "Giga Drain"),
        Charm(29, "Charm"),
        SteelWing(30, "Steel Wing"),
        Attract(31, "Attract"),
        Sandstorm(32, "Sandstorm"),
        RainDance(33, "Rain Dance"),
        SunnyDay(34, "Sunny Day"),
        Hail(35, "Hail"),
        Whirlpool(36, "Whirlpool"),
        BeatUp(37, "Beat Up"),
        Will_O_Wisp(38, "Will-O-Wisp"),
        Facade(39, "Facade"),
        Swift(40, "Swift"),
        HelpingHand(41, "Helping Hand"),
        Revenge(42, "Revenge"),
        BrickBreak(43, "Brick Break"),
        Imprison(44, "Imprison"),
        Dive(45, "Dive"),
        WeatherBall(46, "Weather Ball"),
        FakeTears(47, "Fake Tears"),
        RockTomb(48, "Rock Tomb"),
        SandTomb(49, "Sand Tomb"),
        BulletSeed(50, "Bullet Seed"),
        IcicleSpear(51, "Icicle Spear"),
        Bounce(52, "Bounce"),
        MudShot(53, "Mud Shot"),
        RockBlast(54, "Rock Blast"),
        Brine(55, "Brine"),
        U_turn(56, "U-turn"),
        Payback(57, "Payback"),
        Assurance(58, "Assurance"),
        Fling(59, "Fling"),
        PowerSwap(60, "Power Swap"),
        GuardSwap(61, "Guard Swap"),
        SpeedSwap(62, "Speed Swap"),
        DrainPunch(63, "Drain Punch"),
        Avalanche(64, "Avalanche"),
        ShadowClaw(65, "Shadow Claw"),
        ThunderFang(66, "Thunder Fang"),
        IceFang(67, "Ice Fang"),
        FireFang(68, "Fire Fang"),
        PsychoCut(69, "Psycho Cut"),
        TrickRoom(70, "Trick Room"),
        WonderRoom(71, "Wonder Room"),
        MagicRoom(72, "Magic Room"),
        CrossPoison(73, "Cross Poison"),
        Venoshock(74, "Venoshock"),
        LowSweep(75, "Low Sweep"),
        Round(76, "Round"),
        Hex(77, "Hex"),
        Acrobatics(78, "Acrobatics"),
        Retaliate(79, "Retaliate"),
        VoltSwitch(80, "Volt Switch"),
        Bulldoze(81, "Bulldoze"),
        Electroweb(82, "Electroweb"),
        RazorShell(83, "Razor Shell"),
        TailSlap(84, "Tail Slap"),
        Snarl(85, "Snarl"),
        PhantomForce(86, "Phantom Force"),
        DrainingKiss(87, "Draining Kiss"),
        GrassyTerrain(88, "Grassy Terrain"),
        MistyTerrain(89, "Misty Terrain"),
        ElectricTerrain(90, "Electric Terrain"),
        PsychicTerrain(91, "Psychic Terrain"),
        MysticalFire(92, "Mystical Fire"),
        EerieImpulse(93, "Eerie Impulse"),
        FalseSwipe(94, "False Swipe"),
        AirSlash(95, "Air Slash"),
        SmartStrike(96, "Smart Strike"),
        BrutalSwing(97, "Brutal Swing"),
        StompingTantrum(98, "Stomping Tantrum"),
        BreakingSwipe(99, "Breaking Swipe");

        private final int id;
        private final String attackName;
        private static final Gen8TechnicalMachines[] VALUES;
        private static final Map<Integer, Gen8TechnicalMachines> idMap;
        private static final Map<String, Gen8TechnicalMachines> nameMap;

        private Gen8TechnicalMachines(int id, String attackName) {
            this.id = id;
            this.attackName = attackName;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getAttackName() {
            return this.attackName;
        }

        public static ITechnicalMove getTm(int id) {
            return idMap.get(id);
        }

        public static ITechnicalMove getTm(String attackName) {
            return nameMap.get(attackName);
        }

        static {
            VALUES = Gen8TechnicalMachines.values();
            idMap = new Int2ObjectArrayMap(VALUES.length);
            nameMap = new HashMap<String, Gen8TechnicalMachines>(VALUES.length);
            for (Gen8TechnicalMachines tm : VALUES) {
                idMap.put(tm.id, tm);
                nameMap.put(tm.attackName, tm);
            }
        }
    }

    public static enum Gen8TechnicalRecords implements ITechnicalMove
    {
        SwordsDance(0, "Swords Dance"),
        BodySlam(1, "Body Slam"),
        Flamethrower(2, "Flamethrower"),
        HydroPump(3, "Hydro Pump"),
        Surf(4, "Surf"),
        IceBeam(5, "Ice Beam"),
        Blizzard(6, "Blizzard"),
        LowKick(7, "Low Kick"),
        Thunderbolt(8, "Thunderbolt"),
        Thunder(9, "Thunder"),
        Earthquake(10, "Earthquake"),
        Psychic(11, "Psychic"),
        Agility(12, "Agility"),
        FocusEnergy(13, "Focus Energy"),
        Metronome(14, "Metronome"),
        FireBlast(15, "Fire Blast"),
        Waterfall(16, "Waterfall"),
        Amnesia(17, "Amnesia"),
        LeechLife(18, "Leech Life"),
        TriAttack(19, "Tri Attack"),
        Substitute(20, "Substitute"),
        Reversal(21, "Reversal"),
        SludgeBomb(22, "Sludge Bomb"),
        Spikes(23, "Spikes"),
        Outrage(24, "Outrage"),
        Psyshock(25, "Psyshock"),
        Endure(26, "Endure"),
        SleepTalk(27, "Sleep Talk"),
        Megahorn(28, "Megahorn"),
        BatonPass(29, "Baton Pass"),
        Encore(30, "Encore"),
        IronTail(31, "Iron Tail"),
        Crunch(32, "Crunch"),
        ShadowBall(33, "Shadow Ball"),
        FutureSight(34, "Future Sight"),
        Uproar(35, "Uproar"),
        HeatWave(36, "Heat Wave"),
        Taunt(37, "Taunt"),
        Trick(38, "Trick"),
        Superpower(39, "Superpower"),
        SkillSwap(40, "Skill Swap"),
        BlazeKick(41, "Blaze Kick"),
        HyperVoice(42, "Hyper Voice"),
        Overheat(43, "Overheat"),
        CosmicPower(44, "Cosmic Power"),
        MuddyWater(45, "Muddy Water"),
        IronDefense(46, "Iron Defense"),
        DragonClaw(47, "Dragon Claw"),
        BulkUp(48, "Bulk Up"),
        CalmMind(49, "Calm Mind"),
        LeafBlade(50, "Leaf Blade"),
        DragonDance(51, "Dragon Dance"),
        GyroBall(52, "Gyro Ball"),
        CloseCombat(53, "Close Combat"),
        ToxicSpikes(54, "Toxic Spikes"),
        FlareBlitz(55, "Flare Blitz"),
        AuraSphere(56, "Aura Sphere"),
        PoisonJab(57, "Poison Jab"),
        DarkPulse(58, "Dark Pulse"),
        SeedBomb(59, "Seed Bomb"),
        X_Scissor(60, "X-Scissor"),
        BugBuzz(61, "Bug Buzz"),
        DragonPulse(62, "Dragon Pulse"),
        PowerGem(63, "Power Gem"),
        FocusBlast(64, "Focus Blast"),
        EnergyBall(65, "Energy Ball"),
        BraveBird(66, "Brave Bird"),
        EarthPower(67, "Earth Power"),
        NastyPlot(68, "Nasty Plot"),
        ZenHeadbutt(69, "Zen Headbutt"),
        FlashCannon(70, "Flash Cannon"),
        LeafStorm(71, "Leaf Storm"),
        PowerWhip(72, "Power Whip"),
        GunkShot(73, "Gunk Shot"),
        IronHead(74, "Iron Head"),
        StoneEdge(75, "Stone Edge"),
        StealthRock(76, "Stealth Rock"),
        GrassKnot(77, "Grass Knot"),
        SludgeWave(78, "Sludge Wave"),
        HeavySlam(79, "Heavy Slam"),
        ElectroBall(80, "Electro Ball"),
        FoulPlay(81, "Foul Play"),
        StoredPower(82, "Stored Power"),
        AllySwitch(83, "Ally Switch"),
        Scald(84, "Scald"),
        WorkUp(85, "Work Up"),
        WildCharge(86, "Wild Charge"),
        DrillRun(87, "Drill Run"),
        HeatCrash(88, "Heat Crash"),
        Hurricane(89, "Hurricane"),
        PlayRough(90, "Play Rough"),
        VenomDrench(91, "Venom Drench"),
        DazzlingGleam(92, "Dazzling Gleam"),
        DarkestLariat(93, "Darkest Lariat"),
        HighHorsepower(94, "High Horsepower"),
        ThroatChop(95, "Throat Chop"),
        PollenPuff(96, "Pollen Puff"),
        PsychicFangs(97, "Psychic Fangs"),
        Liquidation(98, "Liquidation"),
        BodyPress(99, "Body Press");

        private final int id;
        private final String attackName;
        private static final Gen8TechnicalRecords[] VALUES;
        private static final Map<Integer, Gen8TechnicalRecords> idMap;
        private static final Map<String, Gen8TechnicalRecords> nameMap;

        private Gen8TechnicalRecords(int id, String attackName) {
            this.id = id;
            this.attackName = attackName;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getAttackName() {
            return this.attackName;
        }

        public static ITechnicalMove getTr(int id) {
            return idMap.get(id);
        }

        public static ITechnicalMove getTr(String attackName) {
            return nameMap.get(attackName);
        }

        static {
            VALUES = Gen8TechnicalRecords.values();
            idMap = new Int2ObjectArrayMap(VALUES.length);
            nameMap = new HashMap<String, Gen8TechnicalRecords>(VALUES.length);
            for (Gen8TechnicalRecords tr : VALUES) {
                idMap.put(tr.id, tr);
                nameMap.put(tr.attackName, tr);
            }
        }
    }
}

